package com.ejianc.business.oa.controller.api;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.oa.bean.MattersApplyEntity;
import com.ejianc.business.oa.service.IMattersApplyService;
import com.ejianc.business.oa.vo.MattersApplyApiVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/mattersApplyApi/")
public class MattersApplyApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IMattersApplyService applyService;

    /**
     * updMattersApplyUseBy
     *
     */
    @RequestMapping(value = "updMattersApplyUseBy", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updMattersApplyUseBy(@RequestBody MattersApplyApiVO mattersApplyApiVO) {
        List<Long> usedIds = mattersApplyApiVO.getUsedIds();
        if (CollectionUtils.isNotEmpty(usedIds)) {
            LambdaUpdateWrapper<MattersApplyEntity> usedWrapper = new LambdaUpdateWrapper<>();
            usedWrapper.in(MattersApplyEntity::getId, usedIds);
            usedWrapper.set(MattersApplyEntity::getUseBy, mattersApplyApiVO.getUseBy());
            applyService.update(usedWrapper);
        }
        List<Long> unusedIds = mattersApplyApiVO.getUnusedIds();
        if (CollectionUtils.isNotEmpty(unusedIds)) {
            LambdaUpdateWrapper<MattersApplyEntity> unusedWrapper = new LambdaUpdateWrapper<>();
            unusedWrapper.in(MattersApplyEntity::getId, unusedIds);
            unusedWrapper.set(MattersApplyEntity::getUseBy, null);
            applyService.update(unusedWrapper);
        }
        return CommonResponse.success("更新成功！");
    }


}
