/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.oa.bean.ManagementEntity;
import com.ejianc.business.oa.consts.EducationCodeEnum;
import com.ejianc.business.oa.controller.SqlParam;
import com.ejianc.business.oa.mapper.ManagementMapper;
import com.ejianc.business.oa.service.ICertRecordService;
import com.ejianc.business.oa.service.IManagementService;
import com.ejianc.business.oa.vo.ManagementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="managementService")
public class ManagementServiceImpl
extends BaseServiceImpl<ManagementMapper, ManagementEntity>
implements IManagementService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String TEMPLATE_KEY_PREFIX = "template_data_cache_market_project";
    private final String TEMPLATE_KEY_SEPRATOR = ":";
    private final int TIMEOUT = 1800;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICertRecordService certRecordService;
    @Autowired
    private ManagementMapper managementMapper;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public CommonResponse<ManagementVO> saveOrUpdate(ManagementVO saveorUpdateVO) {
        List list;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.eq(ManagementEntity::getCertCode, (Object)saveorUpdateVO.getCertCode());
        if (null != saveorUpdateVO.getId()) {
            lambda.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(list = super.list((Wrapper)lambda)))) {
            return CommonResponse.error((String)"\u8bc1\u4ef6\u7f16\u53f7\u5df2\u5b58\u5728!");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        int num = 90;
        try {
            if (1 == saveorUpdateVO.getIsTerm()) {
                saveorUpdateVO.setTermStatus(Integer.valueOf(0));
            } else {
                Date failureDate = sdf.parse(sdf.format(saveorUpdateVO.getFailureDate()));
                Date now = sdf.parse(sdf.format(new Date()));
                long nd = 86400000L;
                long diff = failureDate.getTime() - now.getTime();
                long day = diff / nd;
                if (day > (long)num) {
                    saveorUpdateVO.setTermStatus(Integer.valueOf(0));
                } else if (day <= (long)num && day >= 0L) {
                    saveorUpdateVO.setTermStatus(Integer.valueOf(1));
                } else if (day < 0L) {
                    saveorUpdateVO.setTermStatus(Integer.valueOf(2));
                }
            }
        }
        catch (Exception failureDate) {
            // empty catch block
        }
        ManagementEntity entity = (ManagementEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ManagementEntity.class));
        super.saveOrUpdate((Object)entity, false);
        ManagementVO vo = (ManagementVO)BeanMapper.map((Object)((Object)entity), ManagementVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResponse<String> saveOrUpdateBatch(List<ManagementVO> listVo) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(listVo)) {
            listVo.forEach(saveorUpdateVO -> {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                int num = 90;
                try {
                    if (1 == saveorUpdateVO.getIsTerm()) {
                        saveorUpdateVO.setTermStatus(Integer.valueOf(0));
                    } else {
                        Date failureDate = sdf.parse(sdf.format(saveorUpdateVO.getFailureDate()));
                        Date now = sdf.parse(sdf.format(new Date()));
                        long nd = 86400000L;
                        long diff = failureDate.getTime() - now.getTime();
                        long day = diff / nd;
                        if (day > (long)num) {
                            saveorUpdateVO.setTermStatus(Integer.valueOf(0));
                        } else if (day <= (long)num && day >= 0L) {
                            saveorUpdateVO.setTermStatus(Integer.valueOf(1));
                        } else if (day < 0L) {
                            saveorUpdateVO.setTermStatus(Integer.valueOf(2));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            List listEntity = BeanMapper.mapList(listVo, ManagementEntity.class);
            super.saveOrUpdateBatch((Collection)listEntity);
        }
        return CommonResponse.success((String)"\u6570\u636e\u5bfc\u5165\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> deleteBatch(List<ManagementVO> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        this.certRecordService.deleteByFk(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        JSONObject respData = new JSONObject();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ManagementVO> saveList = new ArrayList<ManagementVO>();
        ArrayList<JSONObject> errorList = new ArrayList<JSONObject>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            this.logger.info("\u63a5\u6536\u5230\u9879\u76ee\u5bfc\u5165\u6587\u4ef6\uff1a[{}]", (Object)originalFileName);
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        this.logger.info("\u9879\u76ee\u5bfc\u5165\u6587\u4ef6\u884c\u6570(\u5305\u542b\u975e\u6570\u636e\u884c)\uff1a[{}]", (Object)result.size());
        this.logger.info("\u9879\u76ee\u5bfc\u5165\u6587\u4ef6\u5185\u5bb9\uff1a[{}]", (Object)JSONObject.toJSONString((Object)result));
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            List rowData = null;
            Object dbList = null;
            ArrayList<String> saveNameList = new ArrayList<String>();
            ArrayList<String> saveCodeList = new ArrayList<String>();
            ManagementVO proInfo = null;
            for (int i = 1; i < result.size() && i < 100; ++i) {
                proInfo = new ManagementVO();
                rowData = (List)result.get(i);
                JSONObject errInfo = null;
                try {
                    errInfo = this.rowDataCheck(i, rowData, saveNameList, saveCodeList, proInfo);
                }
                catch (Exception e) {
                    return CommonResponse.error((String)"\u6587\u4ef6\u5185\u5bb9\u683c\u5f0f\u4e0d\u5408\u6cd5");
                }
                this.logger.info("\u7b2c{}\u884c\u6821\u9a8c\u7ed3\u679c\uff1a{}", (Object)(i + 1), null != errInfo ? errInfo.get((Object)"errMsg") : "\u6821\u9a8c\u901a\u8fc7\uff01");
                if (null != errInfo) {
                    proInfo = null;
                    errorList.add(errInfo);
                    continue;
                }
                proInfo.setStockStatus(Integer.valueOf(0));
                proInfo.setTermStatus(Integer.valueOf(0));
                proInfo.setType(Integer.valueOf(0));
                proInfo.setOrgId(this.sessionManager.getUserContext().getOrgId());
                proInfo.setOrgName(this.sessionManager.getUserContext().getOrgName());
                saveList.add(proInfo);
            }
            if (CollectionUtils.isNotEmpty(saveList)) {
                String key = this.getCacheKey();
                respData.put("templateKey", (Object)key);
                this.cacheManager.setex(key, (Serializable)((Object)JSONObject.toJSONString(saveList)), 1800);
            }
        }
        respData.put("successList", saveList);
        respData.put("importableNum", (Object)saveList.size());
        respData.put("errorList", errorList);
        respData.put("errorNum", errorList);
        return CommonResponse.success((Object)respData);
    }

    @Override
    public CommonResponse<JSONObject> excelImportOrg(HttpServletRequest request, HttpServletResponse response) {
        JSONObject respData = new JSONObject();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ManagementVO> saveList = new ArrayList<ManagementVO>();
        ArrayList<JSONObject> errorList = new ArrayList<JSONObject>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            this.logger.info("\u63a5\u6536\u5230\u9879\u76ee\u5bfc\u5165\u6587\u4ef6\uff1a[{}]", (Object)originalFileName);
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        this.logger.info("\u9879\u76ee\u5bfc\u5165\u6587\u4ef6\u884c\u6570(\u5305\u542b\u975e\u6570\u636e\u884c)\uff1a[{}]", (Object)result.size());
        this.logger.info("\u9879\u76ee\u5bfc\u5165\u6587\u4ef6\u5185\u5bb9\uff1a[{}]", (Object)JSONObject.toJSONString((Object)result));
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            List rowData = null;
            Object dbList = null;
            ArrayList<String> saveNameList = new ArrayList<String>();
            ArrayList<String> saveCodeList = new ArrayList<String>();
            ManagementVO proInfo = null;
            for (int i = 1; i < result.size() && i < 100; ++i) {
                proInfo = new ManagementVO();
                rowData = (List)result.get(i);
                JSONObject errInfo = null;
                try {
                    errInfo = this.rowDataCheckOrg(i, rowData, saveNameList, saveCodeList, proInfo);
                }
                catch (Exception e) {
                    return CommonResponse.error((String)"\u6587\u4ef6\u5185\u5bb9\u683c\u5f0f\u4e0d\u5408\u6cd5");
                }
                this.logger.info("\u7b2c{}\u884c\u6821\u9a8c\u7ed3\u679c\uff1a{}", (Object)(i + 1), null != errInfo ? errInfo.get((Object)"errMsg") : "\u6821\u9a8c\u901a\u8fc7\uff01");
                if (null != errInfo) {
                    proInfo = null;
                    errorList.add(errInfo);
                    continue;
                }
                proInfo.setStockStatus(Integer.valueOf(0));
                proInfo.setTermStatus(Integer.valueOf(0));
                proInfo.setType(Integer.valueOf(1));
                proInfo.setOrgId(this.sessionManager.getUserContext().getOrgId());
                proInfo.setOrgName(this.sessionManager.getUserContext().getOrgName());
                saveList.add(proInfo);
            }
            if (CollectionUtils.isNotEmpty(saveList)) {
                String key = this.getCacheKey();
                respData.put("templateKey", (Object)key);
                this.cacheManager.setex(key, (Serializable)((Object)JSONObject.toJSONString(saveList)), 1800);
            }
        }
        respData.put("successList", saveList);
        respData.put("importableNum", (Object)saveList.size());
        respData.put("errorList", errorList);
        respData.put("errorNum", errorList);
        return CommonResponse.success((Object)respData);
    }

    private String getCacheKey() {
        return "template_data_cache_market_project:" + InvocationInfoProxy.getUserid() + ":" + System.currentTimeMillis();
    }

    private JSONObject generateErrorRow(int rowNum, List<String> rowData, String msg) {
        JSONObject error = new JSONObject();
        error.put("rowNum", (Object)rowNum);
        error.put("certCode", (Object)rowData.get(9));
        error.put("certName", (Object)rowData.get(8));
        error.put("effectiveDate", (Object)rowData.get(10));
        error.put("errMsg", (Object)msg);
        return error;
    }

    private JSONObject generateErrorRowOrg(int rowNum, List<String> rowData, String msg) {
        JSONObject error = new JSONObject();
        error.put("rowNum", (Object)rowNum);
        error.put("certCode", (Object)rowData.get(2));
        error.put("certName", (Object)rowData.get(1));
        error.put("effectiveDate", (Object)rowData.get(3));
        error.put("errMsg", (Object)msg);
        return error;
    }

    private JSONObject rowDataCheck(int rowNum, List<String> rowData, List<String> curVlidProNameList, List<String> curVlidProCodeList, ManagementVO proInfo) throws Exception {
        String date;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String personalType = rowData.get(0);
        String name = rowData.get(1);
        String telephone = rowData.get(2);
        String sex = rowData.get(3);
        String idNumber = rowData.get(4);
        String educationName = rowData.get(5);
        String major = rowData.get(6);
        String certTypeName = rowData.get(7);
        String certName = rowData.get(8);
        String certCode = rowData.get(9);
        String effectiveDate = rowData.get(10);
        String failureDate = rowData.get(11);
        String certStatus = rowData.get(12);
        String office = rowData.get(13);
        String storageLocation = rowData.get(14);
        String memo = rowData.get(15);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isBlank((CharSequence)personalType)) {
            return this.generateErrorRow(rowNum, rowData, "\u4eba\u5458\u7c7b\u522b\u4e3a\u7a7a");
        }
        proInfo.setPersonalType(Integer.valueOf(1));
        if (StringUtils.isBlank((CharSequence)name)) {
            return this.generateErrorRow(rowNum, rowData, "\u59d3\u540d\u4e3a\u7a7a");
        }
        proInfo.setName(name);
        if (StringUtils.isBlank((CharSequence)telephone)) {
            return this.generateErrorRow(rowNum, rowData, "\u8054\u7cfb\u7535\u8bdd\u4e3a\u7a7a");
        }
        BigDecimal bd = new BigDecimal(telephone);
        proInfo.setTelephone(bd.toPlainString());
        if (StringUtils.isBlank((CharSequence)sex)) {
            return this.generateErrorRow(rowNum, rowData, "\u6027\u522b\u4e3a\u7a7a");
        }
        if ("\u5973".equals(sex)) {
            proInfo.setSex(Integer.valueOf(1));
        } else {
            proInfo.setSex(Integer.valueOf(0));
        }
        proInfo.setIdNumber(idNumber);
        proInfo.setEducationCode(EducationCodeEnum.getCodeByName((String)educationName));
        proInfo.setMajor(major);
        proInfo.setOffice(office);
        proInfo.setStorageLocation(storageLocation);
        proInfo.setMemo(memo);
        if (StringUtils.isBlank((CharSequence)certTypeName)) {
            return this.generateErrorRow(rowNum, rowData, "\u8bc1\u4ef6\u7c7b\u522b\u4e3a\u7a7a");
        }
        CommonResponse docres = this.defdocApi.getDefDocByName(Long.valueOf(403601896173207615L), certTypeName);
        if (!docres.isSuccess() || null == docres.getData()) {
            return this.generateErrorRow(rowNum, rowData, "\u6863\u6848\u4e2d\u65e0\u8be5\u8bc1\u7167\u7c7b\u522b(\u4e2a\u4eba)\u9879");
        }
        proInfo.setCertTypeId(((DefdocDetailVO)docres.getData()).getId());
        proInfo.setCertTypeName(((DefdocDetailVO)docres.getData()).getName());
        if (StringUtils.isBlank((CharSequence)failureDate)) {
            proInfo.setIsTerm(Integer.valueOf(1));
        } else {
            proInfo.setIsTerm(Integer.valueOf(0));
        }
        if (StringUtils.isBlank((CharSequence)certName)) {
            return this.generateErrorRow(rowNum, rowData, "\u8bc1\u4ef6\u540d\u79f0\u4e3a\u7a7a");
        }
        proInfo.setCertName(certName);
        if (StringUtils.isBlank((CharSequence)certCode)) {
            return this.generateErrorRow(rowNum, rowData, "\u8bc1\u4ef6\u7f16\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)effectiveDate)) {
            return this.generateErrorRow(rowNum, rowData, "\u751f\u6548\u65f6\u95f4\u4e3a\u7a7a");
        }
        try {
            if (effectiveDate.contains("-")) {
                proInfo.setEffectiveDate(simpleDateFormat.parse(effectiveDate));
            } else {
                date = this.getDate(Integer.parseInt(effectiveDate));
                proInfo.setEffectiveDate(simpleDateFormat.parse(date));
            }
        }
        catch (Exception e) {
            return this.generateErrorRow(rowNum, rowData, "\u751f\u6548\u65f6\u95f4\u8f6c\u6362\u9519\u8bef");
        }
        if (StringUtils.isNotBlank((CharSequence)failureDate)) {
            try {
                if (failureDate.contains("-")) {
                    proInfo.setFailureDate(simpleDateFormat.parse(failureDate));
                } else {
                    date = this.getDate(Integer.parseInt(failureDate));
                    proInfo.setFailureDate(simpleDateFormat.parse(date));
                }
            }
            catch (Exception e) {
                return this.generateErrorRow(rowNum, rowData, "\u5931\u6548\u65f6\u95f4\u8f6c\u6362\u9519\u8bef");
            }
        }
        if (StringUtils.isBlank((CharSequence)certStatus)) {
            return this.generateErrorRow(rowNum, rowData, "\u8bc1\u4e66\u4f7f\u7528\u72b6\u6001\u4e3a\u7a7a");
        }
        docres = this.defdocApi.getDefDocByName(Long.valueOf(403601428684472320L), certStatus);
        if (!docres.isSuccess() || null == docres.getData()) {
            return this.generateErrorRow(rowNum, rowData, "\u6863\u6848\u4e2d\u65e0\u8be5\u8bc1\u4e66\u4f7f\u7528\u72b6\u6001\u9879");
        }
        proInfo.setCertStatus(((DefdocDetailVO)docres.getData()).getId());
        boolean codeCheck = curVlidProCodeList.contains(certCode);
        if (!codeCheck && StringUtils.isNotBlank((CharSequence)certCode)) {
            proInfo.setTenantId(tenantId);
            proInfo.setCertCode(certCode);
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            lambda.eq(ManagementEntity::getCertCode, (Object)certCode);
            List list = super.list((Wrapper)lambda);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)list)) {
                codeCheck = true;
            } else {
                curVlidProCodeList.add(certCode);
                codeCheck = false;
            }
        }
        if (codeCheck) {
            return this.generateErrorRow(rowNum, rowData, "\u7f16\u7801\u91cd\u590d");
        }
        return null;
    }

    public String getDate(int days) {
        Calendar c = Calendar.getInstance();
        c.set(1900, 0, 1);
        c.add(5, days - 2);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(c.getTime());
        return dateString;
    }

    private JSONObject rowDataCheckOrg(int rowNum, List<String> rowData, List<String> curVlidProNameList, List<String> curVlidProCodeList, ManagementVO proInfo) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String certTypeName = rowData.get(0);
        String certName = rowData.get(1);
        String certCode = rowData.get(2);
        String effectiveDate = rowData.get(3);
        String failureDate = rowData.get(4);
        String certStatus = rowData.get(5);
        String office = rowData.get(6);
        String storageLocation = rowData.get(7);
        String memo = rowData.get(8);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isBlank((CharSequence)certTypeName)) {
            return this.generateErrorRowOrg(rowNum, rowData, "\u8bc1\u4ef6\u7c7b\u522b\u4e3a\u7a7a");
        }
        CommonResponse docres = this.defdocApi.getDefDocByName(Long.valueOf(403602819113025550L), certTypeName);
        if (!docres.isSuccess() || null == docres.getData()) {
            return this.generateErrorRowOrg(rowNum, rowData, "\u6863\u6848\u4e2d\u65e0\u8be5\u8bc1\u7167\u7c7b\u522b(\u4f01\u4e1a)\u9879");
        }
        proInfo.setCertTypeId(((DefdocDetailVO)docres.getData()).getId());
        proInfo.setCertTypeName(((DefdocDetailVO)docres.getData()).getName());
        if (StringUtils.isBlank((CharSequence)failureDate)) {
            proInfo.setIsTerm(Integer.valueOf(1));
        } else {
            proInfo.setIsTerm(Integer.valueOf(0));
        }
        if (StringUtils.isBlank((CharSequence)certName)) {
            return this.generateErrorRowOrg(rowNum, rowData, "\u8bc1\u4ef6\u540d\u79f0\u4e3a\u7a7a");
        }
        proInfo.setCertName(certName);
        if (StringUtils.isBlank((CharSequence)certCode)) {
            return this.generateErrorRowOrg(rowNum, rowData, "\u8bc1\u4ef6\u7f16\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)effectiveDate)) {
            return this.generateErrorRowOrg(rowNum, rowData, "\u751f\u6548\u65f6\u95f4\u4e3a\u7a7a");
        }
        try {
            proInfo.setEffectiveDate(simpleDateFormat.parse(effectiveDate));
        }
        catch (Exception e) {
            return this.generateErrorRowOrg(rowNum, rowData, "\u751f\u6548\u65f6\u95f4\u8f6c\u6362\u9519\u8bef");
        }
        if (StringUtils.isNotBlank((CharSequence)failureDate)) {
            try {
                proInfo.setFailureDate(simpleDateFormat.parse(failureDate));
            }
            catch (Exception e) {
                return this.generateErrorRowOrg(rowNum, rowData, "\u5931\u6548\u65f6\u95f4\u8f6c\u6362\u9519\u8bef");
            }
        }
        if (StringUtils.isBlank((CharSequence)certStatus)) {
            return this.generateErrorRowOrg(rowNum, rowData, "\u8bc1\u4e66\u4f7f\u7528\u72b6\u6001\u4e3a\u7a7a");
        }
        docres = this.defdocApi.getDefDocByName(Long.valueOf(403601428684472320L), certStatus);
        if (!docres.isSuccess() || null == docres.getData()) {
            return this.generateErrorRowOrg(rowNum, rowData, "\u6863\u6848\u4e2d\u65e0\u8be5\u8bc1\u4e66\u4f7f\u7528\u72b6\u6001\u9879");
        }
        proInfo.setCertStatus(((DefdocDetailVO)docres.getData()).getId());
        boolean codeCheck = curVlidProCodeList.contains(certCode);
        if (!codeCheck && StringUtils.isNotBlank((CharSequence)certCode)) {
            proInfo.setTenantId(tenantId);
            proInfo.setCertCode(certCode);
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            lambda.eq(ManagementEntity::getCertCode, (Object)certCode);
            List list = super.list((Wrapper)lambda);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)list)) {
                codeCheck = true;
            } else {
                curVlidProCodeList.add(certCode);
                codeCheck = false;
            }
        }
        if (codeCheck) {
            return this.generateErrorRowOrg(rowNum, rowData, "\u7f16\u7801\u91cd\u590d");
        }
        proInfo.setOffice(office);
        proInfo.setStorageLocation(storageLocation);
        proInfo.setMemo(memo);
        return null;
    }

    @Override
    public List<Map<String, Object>> queryCertExpireWarn(List<SqlParam> sqlParamList) {
        return this.managementMapper.queryCertExpireWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryCertDeferWarn(List<SqlParam> sqlParamList) {
        return this.managementMapper.queryCertDeferWarn(sqlParamList);
    }

    @Override
    public List<ManagementVO> excelExports(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("certName");
        fuzzyFields.add("certCode");
        fuzzyFields.add("name");
        fuzzyFields.add("certTypeName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("certMajor");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        if (param.getParams().containsKey("certTypeIdOrg")) {
            Parameter certTypeIdOrgPar = (Parameter)param.getParams().get("certTypeIdOrg");
            if (param.getParams().containsKey("certTypeId")) {
                Parameter certTypeIdPar = (Parameter)param.getParams().get("certTypeId");
                String certTypeId = certTypeIdPar.getValue().toString();
                String certTypeIdOrg = certTypeIdOrgPar.getValue().toString();
                certTypeIdOrgPar.setValue((Object)(certTypeIdOrg + "," + certTypeId));
            }
            param.getParams().put("certTypeId", certTypeIdOrgPar);
            param.getParams().remove("certTypeIdOrg");
        }
        IPage page = this.queryPage(param, false);
        List<Object> list = new ArrayList<ManagementVO>();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            Map<Object, Object> mapCertStatusRes = new HashMap();
            CommonResponse certStatusRes = this.defdocApi.getDefDocByDefId(Long.valueOf(403601428684472320L));
            Map<Object, Object> mapCertTypeIdRes = new HashMap();
            CommonResponse certTypeIdRes = this.defdocApi.getDefDocByDefId(Long.valueOf(403601896173207615L));
            Map<Object, Object> mapCertTypeIdOrgRes = new HashMap();
            CommonResponse certTypeIdOrgRes = this.defdocApi.getDefDocByDefId(Long.valueOf(403602819113025550L));
            if (CollectionUtils.isNotEmpty((Collection)((Collection)certStatusRes.getData()))) {
                mapCertStatusRes = ((List)certStatusRes.getData()).stream().collect(Collectors.toMap(BaseVO::getId, DefdocDetailVO::getName));
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)certTypeIdRes.getData()))) {
                mapCertTypeIdRes = ((List)certTypeIdRes.getData()).stream().collect(Collectors.toMap(BaseVO::getId, DefdocDetailVO::getName));
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)certTypeIdOrgRes.getData()))) {
                mapCertTypeIdOrgRes = ((List)certTypeIdOrgRes.getData()).stream().collect(Collectors.toMap(BaseVO::getId, DefdocDetailVO::getName));
            }
            list = BeanMapper.mapList((Iterable)page.getRecords(), ManagementVO.class);
            for (ManagementVO managementVO : list) {
                if (0 == managementVO.getType()) {
                    managementVO.setTypeName("\u4e2a\u4eba");
                    managementVO.setCertTypeName((String)mapCertTypeIdRes.get(managementVO.getCertTypeId()));
                } else {
                    managementVO.setTypeName("\u4f01\u4e1a");
                    managementVO.setCertTypeName((String)mapCertTypeIdOrgRes.get(managementVO.getCertTypeId()));
                }
                if (0 == managementVO.getStockStatus()) {
                    managementVO.setStockStatusName("\u5728\u518c");
                } else {
                    managementVO.setStockStatusName("\u501f\u51fa");
                }
                managementVO.setCertStatusName((String)mapCertStatusRes.get(managementVO.getCertStatus()));
            }
        }
        return list;
    }
}

