package com.ejianc.business.oa.controller;

import java.io.Serializable;

import com.ejianc.business.oa.bean.MonthBudgetFormDetailEntity;
import com.ejianc.business.oa.service.IMonthBudgetFormDetailService;
import com.ejianc.business.oa.vo.MonthBudgetFormDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.oa.bean.MonthBudgetFormEntity;
import com.ejianc.business.oa.service.IMonthBudgetFormService;
import com.ejianc.business.oa.vo.MonthBudgetFormVO;

/**
 * 月度收支填报主实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("monthBudgetForm")
public class MonthBudgetFormController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "MONTH_BUDGET_FORM";//此处需要根据实际修改

    @Autowired
    private IMonthBudgetFormService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMonthBudgetFormDetailService monthBudgetFormDetailService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MonthBudgetFormVO> saveOrUpdate(@RequestBody MonthBudgetFormVO saveOrUpdateVO) {
        //校验人员重复
       /* if (saveOrUpdateVO.getDetailList().size() > 1){
            Map<String, List<MonthBudgetFormDetailVO>> detailMap = saveOrUpdateVO.getDetailList().stream().filter(e -> !"del".equals(e.getRowState())).collect(Collectors.groupingBy(MonthBudgetFormDetailVO::getPersonCode));
            for (String personCode : detailMap.keySet()) {
                if (detailMap.get(personCode).size() > 1){
                    return CommonResponse.error("人员：" + detailMap.get(personCode).get(0).getPersonName() + " 重复，无法保存！");
                }
            }
        }*/

    	MonthBudgetFormEntity entity = BeanMapper.map(saveOrUpdateVO, MonthBudgetFormEntity.class);

        //保存校验年月+人员是否已有单据（包含自由态）
    	/*QueryParam detailParam = new QueryParam();
    	detailParam.getParams().put("person_id", new Parameter(QueryParam.IN, entity.getDetailList().stream().map(MonthBudgetFormDetailEntity::getPersonId).collect(Collectors.toList())));
    	detailParam.getParams().put("detail_month", new Parameter(QueryParam.EQ, entity.getMonth()));
    	if (null != entity.getId()){
            detailParam.getParams().put("pid", new Parameter(QueryParam.NE, entity.getId()));
        }
        List<MonthBudgetFormDetailEntity> existPersonList = monthBudgetFormDetailService.queryList(detailParam);
        if (CollectionUtils.isNotEmpty(existPersonList) && existPersonList.size() > 0){
            List<String> names = existPersonList.stream().map(MonthBudgetFormDetailEntity::getPersonName).collect(Collectors.toList());
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
            return CommonResponse.error("人员：" + names + "，在该月份[" + formatter.format(entity.getMonth()) + "]，有重复单据，无法保存！");
        }*/

    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	MonthBudgetFormVO vo = BeanMapper.map(service.selectById(entity.getId()), MonthBudgetFormVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MonthBudgetFormVO> queryDetail(Long id) {
    	MonthBudgetFormEntity entity = service.selectById(id);
    	MonthBudgetFormVO vo = BeanMapper.map(entity, MonthBudgetFormVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MonthBudgetFormVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (MonthBudgetFormVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MonthBudgetFormVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MonthBudgetFormVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", authOrgIds);
        if (StringUtils.isNotEmpty(authOrgIds)){
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong)
                            .collect(Collectors.toList()));
            param.getParams().put("orgId",new Parameter("in",authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }else{
            param.getParams().put("orgId",new Parameter("in",iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<MonthBudgetFormEntity> page = service.queryPage(param,false);
        IPage<MonthBudgetFormVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MonthBudgetFormVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", authOrgIds);
        if (StringUtils.isNotEmpty(authOrgIds)){
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong)
                            .collect(Collectors.toList()));
            param.getParams().put("orgId",new Parameter("in",authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }else{
            param.getParams().put("orgId",new Parameter("in",iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        List<MonthBudgetFormEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<MonthBudgetFormVO> voList = BeanMapper.mapList(list, MonthBudgetFormVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("MonthBudgetForm-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refMonthBudgetFormData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MonthBudgetFormVO>> refMonthBudgetFormData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MonthBudgetFormEntity> page = service.queryPage(param,false);
        IPage<MonthBudgetFormVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MonthBudgetFormVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }




    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "MonthBudgetFormDetail-import.xlsx", "月度收支填报-导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = service.excelImport(request,response);
        return commonResponse;
    }



    /**
     * @Description 导出月度收支填报子表信息
     * @param
     * @Return void
     */
    @RequestMapping(value = "/formDetailExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void formDetailExcelExport(@RequestBody Map paramMap, HttpServletResponse response) {

        String pid = String.valueOf(paramMap.get("pid"));
        MonthBudgetFormEntity monthBudgetFormEntity = service.selectById(pid);
        if (null == monthBudgetFormEntity){
            throw new BusinessException("请传入正确的pid！");
        }
        if (CollectionUtils.isEmpty(monthBudgetFormEntity.getDetailList())){
            throw new BusinessException("未找到对应子表，请检查pid！");
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", BeanMapper.mapList(monthBudgetFormEntity.getDetailList(), MonthBudgetFormDetailVO.class));
        ExcelExport.getInstance().export("MonthBudgetFormDetail-export.xlsx", beans, response);
    }
}
