/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.ManagementEntity;
import com.ejianc.business.oa.service.IManagementService;
import com.ejianc.business.oa.vo.ManagementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"management"})
public class ManagementController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IManagementService service;
    @Autowired
    private IDefdocApi defdocApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ManagementVO> saveOrUpdate(@RequestBody ManagementVO saveorUpdateVO) {
        return this.service.saveOrUpdate(saveorUpdateVO);
    }

    @RequestMapping(value={"/saveOrUpdateBatch"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdateBatch(@RequestBody List<ManagementVO> listVo) {
        return this.service.saveOrUpdateBatch(listVo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ManagementVO> queryDetail(Long id) {
        ManagementEntity entity = (ManagementEntity)((Object)this.service.selectById(id));
        ManagementVO vo = (ManagementVO)BeanMapper.map((Object)((Object)entity), ManagementVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ManagementVO> vos) {
        return this.service.deleteBatch(vos);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ManagementVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("certName");
        fuzzyFields.add("certCode");
        fuzzyFields.add("name");
        fuzzyFields.add("certTypeName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("certMajor");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success((String)"\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        if (param.getParams().containsKey("certTypeIdOrg")) {
            Parameter certTypeIdOrgPar = (Parameter)param.getParams().get("certTypeIdOrg");
            if (param.getParams().containsKey("certTypeId")) {
                Parameter certTypeIdPar = (Parameter)param.getParams().get("certTypeId");
                String certTypeId = certTypeIdPar.getValue().toString();
                String certTypeIdOrg = certTypeIdOrgPar.getValue().toString();
                certTypeIdOrgPar.setValue((Object)(certTypeIdOrg + "," + certTypeId));
            }
            param.getParams().put("certTypeId", certTypeIdOrgPar);
            param.getParams().remove("certTypeIdOrg");
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List list = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            list = BeanMapper.mapList((Iterable)page.getRecords(), ManagementVO.class);
            list.forEach(vo -> {
                if (1 == vo.getIsTerm()) {
                    vo.setFailureDateName("\u957f\u671f\u6709\u6548");
                } else {
                    vo.setFailureDateName(DateFormater.getInstance((Date)vo.getFailureDate()).format("yyyy-MM-dd"));
                }
            });
        }
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryUnExpireList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ManagementVO>> queryUnExpireList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("certName");
        fuzzyFields.add("certCode");
        fuzzyFields.add("name");
        fuzzyFields.add("certTypeName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success((String)"\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        ArrayList<Integer> termStatusList = new ArrayList<Integer>();
        termStatusList.add(1);
        termStatusList.add(2);
        Parameter termStatus = (Parameter)param.getParams().get("termStatus");
        if (null == termStatus) {
            param.getParams().put("termStatus", new Parameter("in", termStatusList));
        }
        if (param.getParams().containsKey("certTypeIdOrg")) {
            Parameter certTypeIdOrgPar = (Parameter)param.getParams().get("certTypeIdOrg");
            if (param.getParams().containsKey("certTypeId")) {
                Parameter certTypeIdPar = (Parameter)param.getParams().get("certTypeId");
                String certTypeId = certTypeIdPar.getValue().toString();
                String certTypeIdOrg = certTypeIdOrgPar.getValue().toString();
                certTypeIdOrgPar.setValue((Object)(certTypeIdOrg + "," + certTypeId));
            }
            param.getParams().put("certTypeId", certTypeIdOrgPar);
            param.getParams().remove("certTypeIdOrg");
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List list = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            list = BeanMapper.mapList((Iterable)page.getRecords(), ManagementVO.class);
            list.forEach(vo -> {
                if (1 == vo.getIsTerm()) {
                    vo.setFailureDateName("\u957f\u671f\u6709\u6548");
                } else {
                    vo.setFailureDateName(DateFormater.getInstance((Date)vo.getFailureDate()).format("yyyy-MM-dd"));
                }
                if (2 == vo.getTermStatus()) {
                    vo.setExprieName("\u5df2\u8fc7\u671f");
                    vo.setExprieDay(Long.valueOf(0L));
                } else {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        Date failureDate = sdf.parse(sdf.format(vo.getFailureDate()));
                        Date now = sdf.parse(sdf.format(new Date()));
                        long nd = 86400000L;
                        long diff = failureDate.getTime() - now.getTime();
                        long day = diff / nd;
                        vo.setExprieDay(Long.valueOf(day));
                        vo.setExprieName("\u8fd8\u6709" + day + "\u5929\u5230\u671f");
                    }
                    catch (Exception e) {
                        this.logger.error("\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
                    }
                }
            });
        }
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"managementRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ManagementVO>> orderDetailRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(required=false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("termStatus", new Parameter("ne", (Object)2));
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            for (String key : search.keySet()) {
                queryParam.getParams().put(key, new Parameter("like", (Object)search.get((Object)key).toString()));
            }
        }
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("certName");
        queryParam.getFuzzyFields().add("certCode");
        queryParam.getFuzzyFields().add("name");
        queryParam.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(queryParam, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List list = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            list = BeanMapper.mapList((Iterable)page.getRecords(), ManagementVO.class);
            list.forEach(vo -> {
                if (0 == vo.getType()) {
                    vo.setTypeName("\u4e2a\u4eba");
                } else {
                    vo.setTypeName("\u4f01\u4e1a");
                }
                if (0 == vo.getStockStatus()) {
                    vo.setStockStatusName("\u5728\u518c");
                } else {
                    vo.setStockStatusName("\u501f\u51fa");
                }
            });
        }
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExports"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExports(@RequestBody QueryParam param, HttpServletResponse response) {
        List<ManagementVO> list = this.service.excelExports(param);
        HashMap<String, List<ManagementVO>> beans = new HashMap<String, List<ManagementVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("managementExportPerson.xlsx", beans, response);
    }

    @RequestMapping(value={"/UnExpire"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse UnExpire(HttpServletRequest request) {
        this.logger.info("\u5f00\u59cb\u5b9a\u65f6\u4efb\u52a1\uff1a----");
        int num = 90;
        if (num > 0) {
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.eq(ManagementEntity::getIsTerm, (Object)0);
            List list = this.service.list((Wrapper)lambdachange);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                this.logger.info("\u5f00\u59cb\u5faa\u73af\u8bbe\u7f6e----" + list.size());
                list.forEach(entity -> {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        if (1 == entity.getIsTerm()) {
                            entity.setTermStatus(0);
                        } else {
                            Date failureDate = sdf.parse(sdf.format(entity.getFailureDate()));
                            Date now = sdf.parse(sdf.format(new Date()));
                            long nd = 86400000L;
                            long diff = failureDate.getTime() - now.getTime();
                            long day = diff / nd;
                            if (day > (long)num) {
                                entity.setTermStatus(0);
                            } else if (day <= (long)num && day >= 0L) {
                                entity.setTermStatus(1);
                            } else if (day < 0L) {
                                entity.setTermStatus(2);
                            }
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
                    }
                });
                this.service.updateBatchById(list);
            }
        }
        return CommonResponse.success((String)"\u8fd0\u884c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/downloadOrg"})
    @ResponseBody
    public void downloadOrg(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"cert-org-import.xlsx", (String)"\u4f01\u4e1a\u8bc1\u7167\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"cert-import.xlsx", (String)"\u4e2a\u4eba\u8bc1\u7167\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/queryPersonalInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ManagementVO> queryReceiveInfo(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("createTime", "desc");
        List entityList = this.service.queryList(queryParam, false);
        ManagementVO backVO = !entityList.isEmpty() ? (ManagementVO)BeanMapper.map(entityList.get(0), ManagementVO.class) : new ManagementVO();
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/excelImportOrg"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImportOrg(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImportOrg(request, response);
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImport(request, response);
    }
}

