/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.oa.bean.BidDetailEntity;
import com.ejianc.business.oa.bean.BidEntity;
import com.ejianc.business.oa.mapper.BidMapper;
import com.ejianc.business.oa.mapper.BidRequireMapper;
import com.ejianc.business.oa.service.IBidDetailService;
import com.ejianc.business.oa.service.IBidService;
import com.ejianc.business.oa.vo.BidDetailVO;
import com.ejianc.business.oa.vo.BidRequireExportVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bidService")
public class BidServiceImpl
extends BaseServiceImpl<BidMapper, BidEntity>
implements IBidService {
    @Autowired
    private IBidService service;
    @Autowired
    private IBidDetailService detailService;
    @Autowired
    private BidRequireMapper bidRequireMapper;

    @Override
    public List<BidDetailVO> queryBidDetailList(Long opportunityId) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(BidEntity::getOpportunityId, (Object)opportunityId);
        lambdaQueryWrapper.in(BidEntity::getBillState, new Object[]{1, 3});
        lambdaQueryWrapper.eq(BaseEntity::getDr, (Object)0);
        List list = this.service.list((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper detailWrapper = Wrappers.lambdaQuery();
        detailWrapper.in(BidDetailEntity::getBidId, ids);
        detailWrapper.eq(BaseEntity::getDr, (Object)0);
        List detailList = this.detailService.list((Wrapper)detailWrapper);
        return BeanMapper.mapList((Iterable)detailList, BidDetailVO.class);
    }

    @Override
    public List<BidRequireExportVO> queryRequireList(QueryParam param) {
        QueryWrapper wrapper = BidServiceImpl.changeToQueryWrapper((QueryParam)param);
        return this.bidRequireMapper.queryRequireList(wrapper, InvocationInfoProxy.getTenantid());
    }
}

