package com.ejianc.business.oa.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.BidEntity;
import com.ejianc.business.oa.bean.InviteEntity;
import com.ejianc.business.oa.bean.InvitePersonEntity;
import com.ejianc.business.oa.service.IInvitePersonService;
import com.ejianc.business.oa.service.IInviteService;
import com.ejianc.business.oa.vo.BidRequireExportVO;
import com.ejianc.business.oa.vo.BidVO;
import com.ejianc.business.oa.vo.InvitePersonExportVO;
import com.ejianc.business.oa.vo.InviteVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.stream.Collectors;

/**
 * 招标文件评审实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("invite")
public class InviteController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String OA_INVITE = "OA_INVITE";

    @Autowired
    private IInviteService inviteService;
    @Autowired
    private IInvitePersonService iInvitePersonService;

    @Autowired
    private IBillCodeApi billCodeApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InviteVO> saveOrUpdate(@RequestBody InviteVO saveorUpdateVO) {
        if(StringUtils.isEmpty(saveorUpdateVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(OA_INVITE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                saveorUpdateVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	InviteEntity entity = BeanMapper.map(saveorUpdateVO, InviteEntity.class);
        inviteService.saveOrUpdate(entity, false);
    	InviteVO vo = BeanMapper.map(entity, InviteVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InviteVO> queryDetail(Long id) {
    	InviteEntity entity = inviteService.selectById(id);
    	InviteVO vo = BeanMapper.map(entity, InviteVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InviteVO> vos) {
        inviteService.removeByIds(vos.stream().map(InviteVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InviteVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("opportunityName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("makerName");
        fuzzyFields.add("bidMethod");
        fuzzyFields.add("tederType");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<InviteEntity> page = inviteService.queryPage(param,false);
        IPage<InviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InviteVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryHighestMnyByProj 根据项目查询最高限价
     * @param opportunityId
     */
    @RequestMapping(value = "/queryHighestMnyByProj", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InviteEntity> queryHighestMnyByProj(Long opportunityId) {
        LambdaQueryWrapper<InviteEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(InviteEntity::getOpportunityId, opportunityId);
        queryWrapper.in(InviteEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.orderByDesc(InviteEntity::getCreateTime);
        queryWrapper.last("limit 1");
        InviteEntity InviteEntity = inviteService.getOne(queryWrapper, false);
        if (ObjectUtil.isNotEmpty(InviteEntity)){
            LambdaQueryWrapper<InvitePersonEntity> personQueryWrapper = new LambdaQueryWrapper<InvitePersonEntity>().eq(InvitePersonEntity::getInviteId, InviteEntity.getId())
                    .eq(InvitePersonEntity::getDr, 0);
            List<InvitePersonEntity> list = iInvitePersonService.list(personQueryWrapper);
            InviteEntity.setPersonList(list);
        }
        return CommonResponse.success("根据项目查询最高限价成功！", InviteEntity);
    }

    /**
     * @Description 导出-按人员要求
     * @Return void
     */
    @RequestMapping(value = "/excelExportPerson", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportPerson(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("opportunityName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("makerName");
        fuzzyFields.add("bidMethod");
        fuzzyFields.add("tederType");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<InvitePersonExportVO> list = inviteService.queryPersonList(param);
        for (InvitePersonExportVO invitePersonExportVO : list) {
            String projectStage = invitePersonExportVO.getProjectStage();
            if(StringUtils.isNotBlank(projectStage)){
                invitePersonExportVO.setProjectStageName("1".equals(projectStage) ? "已报名" : "已评审");
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("Invite-person-export.xlsx", beans, response);
    }

    @RequestMapping(value = "/queryLink", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryLink() {
        String cur = String.valueOf(System.currentTimeMillis());
        String token = DigestUtils.md5Hex("999999" + cur);
        return CommonResponse.success("查询详情数据成功！", "cur=" + cur + "&token=" + token);
    }

}
