package com.ejianc.business.oa.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 招标文件评审实体
 *
 * @author generator
 *
 */
public class InviteVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private  String billCode; // 单据编号
    private  String opportunityName; // 工程名称
    private BigDecimal bondMny; // 招标保证金
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date inviteDate; // 招标时间
    private  Integer billState; // 单据状态
    private  String specify; // 具体说明
    private  String fileUrls; // 招标文件
    private  Long opportunityId; // 工程主键
    private  Long orgId; // 组织
    private  String orgName; // 组织名称
    private  Long makerId; // 编制人主键
    private  String makerName; // 编制人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date makeDate;//编制日期

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date openDate; // 开标日期
    private BigDecimal highestMny; // 最高限价
    private String bidMethod; // 评标办法
    private String tederType; // 标书形式
    private String bidRepresentative; // 招标代表
    private String projectStage; // 项目阶段（1:已报名2:已评审）
    private List<InviteCompanyVO> companyList = new ArrayList<>(); // 招标文件评审企业资质要求实体
    private List<InvitePersonVO> personList = new ArrayList<>(); // 招标文件评审人员资质要求实体

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getOpportunityName() {
        return opportunityName;
    }

    public void setOpportunityName(String opportunityName) {
        this.opportunityName = opportunityName;
    }

    public BigDecimal getBondMny() {
        return bondMny;
    }

    public void setBondMny(BigDecimal bondMny) {
        this.bondMny = bondMny;
    }

    public Date getInviteDate() {
        return inviteDate;
    }

    public void setInviteDate(Date inviteDate) {
        this.inviteDate = inviteDate;
    }

    public String getProjectStage() {
        return projectStage;
    }

    public void setProjectStage(String projectStage) {
        this.projectStage = projectStage;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getSpecify() {
        return specify;
    }

    public void setSpecify(String specify) {
        this.specify = specify;
    }

    public String getFileUrls() {
        return fileUrls;
    }

    public void setFileUrls(String fileUrls) {
        this.fileUrls = fileUrls;
    }

    @ReferSerialTransfer(referCode="business-opportunity-register")
    public Long getOpportunityId() {
        return opportunityId;
    }
    @ReferDeserialTransfer
    public void setOpportunityId(Long opportunityId) {
        this.opportunityId = opportunityId;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getMakerId() {
        return makerId;
    }
    @ReferDeserialTransfer
    public void setMakerId(Long makerId) {
        this.makerId = makerId;
    }

    public String getMakerName() {
        return makerName;
    }

    public void setMakerName(String makerName) {
        this.makerName = makerName;
    }

    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }

    public Date getOpenDate() {
        return openDate;
    }

    public void setOpenDate(Date openDate) {
        this.openDate = openDate;
    }

    public BigDecimal getHighestMny() {
        return highestMny;
    }

    public void setHighestMny(BigDecimal highestMny) {
        this.highestMny = highestMny;
    }

    public String getBidMethod() {
        return bidMethod;
    }

    public void setBidMethod(String bidMethod) {
        this.bidMethod = bidMethod;
    }

    public String getTederType() {
        return tederType;
    }

    public void setTederType(String tederType) {
        this.tederType = tederType;
    }

    public String getBidRepresentative() {
        return bidRepresentative;
    }

    public void setBidRepresentative(String bidRepresentative) {
        this.bidRepresentative = bidRepresentative;
    }

    public List<InviteCompanyVO> getCompanyList() {
        return companyList;
    }

    public void setCompanyList(List<InviteCompanyVO> companyList) {
        this.companyList = companyList;
    }

    public List<InvitePersonVO> getPersonList() {
        return personList;
    }

    public void setPersonList(List<InvitePersonVO> personList) {
        this.personList = personList;
    }
}
