package com.ejianc.business.order.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author sunyj
 * @Date 2025/4/1 合同
 * @Description ContractVO
 */

public class ContractVO extends BaseVO {

    private static final long serialVersionUID = 2779265683203439571L;

    /**
     * 合同编码
     */
    private String billCode;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 分包类型
     */
    private Long contractType;

    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    private String contractStatus;


    private Long frameContractId; // 框架协议主键ID
    private String frameContractCode; // 框架协议编码
    private String frameContractName; // 框架协议名称
    private Long frameCustomerId; // 框架协议甲方Id
    private String frameCustomerName; // 框架协议甲方名称
    private Long frameSupplierId; // 框架协议乙方Id
    private String frameSupplierName; // 框架协议乙方名称
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long orgId; // 项目部id
    private String orgCode; // 项目部编码
    private String orgName; // 项目部名称
    private Long parentOrgId; // 所属组织Id
    private String parentOrgName; // 所属组织名称
    private String parentOrgCode; // 所属组织编码
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long customerId; // 甲方Id
    private String customerName; //
    private Long supplierId; // 乙方Id
    private String supplierName; //
    private String signPlace; // 签约地点
    private Long customerEmployeeId; // 甲方经办人Id
    private String customerEmployeeName; // 甲方经办人名称
    private String customerEmployeeMobile; // 甲方经办人电话
    private String supplierEmployeeName; // 乙方经办人名称
    private String supplierEmployeeMobile; // 乙方经办人电话
    private String pricingType; // 计价方式：1-固定单价、2-浮动单价、3-固定总价
    private BigDecimal taxRate; // 合同税率
    private BigDecimal contractTaxMny; // 合同金额
    private BigDecimal contractMny; // 合同金额(不含税)
    private BigDecimal taxMny; // 税金
    private BigDecimal baseTaxMoney; // 初始版本金额（含税）
    private BigDecimal baseMoney; // 初始版本金额
    private BigDecimal beforeChangeTaxMny; // 变更前金额（含税）
    private BigDecimal beforeChangeMny; // 变更前金额
    private BigDecimal changingTaxMny; // 变更中金额（含税）
    private BigDecimal changingMny; // 变更中金额
    private BigDecimal payScale; // 合同支付比例
    private String purchaseType; // 采购类型 1-自采，2-集采
    private String memo; // 备注
    private String changeCode; // 变更单号
    private Integer changeVersion; // 变更版本
    private Long changeId; // 变更主键
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private Integer billState; // 单据状态（审批必须字段）
    private String purchaseTypeName; // 集采/自采
    private Long mainContractId; // 主合同ID
    private String mainContractCode; // 主合同编码
    private Integer supplyFlag; // 是否补充协议(1:是，0：否)
    private Long invoiceType; // 发票类型
    private String invoiceTypeName; // 发票类型名称

    /**
     * 签约日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 合同明细集合
     */
    private List<ContractDetailVO> detailList;

    /**
     * 合同条款集合
     */
    private List<ContractClauseVO> clauseList;

    private List<ContractStageVO> stageList; // 分包合同阶段实体

    private String billStateName;

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<ContractDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ContractDetailVO> detailList) {
        this.detailList = detailList;
    }

    public List<ContractClauseVO> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<ContractClauseVO> clauseList) {
        this.clauseList = clauseList;
    }

    public List<ContractStageVO> getStageList() {
        return stageList;
    }

    public void setStageList(List<ContractStageVO> stageList) {
        this.stageList = stageList;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getInvoiceType() {
        return invoiceType;
    }

    @ReferDeserialTransfer
    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="support-customer")
    public Long getCustomerId() {
        return customerId;
    }

    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }

    public Long getFrameContractId() {
        return frameContractId;
    }

    public void setFrameContractId(Long frameContractId) {
        this.frameContractId = frameContractId;
    }

    public String getFrameContractCode() {
        return frameContractCode;
    }

    public void setFrameContractCode(String frameContractCode) {
        this.frameContractCode = frameContractCode;
    }

    public String getFrameContractName() {
        return frameContractName;
    }

    public void setFrameContractName(String frameContractName) {
        this.frameContractName = frameContractName;
    }

    public Long getFrameCustomerId() {
        return frameCustomerId;
    }

    public void setFrameCustomerId(Long frameCustomerId) {
        this.frameCustomerId = frameCustomerId;
    }

    public String getFrameCustomerName() {
        return frameCustomerName;
    }

    public void setFrameCustomerName(String frameCustomerName) {
        this.frameCustomerName = frameCustomerName;
    }

    public Long getFrameSupplierId() {
        return frameSupplierId;
    }

    public void setFrameSupplierId(Long frameSupplierId) {
        this.frameSupplierId = frameSupplierId;
    }

    public String getFrameSupplierName() {
        return frameSupplierName;
    }

    public void setFrameSupplierName(String frameSupplierName) {
        this.frameSupplierName = frameSupplierName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getSignPlace() {
        return signPlace;
    }

    public void setSignPlace(String signPlace) {
        this.signPlace = signPlace;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getCustomerEmployeeId() {
        return customerEmployeeId;
    }
    @ReferDeserialTransfer
    public void setCustomerEmployeeId(Long customerEmployeeId) {
        this.customerEmployeeId = customerEmployeeId;
    }

    public String getCustomerEmployeeName() {
        return customerEmployeeName;
    }

    public void setCustomerEmployeeName(String customerEmployeeName) {
        this.customerEmployeeName = customerEmployeeName;
    }

    public String getCustomerEmployeeMobile() {
        return customerEmployeeMobile;
    }

    public void setCustomerEmployeeMobile(String customerEmployeeMobile) {
        this.customerEmployeeMobile = customerEmployeeMobile;
    }

    public String getSupplierEmployeeName() {
        return supplierEmployeeName;
    }

    public void setSupplierEmployeeName(String supplierEmployeeName) {
        this.supplierEmployeeName = supplierEmployeeName;
    }

    public String getSupplierEmployeeMobile() {
        return supplierEmployeeMobile;
    }

    public void setSupplierEmployeeMobile(String supplierEmployeeMobile) {
        this.supplierEmployeeMobile = supplierEmployeeMobile;
    }

    public String getPricingType() {
        return pricingType;
    }

    public void setPricingType(String pricingType) {
        this.pricingType = pricingType;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }

    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }

    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    public Integer getSupplyFlag() {
        return supplyFlag;
    }

    public void setSupplyFlag(Integer supplyFlag) {
        this.supplyFlag = supplyFlag;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
}
