package com.ejianc.business.order.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * <p>
 * 分包合同记录明细表
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@TableName("ejc_order_record_detail")
public class RecordDetailEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 记录表ID
     */
    @TableField("record_id")
    private Long recordId;

    /**
     * 合同ID
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 合同明细ID
     */
    @TableField("contract_detail_id")
    private Long contractDetailId;

    /**
     * 序号
     */
    @TableField("tree_index")
    private String treeIndex;

    @TableField(value="material_type_id")
    private Long materialTypeId; // 产品分类id
    @TableField(value="material_type_code")
    private String materialTypeCode; // 产品分类编码
    @TableField(value="material_type_name")
    private String materialTypeName; // 产品分类名称
    @TableField(value="material_id")
    private Long materialId; // 产品id
    @TableField(value="material_name")
    private String materialName; // 产品名称
    @TableField(value="material_code")
    private String materialCode; // 产品编码
    @TableField(value="spec")
    private String spec; // 规则/型号
    @TableField(value="specific")
    private String specific; // 项目特征
    @TableField(value="unit")
    private String unit; // 计量单位
    @TableField(value="brand")
    private String brand; // 品牌
    @TableField(value="num")
    private BigDecimal num; // 工程量
    @TableField(value="price")
    private BigDecimal price; // 综合单价(无税)
    @TableField(value="material_price")
    private BigDecimal materialPrice; // 材料费单价(无税)
    @TableField(value="az_price")
    private BigDecimal azPrice; // 安装费单价(无税)
    @TableField(value="other_price")
    private BigDecimal otherPrice; // 其他单价(无税)
    @TableField(value="detail_tax_rate")
    private BigDecimal detailTaxRate; // 税率
    @TableField(value="money")
    private BigDecimal money; // 金额(无税)
    @TableField(value="detail_tax_mny")
    private BigDecimal detailTaxMny; // 金额(含税)
    @TableField(value="detail_tax")
    private BigDecimal detailTax; // 税额
    @TableField(value="detail_tax_price")
    private BigDecimal detailTaxPrice; // 单价(含税)
    @TableField(value="material_tax_price")
    private BigDecimal materialTaxPrice; // 材料费单价(含税)
    @TableField(value="az_tax_price")
    private BigDecimal azTaxPrice; // 安装费单价(含税)
    @TableField(value="other_tax_price")
    private BigDecimal otherTaxPrice; // 其他单价(含税)
    @TableField(value="place")
    private String place; // 产地
    @TableField(value="memo")
    private String memo; // 备注

    /**
     * 父ID
     */
    @TableField("parent_id")
    private Long parentId;

    /**
     * 是否末级
     */
    @TableField("leaf_flag")
    private Integer leafFlag;

    /**
     * 变更主键
     */
    @TableField("change_id")
    private Long changeId;

    /**
     * 变更子表主键
     */
    @TableField("change_bid")
    private Long changeBid;

    /**
     * 变更类型
     */
    @TableField("change_type")
    private Integer changeType;

    @TableField(value="source_id")
    private String sourceId; // 来源数据Id
    @TableField(value="source_type")
    private Integer sourceType; // 来源类型(1:新增，2:导入，3:框架协议，4:其他)
    @TableField(value="src_supplement_flag")
    private Integer srcSupplementFlag; // 是否来源补充协议(1:是，0：否)
    @TableField(value="src_supplement_id")
    private Long srcSupplementId; // 来源补充协议主表ID
    @TableField(value="src_supplement_detail_id")
    private Long srcSupplementDetailId; // 来源补充协议明细ID
    @TableField(value="history_price_area")
    private String historyPriceArea; // 历史价格区间（无税）
    @TableField(value="history_tax_price_area")
    private String historyTaxPriceArea; // 历史价格区间（含税）
    @TableField(value="guide_price_area")
    private String guidePriceArea; // 公司指导价区间（无税）
    @TableField(value="guide_tax_price_area")
    private String guideTaxPriceArea; // 公司指导价区间（含税）

    @TableField(exist = false)
    private String tid;
    @TableField(exist = false)
    private String tpid;

    public Long getRecordId() {
        return recordId;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getSpecific() {
        return specific;
    }

    public void setSpecific(String specific) {
        this.specific = specific;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getMaterialPrice() {
        return materialPrice;
    }

    public void setMaterialPrice(BigDecimal materialPrice) {
        this.materialPrice = materialPrice;
    }

    public BigDecimal getAzPrice() {
        return azPrice;
    }

    public void setAzPrice(BigDecimal azPrice) {
        this.azPrice = azPrice;
    }

    public BigDecimal getOtherPrice() {
        return otherPrice;
    }

    public void setOtherPrice(BigDecimal otherPrice) {
        this.otherPrice = otherPrice;
    }

    public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }

    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }

    public BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    public void setDetailTaxPrice(BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }

    public BigDecimal getMaterialTaxPrice() {
        return materialTaxPrice;
    }

    public void setMaterialTaxPrice(BigDecimal materialTaxPrice) {
        this.materialTaxPrice = materialTaxPrice;
    }

    public BigDecimal getAzTaxPrice() {
        return azTaxPrice;
    }

    public void setAzTaxPrice(BigDecimal azTaxPrice) {
        this.azTaxPrice = azTaxPrice;
    }

    public BigDecimal getOtherTaxPrice() {
        return otherTaxPrice;
    }

    public void setOtherTaxPrice(BigDecimal otherTaxPrice) {
        this.otherTaxPrice = otherTaxPrice;
    }

    public String getPlace() {
        return place;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Integer getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Integer leafFlag) {
        this.leafFlag = leafFlag;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }

    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Integer getSrcSupplementFlag() {
        return srcSupplementFlag;
    }

    public void setSrcSupplementFlag(Integer srcSupplementFlag) {
        this.srcSupplementFlag = srcSupplementFlag;
    }

    public Long getSrcSupplementId() {
        return srcSupplementId;
    }

    public void setSrcSupplementId(Long srcSupplementId) {
        this.srcSupplementId = srcSupplementId;
    }

    public Long getSrcSupplementDetailId() {
        return srcSupplementDetailId;
    }

    public void setSrcSupplementDetailId(Long srcSupplementDetailId) {
        this.srcSupplementDetailId = srcSupplementDetailId;
    }

    public String getHistoryPriceArea() {
        return historyPriceArea;
    }

    public void setHistoryPriceArea(String historyPriceArea) {
        this.historyPriceArea = historyPriceArea;
    }

    public String getHistoryTaxPriceArea() {
        return historyTaxPriceArea;
    }

    public void setHistoryTaxPriceArea(String historyTaxPriceArea) {
        this.historyTaxPriceArea = historyTaxPriceArea;
    }

    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }

    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }
}
