package com.ejianc.business.order.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 合同记录表
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@TableName("ejc_order_record")
public class RecordEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 合同ID
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 合同编码
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;
    @TableField(value = "frame_contract_id")
    private Long frameContractId; // 框架协议主键ID
    @TableField(value = "frame_contract_code")
    private String frameContractCode; // 框架协议编码
    @TableField(value = "frame_contract_name")
    private String frameContractName; // 框架协议名称
    @TableField(value = "frame_customer_id")
    private Long frameCustomerId; // 框架协议甲方Id
    @TableField(value = "frame_customer_name")
    private String frameCustomerName; // 框架协议甲方名称
    @TableField(value = "frame_supplier_id")
    private Long frameSupplierId; // 框架协议乙方Id
    @TableField(value = "frame_supplier_name")
    private String frameSupplierName; // 框架协议乙方名称
    @TableField(value = "contract_type")
    private Long contractType; // 合同类型 1-材料合同, 2-安装合同
    @TableField(value = "contract_status")
    private String contractStatus; // 合同履约状态：1-履约, 2-中止，3-终止，4-废除，5-封账
    @TableField(value = "project_id")
    private Long projectId; // 项目
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "org_id")
    private Long orgId; // 项目部id
    @TableField(value = "org_code")
    private String orgCode; // 项目部编码
    @TableField(value = "org_name")
    private String orgName; // 项目部名称
    @TableField(value = "parent_org_id")
    private Long parentOrgId; // 所属组织Id
    @TableField(value = "parent_org_name")
    private String parentOrgName; // 所属组织名称
    @TableField(value = "parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value = "employee_id")
    private Long employeeId; // 经办人
    @TableField(value = "employee_name")
    private String employeeName; // 经办人名称
    @TableField(value = "customer_id")
    private Long customerId; // 甲方Id
    @TableField(value = "customer_name")
    private String customerName; //
    @TableField(value = "supplier_id")
    private Long supplierId; // 乙方Id
    @TableField(value = "supplier_name")
    private String supplierName; //
    @TableField(value = "sign_date")
    private Date signDate; // 签订日期
    @TableField(value = "sign_place")
    private String signPlace; // 签约地点
    @TableField(value = "customer_employee_id")
    private Long customerEmployeeId; // 甲方经办人Id
    @TableField(value = "customer_employee_name")
    private String customerEmployeeName; // 甲方经办人名称
    @TableField(value = "customer_employee_mobile")
    private String customerEmployeeMobile; // 甲方经办人电话
    @TableField(value = "supplier_employee_name")
    private String supplierEmployeeName; // 乙方经办人名称
    @TableField(value = "supplier_employee_mobile")
    private String supplierEmployeeMobile; // 乙方经办人电话
    @TableField(value = "pricing_type")
    private String pricingType; // 计价方式：1-固定单价、2-浮动单价、3-固定总价
    @TableField(value = "tax_rate")
    private BigDecimal taxRate; // 合同税率
    @TableField(value = "contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value = "contract_mny")
    private BigDecimal contractMny; // 合同金额(不含税)
    @TableField(value = "tax_mny")
    private BigDecimal taxMny; // 税金
    @TableField(value = "base_tax_money")
    private BigDecimal baseTaxMoney; // 初始版本金额（含税）
    @TableField(value = "base_money")
    private BigDecimal baseMoney; // 初始版本金额
    @TableField(value = "before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny; // 变更前金额（含税）
    @TableField(value = "before_change_mny")
    private BigDecimal beforeChangeMny; // 变更前金额
    @TableField(value = "changing_tax_mny")
    private BigDecimal changingTaxMny; // 变更中金额（含税）
    @TableField(value = "changing_mny")
    private BigDecimal changingMny; // 变更中金额
    @TableField(value = "pay_scale")
    private BigDecimal payScale; // 合同支付比例
    @TableField(value = "purchase_type")
    private String purchaseType; // 采购类型 1-自采，2-集采
    @TableField(value = "memo")
    private String memo; // 备注
    @TableField(value = "change_code")
    private String changeCode; // 变更单号
    @TableField(value = "change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value = "change_id")
    private Long changeId; // 变更主键
    @TableField(value = "change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value = "purchase_type_name")
    private String purchaseTypeName; // 集采/自采
    @TableField(value = "main_contract_id")
    private Long mainContractId; // 主合同ID
    @TableField(value = "main_contract_code")
    private String mainContractCode; // 主合同编码
    @TableField(value = "supply_flag")
    private Integer supplyFlag; // 是否补充协议(1:是，0：否)
    @TableField(value = "invoice_type")
    private Long invoiceType; // 发票类型
    @TableField(value = "invoice_type_name")
    private String invoiceTypeName; // 发票类型名称

    /**
     * 合同记录明细集合
     */
    @TableField(exist = false)
    @SubEntity(serviceName="RecordDetailServiceImpl",pidName = "recordId")
    private List<RecordDetailEntity> detailList;

    /**
     * 合同记录条款集合
     */
    @TableField(exist = false)
    @SubEntity(serviceName="RecordClauseServiceImpl",pidName = "recordId")
    private List<RecordClauseEntity> clauseList;

    @TableField(exist=false)
    @SubEntity(serviceName="recordStageService",pidName = "recordId")
    private List<RecordStageEntity> stageList; // 合同阶段实体

    public List<RecordDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<RecordDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public List<RecordClauseEntity> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<RecordClauseEntity> clauseList) {
        this.clauseList = clauseList;
    }

    public List<RecordStageEntity> getStageList() {
        return stageList;
    }

    public void setStageList(List<RecordStageEntity> stageList) {
        this.stageList = stageList;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getFrameContractId() {
        return frameContractId;
    }

    public void setFrameContractId(Long frameContractId) {
        this.frameContractId = frameContractId;
    }

    public String getFrameContractCode() {
        return frameContractCode;
    }

    public void setFrameContractCode(String frameContractCode) {
        this.frameContractCode = frameContractCode;
    }

    public String getFrameContractName() {
        return frameContractName;
    }

    public void setFrameContractName(String frameContractName) {
        this.frameContractName = frameContractName;
    }

    public Long getFrameCustomerId() {
        return frameCustomerId;
    }

    public void setFrameCustomerId(Long frameCustomerId) {
        this.frameCustomerId = frameCustomerId;
    }

    public String getFrameCustomerName() {
        return frameCustomerName;
    }

    public void setFrameCustomerName(String frameCustomerName) {
        this.frameCustomerName = frameCustomerName;
    }

    public Long getFrameSupplierId() {
        return frameSupplierId;
    }

    public void setFrameSupplierId(Long frameSupplierId) {
        this.frameSupplierId = frameSupplierId;
    }

    public String getFrameSupplierName() {
        return frameSupplierName;
    }

    public void setFrameSupplierName(String frameSupplierName) {
        this.frameSupplierName = frameSupplierName;
    }

    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getSignPlace() {
        return signPlace;
    }

    public void setSignPlace(String signPlace) {
        this.signPlace = signPlace;
    }

    public Long getCustomerEmployeeId() {
        return customerEmployeeId;
    }

    public void setCustomerEmployeeId(Long customerEmployeeId) {
        this.customerEmployeeId = customerEmployeeId;
    }

    public String getCustomerEmployeeName() {
        return customerEmployeeName;
    }

    public void setCustomerEmployeeName(String customerEmployeeName) {
        this.customerEmployeeName = customerEmployeeName;
    }

    public String getCustomerEmployeeMobile() {
        return customerEmployeeMobile;
    }

    public void setCustomerEmployeeMobile(String customerEmployeeMobile) {
        this.customerEmployeeMobile = customerEmployeeMobile;
    }

    public String getSupplierEmployeeName() {
        return supplierEmployeeName;
    }

    public void setSupplierEmployeeName(String supplierEmployeeName) {
        this.supplierEmployeeName = supplierEmployeeName;
    }

    public String getSupplierEmployeeMobile() {
        return supplierEmployeeMobile;
    }

    public void setSupplierEmployeeMobile(String supplierEmployeeMobile) {
        this.supplierEmployeeMobile = supplierEmployeeMobile;
    }

    public String getPricingType() {
        return pricingType;
    }

    public void setPricingType(String pricingType) {
        this.pricingType = pricingType;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }

    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }

    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    public Integer getSupplyFlag() {
        return supplyFlag;
    }

    public void setSupplyFlag(Integer supplyFlag) {
        this.supplyFlag = supplyFlag;
    }

    public Long getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }
}
