package com.ejianc.business.order.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.order.bean.ContractEntity;
import com.ejianc.business.order.vo.*;
import com.ejianc.business.order.vo.warn.SubWarnVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

public interface IContractService extends IBaseService<ContractEntity> {
    ContractVO insertOrUpdate(ContractVO contractVO);

    ContractVO queryDetail(Long id, Boolean detailHasChildren);

    CommonResponse<String> deleteByIds(List<ContractVO> ids);

    CommonResponse<IPage<ContractVO>> queryListVOs(QueryParam param);

    Map<String, Object> countContractAmount(QueryParam param);

    ContractVO queryRecordDetail(Long id, boolean b);

    List<ContractDetailVO> refContractDetail(Long contractId, String condition);

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);


    List<SubWarnVo> subProjectOutMny(List<Long> tenantIds);

}
