package com.ejianc.business.other.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 其他支出合同变更
 * 
 * @author generator
 * 
 */
public class OtherContractChangeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long contractId; // 合同主键
    private Long projectId; // 项目
    private Long orgId; // 组织
    private String contractName; // 合同名称
    private String contractStatus; // 合同状态：1-未签订, 2-履约中，3-已封帐
    private String billCode; // 单据编号
    private Long customerId; // 甲方
    private String customerName; // 甲方名称
    private Long supplierId; // 供应商
    private String supplierName; // 供应商名称
    private String orgName; // 组织名称
    private String projectName; // 项目名称
    private java.math.BigDecimal taxRate; // 合同税率
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date signDate; // 签约日期
    private Long contractType; // 合同类型
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private String memo; // 备注
    private java.math.BigDecimal contractTaxMny; // 合同金额
    private java.math.BigDecimal contractMny; // 合同金额(不含税)
    private java.math.BigDecimal taxMny; // 税金
    private java.math.BigDecimal baseTaxMoney; // 初始版本金额（含税）
    private java.math.BigDecimal baseMoney; // 初始版本金额
    private java.math.BigDecimal beforeChangeTaxMny; // 变更前金额（含税）
    private java.math.BigDecimal beforeChangeMny; // 变更前金额
    private Integer changeVersion; // 变更版本
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date changeTime; // 变更（编制）时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date usedTime; // 生效时间
    private Integer billState; // 单据状态
    private String changeReason; // 变更原因
    private String mainContractName; // 主合同名称
    private Long mainContractId; // 主合同ID
    private String mainContractCode; // 主合同编码
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    /**
     * 变更前合同名称
     */
    private String beforeContractName;

    //历史版本编号
    private String historyBillCode;
    //本次变更比例
    private BigDecimal scale;

    /**
     * 合同优惠前金额
     */
    private BigDecimal contractUndiscountMny;

    /**
     * 优惠金额
     */
    private BigDecimal discountMny;

    private List<OtherContractDetailChangeVO> detailVos = new ArrayList<>(); // 其他支出合同清单变更
    private List<OtherContractPayPlanChangeVO> payPlanVos = new ArrayList<>(); // 其他支出付款计划变更
    private List<OtherContractClauseChangeVO> clauseVos = new ArrayList<>(); // 其他支出合同条款变更

    /**
     * 是否属于项目: 1-是（默认），0-否
     */
    private Integer dependOnProject;

    /**
     * 采购方式：
     * 1、当合同的所属组织类型为：集团、公司、分公司、经理部时，采购方式为公司集采合同（及需求中定义的框架合同）
     * 2、当合同的所属组织类型为项目部时，采购方式为项目自采合同
     */
    private Integer purchaseMode;
    /**
     * 采购方式名称
     */
    private String purchaseModeName;

    /**
     * 定标结果单id
     */
    private Long enquiryPriceBillId;

    /**
     * 定标结果单主题
     */
    private String enquiryPriceBillName;


    /**
     * 合同文件id
     */
    private String contractFileId;

    /**
     * 合同pdfid
     */
    private Long contractPdfId;

    /**
     * 合同模板id
     */
    private Long contractTemplateId;

    /**
     * 归档状态,1:已归档
     */
    private String fileState;

    /**
     * 起草方式online线上upload上传
     */
    private String draftMethod;

    /**
     * 文档类型
     */
    private Long docCategoryId;

    private Long costTypeId; // 费用类型
    private String costTypeName; // 费用类型名称

    private BigDecimal costMny; // 成本金额

    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCostTypeId() {
        return costTypeId;
    }
    @ReferDeserialTransfer
    public void setCostTypeId(Long costTypeId) {
        this.costTypeId = costTypeId;
    }

    public String getCostTypeName() {
        return costTypeName;
    }

    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }

    @ReferSerialTransfer(referCode = "contractCategory")
    public Long getDocCategoryId() {
        return docCategoryId;
    }
    @ReferDeserialTransfer
    public void setDocCategoryId(Long docCategoryId) {
        this.docCategoryId = docCategoryId;
    }


    public String getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(String contractFileId) {
        this.contractFileId = contractFileId;
    }

    public Long getContractPdfId() {
        return contractPdfId;
    }

    public void setContractPdfId(Long contractPdfId) {
        this.contractPdfId = contractPdfId;
    }

    @ReferSerialTransfer(referCode = "ejc-contractTemplate")
    public Long getContractTemplateId() {
        return contractTemplateId;
    }
    @ReferDeserialTransfer
    public void setContractTemplateId(Long contractTemplateId) {
        this.contractTemplateId = contractTemplateId;
    }

    public String getFileState() {
        return fileState;
    }

    public void setFileState(String fileState) {
        this.fileState = fileState;
    }

    public String getDraftMethod() {
        return draftMethod;
    }

    public void setDraftMethod(String draftMethod) {
        this.draftMethod = draftMethod;
    }

    @ReferSerialTransfer(referCode = "othprice-result")
    public Long getEnquiryPriceBillId() {
        return enquiryPriceBillId;
    }

    @ReferDeserialTransfer
    public void setEnquiryPriceBillId(Long enquiryPriceBillId) {
        this.enquiryPriceBillId = enquiryPriceBillId;
    }

    public String getEnquiryPriceBillName() {
        return enquiryPriceBillName;
    }

    public void setEnquiryPriceBillName(String enquiryPriceBillName) {
        this.enquiryPriceBillName = enquiryPriceBillName;
    }

    public Integer getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(Integer dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public Integer getPurchaseMode() {
        return purchaseMode;
    }

    public void setPurchaseMode(Integer purchaseMode) {
        this.purchaseMode = purchaseMode;
    }

    public String getPurchaseModeName() {
        return purchaseModeName;
    }

    public void setPurchaseModeName(String purchaseModeName) {
        this.purchaseModeName = purchaseModeName;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    private Integer changeStatus;


    public String getHistoryBillCode() {
        return historyBillCode;
    }

    public void setHistoryBillCode(String historyBillCode) {
        this.historyBillCode = historyBillCode;
    }

    public BigDecimal getScale() {
        return scale;
    }

    public void setScale(BigDecimal scale) {
        this.scale = scale;
    }

    public String getBeforeContractName() {
        return beforeContractName;
    }

    public void setBeforeContractName(String beforeContractName) {
        this.beforeContractName = beforeContractName;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同状态：1-未签订, 2-履约中，3-已封帐
     */
    public String getContractStatus() {
        return contractStatus;
    }

    /**
     * 合同状态：1-未签订, 2-履约中，3-已封帐
     */
    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 甲方
     */
    @ReferSerialTransfer(referCode="support-customer")
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * 甲方
     */
    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    /**
     * 甲方名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 甲方名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    /**
     * 供应商
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商
     */
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    public BigDecimal getContractUndiscountMny() {
        return contractUndiscountMny;
    }

    public void setContractUndiscountMny(BigDecimal contractUndiscountMny) {
        this.contractUndiscountMny = contractUndiscountMny;
    }

    public BigDecimal getDiscountMny() {
        return discountMny;
    }

    public void setDiscountMny(BigDecimal discountMny) {
        this.discountMny = discountMny;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 合同税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 签约日期
     */
    public java.util.Date getSignDate() {
        return signDate;
    }

    /**
     * 签约日期
     */
    public void setSignDate(java.util.Date signDate) {
        this.signDate = signDate;
    }
    /**
     * 合同类型
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractType() {
        return contractType;
    }

    /**
     * 合同类型
     */
    @ReferDeserialTransfer
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 合同金额
     */
    public java.math.BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额
     */
    public void setContractTaxMny(java.math.BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 合同金额(不含税)
     */
    public java.math.BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额(不含税)
     */
    public void setContractMny(java.math.BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 税金
     */
    public java.math.BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税金
     */
    public void setTaxMny(java.math.BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 初始版本金额（含税）
     */
    public java.math.BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    /**
     * 初始版本金额（含税）
     */
    public void setBaseTaxMoney(java.math.BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }
    /**
     * 初始版本金额
     */
    public java.math.BigDecimal getBaseMoney() {
        return baseMoney;
    }

    /**
     * 初始版本金额
     */
    public void setBaseMoney(java.math.BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }
    /**
     * 变更前金额（含税）
     */
    public java.math.BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    /**
     * 变更前金额（含税）
     */
    public void setBeforeChangeTaxMny(java.math.BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    /**
     * 变更前金额
     */
    public java.math.BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    /**
     * 变更前金额
     */
    public void setBeforeChangeMny(java.math.BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    /**
     * 变更（编制）时间
     */
    public java.util.Date getChangeTime() {
        return changeTime;
    }

    /**
     * 变更（编制）时间
     */
    public void setChangeTime(java.util.Date changeTime) {
        this.changeTime = changeTime;
    }
    /**
     * 生效时间
     */
    public java.util.Date getUsedTime() {
        return usedTime;
    }

    /**
     * 生效时间
     */
    public void setUsedTime(java.util.Date usedTime) {
        this.usedTime = usedTime;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 变更原因
     */
    public String getChangeReason() {
        return changeReason;
    }

    /**
     * 变更原因
     */
    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    /**
     * 主合同名称
     */
    public String getMainContractName() {
        return mainContractName;
    }

    /**
     * 主合同名称
     */
    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    /**
     * 主合同ID
     */
    public Long getMainContractId() {
        return mainContractId;
    }

    /**
     * 主合同ID
     */
    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    /**
     * 主合同编码
     */
    public String getMainContractCode() {
        return mainContractCode;
    }

    /**
     * 主合同编码
     */
    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }
    /**
     * 是否补充协议(1:是，0：否)
     */
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public List<OtherContractDetailChangeVO> getDetailVos() {
        return detailVos;
    }

    public void setDetailVos(List<OtherContractDetailChangeVO> detailVos) {
        this.detailVos = detailVos;
    }

    public List<OtherContractPayPlanChangeVO> getPayPlanVos() {
        return payPlanVos;
    }

    public void setPayPlanVos(List<OtherContractPayPlanChangeVO> payPlanVos) {
        this.payPlanVos = payPlanVos;
    }

    public List<OtherContractClauseChangeVO> getClauseVos() {
        return clauseVos;
    }

    public void setClauseVos(List<OtherContractClauseChangeVO> clauseVos) {
        this.clauseVos = clauseVos;
    }
}
