package com.ejianc.business.other.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.other.vo.OtherSettleDetailVO;
import com.ejianc.business.other.vo.OtherSettleOtherVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 结算
 * 
 * @author generator
 * 
 */
public class OtherSettleVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long contractId; // 合同主键
    private String contractName; // 合同名称
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String billCode; // 单据编号
    private String settleType; // 结算类型，0-过程结算，1-最终结算
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date signDate; // 结算日期
    private Long supplierId; // 供应商
    private String supplierName; // 供应商名称
    private Long contractType; //
    private String contractTypeName; //
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private java.math.BigDecimal settleTaxMny; // 本期结算金额(含税)
    private java.math.BigDecimal settleMny; // 本期结算金额(不含税)
    private java.math.BigDecimal taxMny; // 税金
    private java.math.BigDecimal thisOffsetMny; // 本次冲抵金额
    private java.math.BigDecimal contractTaxMny; // 合同金额（含税）
    private java.math.BigDecimal contractMny; // 合同金额（不含税）
    private java.math.BigDecimal taxRate; // 合同税率
    private java.math.BigDecimal sumSettleTaxMny; // 已结算金额
    private java.math.BigDecimal sumSettleMny; // 已结算金额
    private java.math.BigDecimal sumSettleRate; // 已结算比例
    private java.math.BigDecimal sumSettleAllMny; // 含本期累计结算金额
    private Integer billState; // 单据状态
    private String billStateName;
    private java.math.BigDecimal sumOffsetMny; // 累计冲抵金额
    private java.math.BigDecimal sumPayMny; // 累计付款金额
    private java.math.BigDecimal sumPrepayMny; // 累计预付款金额
    private java.math.BigDecimal prepayMny; // 预付款金额
    private BigDecimal sumApplyMny; //累计已申请金额
    private BigDecimal surplusApplyMny; //剩余可申请金额
    /**
     * 成本科目核算对象关联状态(1:是，0：否)
     */
    private String relationFlag;

    /**
     * 分摊状态(1:是，0：否)
     */
    private String proportionFlag;


    private List<OtherSettleDetailVO> detailVos = new ArrayList<>(); // 结算清单
    private List<OtherSettleOtherVO> otherVos = new ArrayList<>(); // 结算其他费用
    // 其它支出合同付款阶段记录
    private List<OtherContractPayPlanVO> stageList = new ArrayList<OtherContractPayPlanVO>();

    /**
     * 是否属于项目: 1-是（默认），0-否
     */
    private Integer dependOnProject;

    /**
     * 采购方式：
     * 1、当合同的所属组织类型为：集团、公司、分公司、经理部时，采购方式为公司集采合同（及需求中定义的框架合同）
     * 2、当合同的所属组织类型为项目部时，采购方式为项目自采合同
     */
    private Integer purchaseMode;
    /**
     * 采购方式名称
     */
    private String purchaseModeName;

    /**
     * 已收票金额
     */
    private BigDecimal sumInvoiceTaxMny;


    public BigDecimal getSumInvoiceTaxMny() {
        return sumInvoiceTaxMny;
    }

    public void setSumInvoiceTaxMny(BigDecimal sumInvoiceTaxMny) {
        this.sumInvoiceTaxMny = sumInvoiceTaxMny;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractType() {
        return contractType;
    }
    @ReferDeserialTransfer
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    public Integer getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(Integer dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public Integer getPurchaseMode() {
        return purchaseMode;
    }

    public void setPurchaseMode(Integer purchaseMode) {
        this.purchaseMode = purchaseMode;
    }

    public String getPurchaseModeName() {
        return purchaseModeName;
    }

    public void setPurchaseModeName(String purchaseModeName) {
        this.purchaseModeName = purchaseModeName;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public java.math.BigDecimal getSumSettleMny() {
		return sumSettleMny;
	}

	public void setSumSettleMny(java.math.BigDecimal sumSettleMny) {
		this.sumSettleMny = sumSettleMny;
	}

	public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public BigDecimal getPrepayMny() {
        return prepayMny;
    }

    public void setPrepayMny(BigDecimal prepayMny) {
        this.prepayMny = prepayMny;
    }

    public BigDecimal getSumOffsetMny() {
        return sumOffsetMny;
    }

    public void setSumOffsetMny(BigDecimal sumOffsetMny) {
        this.sumOffsetMny = sumOffsetMny;
    }

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public BigDecimal getSumPrepayMny() {
        return sumPrepayMny;
    }

    public void setSumPrepayMny(BigDecimal sumPrepayMny) {
        this.sumPrepayMny = sumPrepayMny;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    /**
     * 合同主键
     */
    @ReferSerialTransfer(referCode="other-contract")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 结算类型，0-过程结算，1-最终结算
     */
    public String getSettleType() {
        return settleType;
    }

    /**
     * 结算类型，0-过程结算，1-最终结算
     */
    public void setSettleType(String settleType) {
        this.settleType = settleType;
    }
    /**
     * 结算日期
     */
    public java.util.Date getSignDate() {
        return signDate;
    }

    /**
     * 结算日期
     */
    public void setSignDate(java.util.Date signDate) {
        this.signDate = signDate;
    }
    /**
     * 供应商
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商
     */
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 本期结算金额(含税)
     */
    public java.math.BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    /**
     * 本期结算金额(含税)
     */
    public void setSettleTaxMny(java.math.BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }
    /**
     * 本期结算金额(不含税)
     */
    public java.math.BigDecimal getSettleMny() {
        return settleMny;
    }

    /**
     * 本期结算金额(不含税)
     */
    public void setSettleMny(java.math.BigDecimal settleMny) {
        this.settleMny = settleMny;
    }
    /**
     * 税金
     */
    public java.math.BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税金
     */
    public void setTaxMny(java.math.BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 本次冲抵金额
     */
    public java.math.BigDecimal getThisOffsetMny() {
        return thisOffsetMny;
    }

    /**
     * 本次冲抵金额
     */
    public void setThisOffsetMny(java.math.BigDecimal thisOffsetMny) {
        this.thisOffsetMny = thisOffsetMny;
    }
    /**
     * 合同金额（含税）
     */
    public java.math.BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额（含税）
     */
    public void setContractTaxMny(java.math.BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 合同金额（不含税）
     */
    public java.math.BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额（不含税）
     */
    public void setContractMny(java.math.BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 合同税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 已结算金额
     */
    public java.math.BigDecimal getSumSettleTaxMny() {
        return sumSettleTaxMny;
    }

    /**
     * 已结算金额
     */
    public void setSumSettleTaxMny(java.math.BigDecimal sumSettleTaxMny) {
        this.sumSettleTaxMny = sumSettleTaxMny;
    }
    /**
     * 已结算比例
     */
    public java.math.BigDecimal getSumSettleRate() {
        return sumSettleRate;
    }

    /**
     * 已结算比例
     */
    public void setSumSettleRate(java.math.BigDecimal sumSettleRate) {
        this.sumSettleRate = sumSettleRate;
    }
    /**
     * 含本期累计结算金额
     */
    public java.math.BigDecimal getSumSettleAllMny() {
        return sumSettleAllMny;
    }

    /**
     * 含本期累计结算金额
     */
    public void setSumSettleAllMny(java.math.BigDecimal sumSettleAllMny) {
        this.sumSettleAllMny = sumSettleAllMny;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<OtherSettleDetailVO> getDetailVos() {
        return detailVos;
    }

    public void setDetailVos(List<OtherSettleDetailVO> detailVos) {
        this.detailVos = detailVos;
    }

    public List<OtherSettleOtherVO> getOtherVos() {
        return otherVos;
    }

    public void setOtherVos(List<OtherSettleOtherVO> otherVos) {
        this.otherVos = otherVos;
    }

    public List<OtherContractPayPlanVO> getStageList() {
        return stageList;
    }

    public void setStageList(List<OtherContractPayPlanVO> stageList) {
        this.stageList = stageList;
    }

    public BigDecimal getSumApplyMny() {
        return sumApplyMny;
    }

    public void setSumApplyMny(BigDecimal sumApplyMny) {
        this.sumApplyMny = sumApplyMny;
    }

    public BigDecimal getSurplusApplyMny() {
        return surplusApplyMny;
    }

    public void setSurplusApplyMny(BigDecimal surplusApplyMny) {
        this.surplusApplyMny = surplusApplyMny;
    }
}
