package com.ejianc.business.other.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.pub.tax.ITaxCalculate;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 其他支出合同清单
 * 
 * @author generator
 * 
 */
public class OtherContractDetailVO extends BaseVO implements ITaxCalculate {
    private static final long serialVersionUID = 1L;
    
    private Long contractId; // 合同主键
    private String code; // 清单编号
    private String name; // 清单名称
    private String unit; // 计量单位
    private java.math.BigDecimal num; // 工程量
    private java.math.BigDecimal detailTaxRate; // 税率
    private java.math.BigDecimal detailPrice; // 单价(无税)
    private java.math.BigDecimal detailTaxPrice; // 单价(含税)
    private java.math.BigDecimal detailMny; // 合价(无税)
    private java.math.BigDecimal detailTaxMny; // 合价(含税)
    private java.math.BigDecimal detailTax; // 税额
    private String detailMemo; // 备注
    private Integer changeType; // 变更类型,1-变更量，2-变更价，3-增补项，4-变更量价，5-终止，6-其他
    private Long changeId; // 变更主键
    private Long changeBid; // 变更子表主键
    private Integer srcSupplementFlag; // 是否来源补充协议(1:是，0：否)
    private Long srcSupplementId; // 来源补充协议主表ID
    private Long srcSupplementDetailId; // 来源补充协议明细ID


    //错误类型
    private String warnType;
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;


    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public Integer getSrcSupplementFlag() {
        return srcSupplementFlag;
    }

    public void setSrcSupplementFlag(Integer srcSupplementFlag) {
        this.srcSupplementFlag = srcSupplementFlag;
    }

    public Long getSrcSupplementId() {
        return srcSupplementId;
    }

    public void setSrcSupplementId(Long srcSupplementId) {
        this.srcSupplementId = srcSupplementId;
    }

    public Long getSrcSupplementDetailId() {
        return srcSupplementDetailId;
    }

    public void setSrcSupplementDetailId(Long srcSupplementDetailId) {
        this.srcSupplementDetailId = srcSupplementDetailId;
    }

    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 清单编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 清单编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 清单名称
     */
    public String getName() {
        return name;
    }

    /**
     * 清单名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 工程量
     */
    public java.math.BigDecimal getNum() {
        return num;
    }

    /**
     * 工程量
     */
    public void setNum(java.math.BigDecimal num) {
        this.num = num;
    }
    /**
     * 税率
     */
    public java.math.BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    /**
     * 税率
     */
    public void setDetailTaxRate(java.math.BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }
    /**
     * 单价(无税)
     */
    public java.math.BigDecimal getDetailPrice() {
        return detailPrice;
    }

    /**
     * 单价(无税)
     */
    public void setDetailPrice(java.math.BigDecimal detailPrice) {
        this.detailPrice = detailPrice;
    }
    /**
     * 单价(含税)
     */
    public java.math.BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    /**
     * 单价(含税)
     */
    public void setDetailTaxPrice(java.math.BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }
    /**
     * 合价(无税)
     */
    public java.math.BigDecimal getDetailMny() {
        return detailMny;
    }

    /**
     * 合价(无税)
     */
    public void setDetailMny(java.math.BigDecimal detailMny) {
        this.detailMny = detailMny;
    }
    /**
     * 合价(含税)
     */
    public java.math.BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    /**
     * 合价(含税)
     */
    public void setDetailTaxMny(java.math.BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }
    /**
     * 税额
     */
    public java.math.BigDecimal getDetailTax() {
        return detailTax;
    }

    /**
     * 税额
     */
    public void setDetailTax(java.math.BigDecimal detailTax) {
        this.detailTax = detailTax;
    }
    /**
     * 备注
     */
    public String getDetailMemo() {
        return detailMemo;
    }

    /**
     * 备注
     */
    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }
    /**
     * 变更类型,1-变更量，2-变更价，3-增补项，4-变更量价，5-终止，6-其他
     */
    public Integer getChangeType() {
        return changeType;
    }

    /**
     * 变更类型,1-变更量，2-变更价，3-增补项，4-变更量价，5-终止，6-其他
     */
    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更子表主键
     */
    public Long getChangeBid() {
        return changeBid;
    }

    /**
     * 变更子表主键
     */
    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }

    @Override
    public String[] getPriceArray() {
        return new String[]{"detailPrice"};
    }

    @Override
    public String[] getTaxPriceArray() {
        return new String[]{"detailTaxPrice"};
    }

    @Override
    public String[] getNumArray() {
        return new String[]{"num"};
    }

    @Override
    public String[] getMoneyArray() {
        return new String[]{"detailMny"};
    }

    @Override
    public String[] getTaxMoneyArray() {
        return new String[]{"detailTaxMny"};
    }

    @Override
    public String[] getTaxRateArray() {
        return new String[]{"detailTaxRate"};
    }

    @Override
    public String[] getTaxArray() {
        return new String[]{"detailTax"};
    }
}
