package com.ejianc.business.other.api;

import com.ejianc.business.other.hystrix.OtherContractHystrix;
import com.ejianc.business.tax.vo.ContractResVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 获取合同参照工厂类方法
 *
 * @author yqls
 */
@FeignClient(name = "ejc-other-web", url = "${common.env.feign-client-url}", path = "ejc-other-web", fallback = OtherContractHystrix.class)
public interface IOtherContractApi {


    /**
     * 根据条件查询不同合同类型的合同
     * @return
     */
    @GetMapping(value = "/api/other/getOtherContractById")
    public CommonResponse<ContractResVO> getContractById(@RequestParam(value = "contractId", required = true) Long contractId);


}
