package com.ejianc.business.other.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import java.math.BigDecimal;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 结算其他费用
 * 
 * @author generator
 * 
 */
public class OtherSettleOtherVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long settleId; // 结算主键
    private String otherType; // 费用类型
    private java.math.BigDecimal otherTaxRate; // 税率
    private java.math.BigDecimal otherMny; // 金额(无税)
    private java.math.BigDecimal otherTaxMny; // 金额(含税)
    private String otherMemo; // 备注
    /**
     * 成本科目主键
     */
    private Long otherSubjectId;

    /**
     * 成本科目名称
     */
    private String otherSubjectName;

    /**
     * 成本科目集团主键
     */
    private Long otherOrgSubjectId;
    /**
     * 核算对象主键
     */
    private Long otherAccountingId;

    /**
     * 核算对象名称
     */
    private String otherAccountingName;

    /**
     * 核算对象集团主键
     */
    private Long otherOrgAccountingId;

    @ReferSerialTransfer(referCode="cost-subject-set")
    public Long getOtherSubjectId() {
        return otherSubjectId;
    }
    @ReferDeserialTransfer
    public void setOtherSubjectId(Long otherSubjectId) {
        this.otherSubjectId = otherSubjectId;
    }

    public String getOtherSubjectName() {
        return otherSubjectName;
    }

    public void setOtherSubjectName(String otherSubjectName) {
        this.otherSubjectName = otherSubjectName;
    }

    public Long getOtherOrgSubjectId() {
        return otherOrgSubjectId;
    }

    public void setOtherOrgSubjectId(Long otherOrgSubjectId) {
        this.otherOrgSubjectId = otherOrgSubjectId;
    }
    @ReferSerialTransfer(referCode="accounting-project-ref")
    public Long getOtherAccountingId() {
        return otherAccountingId;
    }
    @ReferDeserialTransfer
    public void setOtherAccountingId(Long otherAccountingId) {
        this.otherAccountingId = otherAccountingId;
    }

    public String getOtherAccountingName() {
        return otherAccountingName;
    }

    public void setOtherAccountingName(String otherAccountingName) {
        this.otherAccountingName = otherAccountingName;
    }

    public Long getOtherOrgAccountingId() {
        return otherOrgAccountingId;
    }

    public void setOtherOrgAccountingId(Long otherOrgAccountingId) {
        this.otherOrgAccountingId = otherOrgAccountingId;
    }

    /**
     * 结算主键
     */
    @ReferSerialTransfer(referCode="cost-subject-set")
    public Long getSettleId() {
        return settleId;
    }

    /**
     * 结算主键
     */
    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }
    /**
     * 费用类型
     */
    public String getOtherType() {
        return otherType;
    }

    /**
     * 费用类型
     */
    public void setOtherType(String otherType) {
        this.otherType = otherType;
    }
    /**
     * 税率
     */
    public java.math.BigDecimal getOtherTaxRate() {
        return otherTaxRate;
    }

    /**
     * 税率
     */
    public void setOtherTaxRate(java.math.BigDecimal otherTaxRate) {
        this.otherTaxRate = otherTaxRate;
    }
    /**
     * 金额(无税)
     */
    public java.math.BigDecimal getOtherMny() {
        return otherMny;
    }

    /**
     * 金额(无税)
     */
    public void setOtherMny(java.math.BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    /**
     * 金额(含税)
     */
    public java.math.BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    /**
     * 金额(含税)
     */
    public void setOtherTaxMny(java.math.BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }
    /**
     * 备注
     */
    public String getOtherMemo() {
        return otherMemo;
    }

    /**
     * 备注
     */
    public void setOtherMemo(String otherMemo) {
        this.otherMemo = otherMemo;
    }
    
}
