/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.other.hystrix.OtherContractHystrix;
import com.ejianc.business.other.vo.OtherProjectReportVo;
import com.ejianc.business.other.vo.OtherSettleVO;
import com.ejianc.business.tax.vo.ContractResVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@FeignClient(name="ejc-other-web", url="${common.env.feign-client-url}", path="ejc-other-web", fallback=OtherContractHystrix.class)
public interface IOtherContractApi {
    @GetMapping(value={"/api/other/getOtherContractById"})
    public CommonResponse<ContractResVO> getContractById(@RequestParam(value="contractId", required=true) Long var1);

    @RequestMapping(value={"/api/other/getMonthOtherMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<OtherProjectReportVo>> getMonthOtherMny(@RequestParam(value="projectId") Long var1, @RequestParam(value="lastDay") Integer var2);

    @GetMapping(value={"/api/other/getOtherContract"})
    @ResponseBody
    public CommonResponse<OtherProjectReportVo> getOtherContract(@RequestParam(value="projectId") Long var1);

    @GetMapping(value={"/api/other/updateOtherContractSumPayMny"})
    public CommonResponse<String> updateOtherContractSumPayMny(@RequestParam(value="contractId", required=true) Long var1, @RequestParam(value="payMny") BigDecimal var2, @RequestParam(value="prepayMny") BigDecimal var3);

    @GetMapping(value={"/api/other/updateOtherSettleSumPayMny"})
    public CommonResponse<String> updateOtherSettleSumPayMny(@RequestParam(value="settleId", required=true) Long var1, @RequestParam(value="payMny") BigDecimal var2);

    @GetMapping(value={"/api/other/updateOtherSettleSumApplyMny"})
    public CommonResponse<String> updateOtherSettleSumApplyMny(@RequestParam(value="settleId", required=true) Long var1, @RequestParam(value="applyMny") BigDecimal var2);

    @GetMapping(value={"/api/other/getOtherSettlementById"})
    public CommonResponse<OtherSettleVO> getOtherSettlementById(@RequestParam(value="contractId", required=true) Long var1, @RequestParam(value="orgId", required=true) Long var2);

    @PostMapping(value={"/api/other/otherAfterApproveInvoiceReceive"})
    public CommonResponse<String> otherAfterApproveInvoiceReceive(@RequestParam(value="contractId", required=true) Long var1, @RequestParam(value="invoiceMny") BigDecimal var2, @RequestParam(value="invoiceTaxMny") BigDecimal var3);

    @PostMapping(value={"/api/other/otherAfterRevocationInvoiceReceive"})
    public CommonResponse<JSONObject> otherAfterRevocationInvoiceReceive(@RequestParam(value="contractId", required=true) Long var1, @RequestParam(value="invoiceMny") BigDecimal var2, @RequestParam(value="invoiceTaxMny") BigDecimal var3);

    @GetMapping(value={"/api/other/budgetControlTotal"})
    public CommonResponse<BigDecimal> budgetControlTotal(@RequestParam(value="projectId", required=true) Long var1);

    @PostMapping(value={"/api/other/getContractMnyByProjectIds"})
    @ResponseBody
    public CommonResponse<OtherProjectReportVo> getContractMnyByProjectIds(@RequestBody List<Long> var1);

    @GetMapping(value={"/api/other/fetchSjzcje"})
    public CommonResponse<BigDecimal> fetchSjzcje(@RequestParam(value="projectId") Long var1);
}

