package com.ejianc.business.other.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import java.math.BigDecimal;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 结算清单
 * 
 * @author generator
 * 
 */
public class OtherSettleDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long settleId; // 结算主键
    private String code; // 清单编号
    private String name; // 清单名称
    private String unit; // 计量单位
    private java.math.BigDecimal num; // 工程量
    private java.math.BigDecimal settleNum; // 本期结算量
    private java.math.BigDecimal detailTaxRate; // 税率
    private java.math.BigDecimal detailPrice; // 单价(无税)
    private java.math.BigDecimal detailTaxPrice; // 单价(含税)
    private java.math.BigDecimal detailMny; // 结算金额(无税)
    private java.math.BigDecimal detailTaxMny; // 结算金额(含税)
    private java.math.BigDecimal detailTax; // 税额
    private String detailMemo; // 备注
    private String sourceType; // 来源,0-合同内，1-合同外
    private String sourceTypeName;
    private Long sourceId; // 来源主键
    /**
     * 成本科目主键
     */
    private Long subjectId;

    /**
     * 成本科目名称
     */
    private String subjectName;

    /**
     * 成本科目集团主键
     */
    private Long orgSubjectId;

    /**
     * 核算对象主键
     */
    private Long accountingId;

    /**
     * 核算对象名称
     */
    private String accountingName;

    /**
     * 核算对象集团主键
     */
    private Long orgAccountingId;
    
    private String settlementCode;
    
    private BigDecimal sumNum;
    
    


    public BigDecimal getSumNum() {
		return sumNum;
	}
	public void setSumNum(BigDecimal sumNum) {
		this.sumNum = sumNum;
	}
    

    public String getSourceTypeName() {
		return sourceTypeName;
	}

	public void setSourceTypeName(String sourceTypeName) {
		this.sourceTypeName = sourceTypeName;
	}

	public String getSettlementCode() {
		return settlementCode;
	}

	public void setSettlementCode(String settlementCode) {
		this.settlementCode = settlementCode;
	}

    @ReferSerialTransfer(referCode="cost-subject-set")
    public Long getSubjectId() {
        return subjectId;
    }

    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Long getOrgSubjectId() {
        return orgSubjectId;
    }

    public void setOrgSubjectId(Long orgSubjectId) {
        this.orgSubjectId = orgSubjectId;
    }

    @ReferSerialTransfer(referCode="accounting-project-ref")
    public Long getAccountingId() {
        return accountingId;
    }
    @ReferDeserialTransfer
    public void setAccountingId(Long accountingId) {
        this.accountingId = accountingId;
    }

    public String getAccountingName() {
        return accountingName;
    }

    public void setAccountingName(String accountingName) {
        this.accountingName = accountingName;
    }

    public Long getOrgAccountingId() {
        return orgAccountingId;
    }

    public void setOrgAccountingId(Long orgAccountingId) {
        this.orgAccountingId = orgAccountingId;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    /**
     * 结算主键
     */
    public Long getSettleId() {
        return settleId;
    }

    /**
     * 结算主键
     */
    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }
    /**
     * 清单编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 清单编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 清单名称
     */
    public String getName() {
        return name;
    }

    /**
     * 清单名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 工程量
     */
    public java.math.BigDecimal getNum() {
        return num;
    }

    /**
     * 工程量
     */
    public void setNum(java.math.BigDecimal num) {
        this.num = num;
    }
    /**
     * 本期结算量
     */
    public java.math.BigDecimal getSettleNum() {
        return settleNum;
    }

    /**
     * 本期结算量
     */
    public void setSettleNum(java.math.BigDecimal settleNum) {
        this.settleNum = settleNum;
    }
    /**
     * 税率
     */
    public java.math.BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    /**
     * 税率
     */
    public void setDetailTaxRate(java.math.BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }
    /**
     * 单价(无税)
     */
    public java.math.BigDecimal getDetailPrice() {
        return detailPrice;
    }

    /**
     * 单价(无税)
     */
    public void setDetailPrice(java.math.BigDecimal detailPrice) {
        this.detailPrice = detailPrice;
    }
    /**
     * 单价(含税)
     */
    public java.math.BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    /**
     * 单价(含税)
     */
    public void setDetailTaxPrice(java.math.BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }
    /**
     * 结算金额(无税)
     */
    public java.math.BigDecimal getDetailMny() {
        return detailMny;
    }

    /**
     * 结算金额(无税)
     */
    public void setDetailMny(java.math.BigDecimal detailMny) {
        this.detailMny = detailMny;
    }
    /**
     * 结算金额(含税)
     */
    public java.math.BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    /**
     * 结算金额(含税)
     */
    public void setDetailTaxMny(java.math.BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }
    /**
     * 税额
     */
    public java.math.BigDecimal getDetailTax() {
        return detailTax;
    }

    /**
     * 税额
     */
    public void setDetailTax(java.math.BigDecimal detailTax) {
        this.detailTax = detailTax;
    }
    /**
     * 备注
     */
    public String getDetailMemo() {
        return detailMemo;
    }

    /**
     * 备注
     */
    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }
    /**
     * 来源,0-合同内，1-合同外
     */
    public String getSourceType() {
        return sourceType;
    }

    /**
     * 来源,0-合同内，1-合同外
     */
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    
}
