package com.ejianc.business.other.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;

/**
 * 其他合同
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("otherContractFileUpdate")
public class OtherContractFileUpdateController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOtherContractService service;

    /**
     * @Description wps回掉方法，回写附件id
     */
    @RequestMapping(value = "/updateFileInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        Long billId = updateData.getLong("billId");
        LambdaUpdateWrapper<OtherContractEntity> updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(OtherContractEntity::getId, billId);
        updateWrapper.set(OtherContractEntity::getContractFileId, updateData.getLong("fileId"));
        service.update(updateWrapper);

        JSONObject resp = new JSONObject();
        resp.put("message", "合同文件信息更新成功");
        return CommonResponse.success("合同文件信息更新成功！", resp);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/getBillDataJson", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherContractVO> getBillDataJson(Long id) {
        OtherContractEntity entity = service.selectById(id);
        OtherContractVO vo = BeanMapper.map(entity, OtherContractVO.class);

        /*List<OutcontractSupplierVO> outcontractSupplierList = new ArrayList<>();
        OutcontractSupplierVO outcontractSupplierVO = BeanMapper.map(entity, OutcontractSupplierVO.class);
        outcontractSupplierVO.setRowState("add");
        outcontractSupplierList.add(outcontractSupplierVO);
        vo.setOutcontractSupplierList(outcontractSupplierList);

        // 分包工程总价汇总表
        OutcontractSubcontractTotalPriceVO outcontractSubcontractTotalPriceVO = new OutcontractSubcontractTotalPriceVO();
        outcontractSubcontractTotalPriceVO.setId(11111l);
        outcontractSubcontractTotalPriceVO.setItemName("合计");
        outcontractSubcontractTotalPriceVO.setTotalPrice(vo.getContractPrice());
        vo.getOutcontractSubcontractTotalPriceList().add(outcontractSubcontractTotalPriceVO);
        // 分包工程综合单价计价表
        OutcontractSubcontractUnitPriceVO outcontractSubcontractUnitPriceVO = new OutcontractSubcontractUnitPriceVO();
        outcontractSubcontractUnitPriceVO.setId(22222l);
        outcontractSubcontractUnitPriceVO.setListCode("合计");
        outcontractSubcontractUnitPriceVO.setTotalPrice(vo.getContractPrice());
        vo.getOutcontractSubcontractUnitPriceList().add(outcontractSubcontractUnitPriceVO);
        // 物资（周转材）合同价
        OutcontractMaterialVO outcontractMaterialVO = new OutcontractMaterialVO();
        outcontractMaterialVO.setId(33333l);
        outcontractMaterialVO.setMaterialCode("合计");
        outcontractMaterialVO.setTotalPrice(vo.getContractPrice());
        vo.getOutcontractMaterialList().add(outcontractMaterialVO);
        // 租赁物进出场费明细表
        OutcontractEquipmentLeaseItemVO outcontractEquipmentLeaseItemVO = new OutcontractEquipmentLeaseItemVO();
        outcontractEquipmentLeaseItemVO.setId(44444l);
        outcontractEquipmentLeaseItemVO.setEquipmentCode("合计");
        outcontractEquipmentLeaseItemVO.setTotalPrice(vo.getLeaseItemTotalAmount());
        vo.getOutcontractEquipmentLeaseItemList().add(outcontractEquipmentLeaseItemVO);
        // 租金明细表
        OutcontractEquipmentRentVO outcontractEquipmentRentVO = new OutcontractEquipmentRentVO();
        outcontractEquipmentRentVO.setId(55555l);
        outcontractEquipmentRentVO.setEquipmentCode("合计");
        outcontractEquipmentRentVO.setTotalPrice(vo.getRentTotalAmount());
        vo.getOutcontractEquipmentRentList().add(outcontractEquipmentRentVO);*/

        return CommonResponse.success("查询详情数据成功！",vo);
    }


    /**
     * @Description  归档
     */
    @RequestMapping(value = "/onFile", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> onFile(@RequestBody OtherContractVO contractVO){
        return service.onFile(contractVO);
    }

}
