/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.mapper.OtherContractMapper;
import com.ejianc.business.other.service.CommonBillCodeService;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherContractService")
public class OtherContractServiceImpl
extends BaseServiceImpl<OtherContractMapper, OtherContractEntity>
implements IOtherContractService {
    private static final String BILL_CODE = "OTHER_CONTRACT";
    @Autowired
    private CommonBillCodeService commonBillCodeService;

    @Override
    public CommonResponse<OtherContractVO> saveOrUpdate(OtherContractVO contractVo) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherContractEntity entity = null;
        String operateType = null;
        if (contractVo.getId() != null && contractVo.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)contractVo.getBillCode())) {
                contractVo.setBillCode(null);
            }
            entity = (OtherContractEntity)((Object)BeanMapper.map((Object)contractVo, OtherContractEntity.class));
            operateType = "edit";
        } else {
            if (StringUtils.isEmpty((CharSequence)contractVo.getBillCode())) {
                String code = this.commonBillCodeService.getCodeByOrgId(contractVo.getOrgId(), BILL_CODE, (BaseVO)contractVo);
                contractVo.setBillCode(code);
            }
            contractVo.setIsFinish(Integer.valueOf(0));
            entity = (OtherContractEntity)((Object)BeanMapper.map((Object)contractVo, OtherContractEntity.class));
            operateType = "add";
        }
        if (contractVo.getId() != null && contractVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(OtherContractEntity::getBillCode, (Object)contractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)contractVo.getId());
            List entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(OtherContractEntity::getBillCode, (Object)contractVo.getBillCode());
            List entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        entity.setSupplementFlag(0);
        entity.setBaseTaxMoney(entity.getContractTaxMny());
        entity.setBaseMoney(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)this.queryDetail(entity.getId()));
    }

    @Override
    public OtherContractVO queryDetail(Long id) {
        OtherContractEntity entity = (OtherContractEntity)((Object)super.selectById((Serializable)id));
        OtherContractVO vo = (OtherContractVO)BeanMapper.map((Object)((Object)entity), OtherContractVO.class);
        return vo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = OtherContractServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"round(sum(base_tax_money),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }
}

