package com.ejianc.business.other.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.vo.OtherContractVO;

/**
 * 其他支出合同实体
 *
 * @author generator
 */
@Controller
@RequestMapping("otherContract")
public class OtherContractController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IOtherContractService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherContractVO> saveOrUpdate(@RequestBody OtherContractVO saveorUpdateVO) {
        CommonResponse<OtherContractVO> response = service.saveOrUpdate(saveorUpdateVO);
        return response;
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherContractVO> queryDetail(Long id) {
        OtherContractVO vo = service.queryDetail(id);
        return CommonResponse.success(vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OtherContractVO> vos) {
        service.removeByIds(vos.stream().map(OtherContractVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplement_flag", new Parameter("eq", 0));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<OtherContractEntity> pageData = service.queryPage(param, false);
        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = service.countContractAmount(param);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), OtherContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("contractCount", contractAmountMap);
        return CommonResponse.success("查询列表数据成功！", page);


    }

    /**
     * 合同参照
     *
     * @param pageNumber
     * @param pageSize
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/queryRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OtherContractEntity>> queryRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                               @RequestParam(defaultValue = "10") Integer pageSize,
                                                               @RequestParam(value = "searchText", required = false) String searchText,
                                                               @RequestParam(value = "condition", required = false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("billCode");
        //竣工结算标志
        queryParam.getParams().put("is_finish", new Parameter(QueryParam.EQ, 0));
        queryParam.getParams().put("supplement_flag", new Parameter("eq", 0));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
            if (null != conditionMap.get("isFinishFlag")) {
                boolean flag = Boolean.valueOf(conditionMap.get("isFinishFlag").toString());
                // isFinishFlag 是否根据竣工过滤
                if (!flag) {
                    queryParam.getParams().remove("is_finish");
                }
            }
        }
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billStatus));
        //queryParam.getOrderMap().put("signDate","desc");
        queryParam.getOrderMap().put("createTime", "desc");
        return CommonResponse.success("查询列表数据成功！", service.queryPage(queryParam, false));
    }

    /**
     * 合同状态修改
     *
     * @param contractVo
     * @return
     */
    @PostMapping("/changeState")
    @ResponseBody
    public CommonResponse<String> changeState(@RequestBody OtherContractVO contractVo) {
        LambdaUpdateWrapper<OtherContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(OtherContractEntity::getId, contractVo.getId());
        updateWrapper.set(OtherContractEntity::getContractStatus, contractVo.getContractStatus());
        service.update(updateWrapper);
        return CommonResponse.success("修改合同状态成功！");
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OtherContractEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OtherContract-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refOtherContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OtherContractVO>> refOtherContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OtherContractEntity> page = service.queryPage(param, false);
        IPage<OtherContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OtherContractVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
