package com.ejianc.business.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.other.vo.OtherContractDetailHistoryVO;
import com.ejianc.business.other.vo.OtherContractHistoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.other.mapper.OtherContractHistoryMapper;
import com.ejianc.business.other.bean.OtherContractHistoryEntity;
import com.ejianc.business.other.service.IOtherContractHistoryService;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/**
 * 其他支出合同记录
 * 
 * @author generator
 * 
 */
@Service("otherContractHistoryService")
public class OtherContractHistoryServiceImpl extends BaseServiceImpl<OtherContractHistoryMapper, OtherContractHistoryEntity> implements IOtherContractHistoryService{

    @Override
    public OtherContractHistoryVO queryDetailByChangeId(Long id) {

        OtherContractHistoryEntity historyEntity = super.getOne(new QueryWrapper<OtherContractHistoryEntity>().eq("change_id", id));
        if(historyEntity !=null){
            OtherContractHistoryVO historyVo = BeanMapper.map(historyEntity, OtherContractHistoryVO.class);
            List<OtherContractDetailHistoryVO> detailVos = historyVo.getDetailVos();
            if (detailVos != null && detailVos.size() > 0) {
                Iterator<OtherContractDetailHistoryVO> iterator = detailVos.iterator();
                while (iterator.hasNext()) {
                    OtherContractDetailHistoryVO next = iterator.next();
                    if (next.getChangeType() != null && next.getChangeType() == 5) {
                        iterator.remove();
                    }
                }
            }
            historyVo.setDetailVos(detailVos);
            return historyVo;
        }
        return null;
    }
}
