package com.ejianc.business.other.bean;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.other.bean.OtherSettleDetailEntity;
import com.ejianc.business.other.bean.OtherSettleOtherEntity;
/**
 * 结算
 * 
 * @author generator
 * 
 */
 @TableName("ejc_other_settle")
public class OtherSettleEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="settle_type")
    private String settleType; // 结算类型，0-过程结算，1-最终结算
    @TableField(value="sign_date")
    private java.util.Date signDate; // 结算日期
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="settle_tax_mny")
    private java.math.BigDecimal settleTaxMny; // 本期结算金额(含税)
    @TableField(value="settle_mny")
    private java.math.BigDecimal settleMny; // 本期结算金额(不含税)
    @TableField(value="tax_mny")
    private java.math.BigDecimal taxMny; // 税金
    @TableField(value="this_offset_mny")
    private java.math.BigDecimal thisOffsetMny; // 本次冲抵金额
    @TableField(value="contract_tax_mny")
    private java.math.BigDecimal contractTaxMny; // 合同金额（含税）
    @TableField(value="contract_mny")
    private java.math.BigDecimal contractMny; // 合同金额（不含税）
    @TableField(value="tax_rate")
    private java.math.BigDecimal taxRate; // 合同税率
    @TableField(value="sum_settle_tax_mny")
    private java.math.BigDecimal sumSettleTaxMny; // 已结算金额
    @TableField(value="sum_settle_rate")
    private java.math.BigDecimal sumSettleRate; // 已结算比例
    @TableField(value="sum_settle_all_mny")
    private java.math.BigDecimal sumSettleAllMny; // 含本期累计结算金额
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="sum_offset_mny")
    private java.math.BigDecimal sumOffsetMny; // 累计冲抵金额
    @TableField(value="sum_pay_mny")
    private java.math.BigDecimal sumPayMny; // 累计付款金额
    @TableField(value="sum_prepay_mny")
    private java.math.BigDecimal sumPrepayMny; // 累计预付款金额
    
    @TableField(exist=false)
    @SubEntity(serviceName="otherSettleDetailService",pidName = "settleId")
    private List<OtherSettleDetailEntity> detailVos = new ArrayList<>(); // 结算清单
    @TableField(exist=false)
    @SubEntity(serviceName="otherSettleOtherService",pidName = "settleId")
    private List<OtherSettleOtherEntity> otherVos = new ArrayList<>(); // 结算其他费用


    public BigDecimal getSumOffsetMny() {
        return sumOffsetMny;
    }

    public void setSumOffsetMny(BigDecimal sumOffsetMny) {
        this.sumOffsetMny = sumOffsetMny;
    }

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public BigDecimal getSumPrepayMny() {
        return sumPrepayMny;
    }

    public void setSumPrepayMny(BigDecimal sumPrepayMny) {
        this.sumPrepayMny = sumPrepayMny;
    }

    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 结算类型，0-过程结算，1-最终结算
     */
    public String getSettleType() {
        return settleType;
    }

    /**
     * 结算类型，0-过程结算，1-最终结算
     */
    public void setSettleType(String settleType) {
        this.settleType = settleType;
    }
    /**
     * 结算日期
     */
    public java.util.Date getSignDate() {
        return signDate;
    }

    /**
     * 结算日期
     */
    public void setSignDate(java.util.Date signDate) {
        this.signDate = signDate;
    }
    /**
     * 供应商
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 本期结算金额(含税)
     */
    public java.math.BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    /**
     * 本期结算金额(含税)
     */
    public void setSettleTaxMny(java.math.BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }
    /**
     * 本期结算金额(不含税)
     */
    public java.math.BigDecimal getSettleMny() {
        return settleMny;
    }

    /**
     * 本期结算金额(不含税)
     */
    public void setSettleMny(java.math.BigDecimal settleMny) {
        this.settleMny = settleMny;
    }
    /**
     * 税金
     */
    public java.math.BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税金
     */
    public void setTaxMny(java.math.BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 本次冲抵金额
     */
    public java.math.BigDecimal getThisOffsetMny() {
        return thisOffsetMny;
    }

    /**
     * 本次冲抵金额
     */
    public void setThisOffsetMny(java.math.BigDecimal thisOffsetMny) {
        this.thisOffsetMny = thisOffsetMny;
    }
    /**
     * 合同金额（含税）
     */
    public java.math.BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额（含税）
     */
    public void setContractTaxMny(java.math.BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 合同金额（不含税）
     */
    public java.math.BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额（不含税）
     */
    public void setContractMny(java.math.BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 合同税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 已结算金额
     */
    public java.math.BigDecimal getSumSettleTaxMny() {
        return sumSettleTaxMny;
    }

    /**
     * 已结算金额
     */
    public void setSumSettleTaxMny(java.math.BigDecimal sumSettleTaxMny) {
        this.sumSettleTaxMny = sumSettleTaxMny;
    }
    /**
     * 已结算比例
     */
    public java.math.BigDecimal getSumSettleRate() {
        return sumSettleRate;
    }

    /**
     * 已结算比例
     */
    public void setSumSettleRate(java.math.BigDecimal sumSettleRate) {
        this.sumSettleRate = sumSettleRate;
    }
    /**
     * 含本期累计结算金额
     */
    public java.math.BigDecimal getSumSettleAllMny() {
        return sumSettleAllMny;
    }

    /**
     * 含本期累计结算金额
     */
    public void setSumSettleAllMny(java.math.BigDecimal sumSettleAllMny) {
        this.sumSettleAllMny = sumSettleAllMny;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<OtherSettleDetailEntity> getDetailVos() {
        return detailVos;
    }

    public void setDetailVos(List<OtherSettleDetailEntity> detailVos) {
        this.detailVos = detailVos;
    }

    public List<OtherSettleOtherEntity> getOtherVos() {
        return otherVos;
    }

    public void setOtherVos(List<OtherSettleOtherEntity> otherVos) {
        this.otherVos = otherVos;
    }
}
