/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.api;

import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.tax.vo.ContractResVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/other/"})
public class OtherContractApi {
    @Autowired
    private IOtherContractService otherContractService;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private ICustomerApi customerApi;

    @GetMapping(value={"/getOtherContractById"})
    public CommonResponse<ContractResVO> getOtherContractById(@RequestParam(value="contractId") Long contractId) {
        OtherContractEntity otherContractEntity = (OtherContractEntity)((Object)this.otherContractService.selectById(contractId));
        ContractResVO otherContractVO = (ContractResVO)BeanMapper.map((Object)((Object)otherContractEntity), ContractResVO.class);
        if (null != otherContractEntity) {
            CommonResponse supplierVOCommonResponse = this.supplierApi.queryById(otherContractEntity.getSupplierId());
            if (supplierVOCommonResponse.isSuccess() && supplierVOCommonResponse.getData() != null) {
                otherContractVO.setSupplierCreditCode(((SupplierVO)supplierVOCommonResponse.getData()).getSocialCreditCode());
            }
            CommonResponse customerVOCommonResponse = this.customerApi.detailById(otherContractEntity.getCustomerId());
            if (supplierVOCommonResponse.isSuccess() && customerVOCommonResponse.getData() != null) {
                otherContractVO.setCustomerCreditCode(((CustomerVO)customerVOCommonResponse.getData()).getSocialCreditCode());
            }
        } else {
            return CommonResponse.error((String)"\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u5931\u8d25!");
        }
        return CommonResponse.success((String)"\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u6210\u529f", (Object)otherContractVO);
    }
}

