package com.ejianc.business.other.api;


import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.vo.OtherProjectReportVo;
import com.ejianc.business.tax.vo.ContractResVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/other/")
public class OtherContractApi {

    @Autowired
    private IOtherContractService otherContractService;

    @Autowired
    private ISupplierApi supplierApi;

    @Autowired
    private ICustomerApi customerApi;

    /**
     * 租赁合同跳转收票, 根据主键查询合同相关信息
     * @param contractId
     * @return
     */
    @GetMapping(value = "/getOtherContractById")
    public CommonResponse<ContractResVO> getOtherContractById(@RequestParam("contractId") Long contractId) {
        OtherContractEntity otherContractEntity = otherContractService.selectById(contractId);
        ContractResVO otherContractVO = BeanMapper.map(otherContractEntity, ContractResVO.class);
        if (null != otherContractEntity) {
            CommonResponse<SupplierVO> supplierVOCommonResponse = supplierApi.queryById(otherContractEntity.getSupplierId());
            if (supplierVOCommonResponse.isSuccess() && supplierVOCommonResponse.getData() != null) {
                otherContractVO.setSupplierCreditCode(supplierVOCommonResponse.getData().getSocialCreditCode());
            }
            CommonResponse<CustomerVO> customerVOCommonResponse = customerApi.detailById(otherContractEntity.getCustomerId());
            if (supplierVOCommonResponse.isSuccess() && customerVOCommonResponse.getData() != null) {
                otherContractVO.setCustomerCreditCode(customerVOCommonResponse.getData().getSocialCreditCode());
            }
        } else {
            return CommonResponse.error("获取合同信息失败!");
        }
        return CommonResponse.success("获取合同信息成功", otherContractVO);
    }

    /**
     * 查其他合同结算
     *
     * @param projectId
     * @param lastDay
     * @return
     */
    @RequestMapping(value = "/getMonthOtherMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<OtherProjectReportVo>> getMonthOtherMny(@RequestParam(value = "projectId") Long projectId
            , @RequestParam(value = "lastDay") Integer lastDay) {

        return CommonResponse.success("查询列表数据成功", otherContractService.getMonthOtherMny(projectId, lastDay));

    }


}
