package com.ejianc.business.other.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.other.history.SettleHistoryVo;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.service.IOtherSettleService;
import com.ejianc.business.other.vo.OtherSettleVO;

/**
 * 结算
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("otherSettle")
public class OtherSettleController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IPayContractApi payContractApi;

    @Autowired
    private IOtherContractService  otherContractService;


    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    
    @Autowired
    private IOtherSettleService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherSettleVO> saveOrUpdate(@RequestBody OtherSettleVO saveorUpdateVO) {
        CommonResponse<OtherSettleVO> response = service.saveOrUpdate(saveorUpdateVO);
        return response;
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherSettleVO> queryDetail(Long id) {
        OtherSettleVO vo = service.queryDetail(id);
        return CommonResponse.success(vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OtherSettleVO> vos) {
        service.removeByIds(vos.stream().map(OtherSettleVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OtherSettleVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<OtherSettleEntity> page = service.queryPage(param,false);
        IPage<OtherSettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OtherSettleVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OtherSettleEntity> entityList = service.queryList(param);
        List<OtherSettleVO> list = BeanMapper.mapList(entityList, OtherSettleVO.class);
        list.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OtherSettle-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refOtherSettleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OtherSettleVO>> refOtherSettleData(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                                       @RequestParam(defaultValue = "10") Integer pageSize,
                                                                       @RequestParam(value = "searchText", required = false) String searchText,
                                                                       @RequestParam(value = "condition", required = false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getFuzzyFields().add("employeeName");

        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
            }
            if (null != conditionMap.get("settleType")) {
                String settleType = conditionMap.get("settleType").toString();
                queryParam.getParams().put("settleType", new Parameter(QueryParam.EQ, settleType));
            }
        }
        IPage<OtherSettleEntity> pageData = service.queryPage(queryParam, false);
        IPage<OtherSettleVO> result = new Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), OtherSettleVO.class));
        return CommonResponse.success("查询清单参照成功！", result);
    }
    /**
     * 结算历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySettleHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleHistoryVo> querySettleHistory(@RequestParam Long id) {
        SettleHistoryVo vo = service.querySettleHistory(id);
        return CommonResponse.success(vo);
    }

    /**
     * 根据主键ID,orgId查询累计结算金额，累计冲抵金额,累计付款，累计预付款金额
     * @param
     * @return
     */
    @RequestMapping(value = "/querySumSettlementTaxMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherSettleVO> querySumSettlementTaxMny(@RequestParam Long contractId,@RequestParam Long orgId) {
        /** 剩余冲抵金额 = 累计预付款 - 累计已冲抵 */
        OtherSettleVO vo = new OtherSettleVO();
        CommonResponse<SumPayMnyVO> sumPayMnyVO = payContractApi.getSumPayMny(contractId,orgId);
        if(!sumPayMnyVO.isSuccess()) {
            return CommonResponse.success("获取付款信息失败，请刷新后再试！");
        }
        BigDecimal sumPayMny = sumPayMnyVO.getData().getSumPayMny();
        BigDecimal sumPrePayMny = sumPayMnyVO.getData().getSumPrePayMny();
        vo.setSumPayMny(sumPayMny==null?BigDecimal.ZERO:sumPayMny);
        vo.setSumPrepayMny(sumPrePayMny==null?BigDecimal.ZERO:sumPrePayMny);
        LambdaQueryWrapper<OtherSettleEntity> lambdachange = Wrappers.<OtherSettleEntity>lambdaQuery();
        lambdachange.eq(OtherSettleEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambdachange.eq(OtherSettleEntity::getContractId,contractId);
        lambdachange.eq(OtherSettleEntity::getOrgId,orgId);
        lambdachange.in(OtherSettleEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<OtherSettleEntity> list = service.list(lambdachange);
        if(CollectionUtils.isNotEmpty(list)){
            final BigDecimal[] alreadyRentMoney = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP),new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
            list.forEach(e-> {
                alreadyRentMoney[0] = alreadyRentMoney[0].add(e.getSettleTaxMny()==null? BigDecimal.ZERO:e.getSettleTaxMny());
                //alreadyRentMoney[1] = alreadyRentMoney[1].add(e.getOffsetMny()==null? BigDecimal.ZERO:e.getOffsetMny());
            });
            //累计结算金额
            vo.setSumSettleTaxMny(alreadyRentMoney[0]);
            //累计冲抵金额
            vo.setSumOffsetMny(alreadyRentMoney[1]);
        }
        /*BigDecimal sumOffsetMnys = vo.getSumOffsetMny()==null?BigDecimal.ZERO:vo.getSumOffsetMny();
        if(vo.getSumPrepayMny().compareTo(BigDecimal.ZERO)>=0&&sumOffsetMnys.compareTo(BigDecimal.ZERO)>=0){
            vo.setSymny(vo.getSumPrepayMny().subtract(sumOffsetMnys));
        }
        OtherContractVO otherContractVO = otherContractService.queryDetail(contractId);
        vo.setStageList(otherContractVO.getRentstage());*/
        return CommonResponse.success(vo);
    }


}
