/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.history.SettleHistoryVo;
import com.ejianc.business.other.mapper.OtherSettleMapper;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherSettleService;
import com.ejianc.business.other.vo.OtherSettleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherSettleService")
public class OtherSettleServiceImpl
extends BaseServiceImpl<OtherSettleMapper, OtherSettleEntity>
implements IOtherSettleService {
    private static final String BILL_CODE = "OTHER_SETTLE_CODE";
    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public CommonResponse<OtherSettleVO> saveOrUpdate(OtherSettleVO saveorUpdateVO) {
        OtherContractEntity otherContractEntity;
        int num;
        LambdaQueryWrapper lambdaQuery;
        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherSettleEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            operateType = "edit";
            lambdaQuery = Wrappers.lambdaQuery();
            lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambdaQuery.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            lambdaQuery.eq(OtherSettleEntity::getContractId, (Object)saveorUpdateVO.getContractId());
            lambdaQuery.ne(OtherSettleEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
            lambdaQuery.ne(OtherSettleEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
            num = super.count((Wrapper)lambdaQuery);
            if (num > 0) {
                throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355!");
            }
        } else {
            operateType = "add";
            lambdaQuery = Wrappers.lambdaQuery();
            lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambdaQuery.eq(OtherSettleEntity::getContractId, (Object)saveorUpdateVO.getContractId());
            lambdaQuery.ne(OtherSettleEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
            lambdaQuery.ne(OtherSettleEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
            num = super.count((Wrapper)lambdaQuery);
            if (num > 0) {
                throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355!");
            }
        }
        if ((otherContractEntity = (OtherContractEntity)((Object)this.contractService.selectById(saveorUpdateVO.getContractId()))).getIsFinish() != null && otherContractEntity.getIsFinish() == 1) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b8c\u5de5\u7ed3\u7b97!");
        }
        if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                saveorUpdateVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            entity = (OtherSettleEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OtherSettleEntity.class));
            operateType = "edit";
        } else {
            entity = (OtherSettleEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OtherSettleEntity.class));
            operateType = "add";
        }
        List entities = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(OtherSettleEntity::getBillCode, (Object)saveorUpdateVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            entities = super.list((Wrapper)lambda);
        } else {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(OtherSettleEntity::getBillCode, (Object)saveorUpdateVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            entities = super.list((Wrapper)lambda);
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setSumSettleAllMny(MathUtil.safeAdd((BigDecimal)entity.getSettleTaxMny(), (BigDecimal)entity.getSumSettleTaxMny()));
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)this.queryDetail(entity.getId()));
    }

    @Override
    public OtherSettleVO queryDetail(Long id) {
        OtherSettleEntity entity = (OtherSettleEntity)((Object)super.selectById((Serializable)id));
        OtherSettleVO vo = (OtherSettleVO)BeanMapper.map((Object)((Object)entity), OtherSettleVO.class);
        return vo;
    }

    @Override
    public SettleHistoryVo querySettleHistory(Long id) {
        OtherContractEntity contractEntity = (OtherContractEntity)((Object)this.contractService.selectById(id));
        SettleHistoryVo vo = new SettleHistoryVo();
        vo.setContractId(id);
        vo.setContractTaxMny(contractEntity.getContractTaxMny());
        vo.setSumSettleTaxMny(contractEntity.getSumSettleTaxMny());
        vo.setIsFinish(contractEntity.getIsFinish());
        BigDecimal safeDiv = MathUtil.safeDiv((BigDecimal)contractEntity.getSumSettleTaxMny(), (BigDecimal)contractEntity.getContractTaxMny());
        vo.setSumSettleRate(MathUtil.safeMultiply((BigDecimal)safeDiv, (BigDecimal)new BigDecimal(100)));
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(OtherSettleEntity::getContractId, (Object)id);
        lambdaQuery.in(OtherSettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = super.list((Wrapper)lambdaQuery);
        vo.setSettleRecord(BeanMapper.mapList((Iterable)list, OtherSettleVO.class));
        return vo;
    }
}

