package com.ejianc.business.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.vo.ParamsCheckDsVO;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherSettleDetailEntity;
import com.ejianc.business.other.bean.OtherSettleOtherEntity;
import com.ejianc.business.other.history.SettleHistoryVo;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.vo.OtherSettleDetailVO;
import com.ejianc.business.other.vo.OtherSettleOtherVO;
import com.ejianc.business.other.vo.OtherSettleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.business.other.mapper.OtherSettleMapper;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.service.IOtherSettleService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 结算
 *
 * @author generator
 */
@Service("otherSettleService")
public class OtherSettleServiceImpl extends BaseServiceImpl<OtherSettleMapper, OtherSettleEntity> implements IOtherSettleService {
    private static final String BILL_CODE = "OTHER_SETTLE_CODE";
    private static final String CHECK_PARAM_CODE = "P-NB2T3930";
    private static final String OTHER_SETTLE_BILL_CODE = "OTHER_SETTLE";
    private static final String OTHER_SETTLE_DETAIL_BILL_CODE = "OTHER_SETTLE_DETAIL";
    private static final String OTHER_SETTLE_OTHER_BILL_CODE = "OTHER_SETTLE_OTHER";

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ICostDetailApi iCostDetailApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public CommonResponse<OtherSettleVO> saveOrUpdate(OtherSettleVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherSettleEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            operateType = "edit";
            LambdaQueryWrapper<OtherSettleEntity> lambdaQuery = Wrappers.<OtherSettleEntity>lambdaQuery();
            lambdaQuery.eq(OtherSettleEntity::getTenantId, tenantId);
            lambdaQuery.ne(OtherSettleEntity::getId, saveorUpdateVO.getId());
            lambdaQuery.eq(OtherSettleEntity::getContractId, saveorUpdateVO.getContractId());
            lambdaQuery.ne(OtherSettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
            lambdaQuery.ne(OtherSettleEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
            int num = super.count(lambdaQuery);
            if (num > 0) {
                throw new BusinessException("该合同已存在未生效的结算单!");
            }
        } else {
            operateType = "add";
            LambdaQueryWrapper<OtherSettleEntity> lambdaQuery = Wrappers.<OtherSettleEntity>lambdaQuery();
            lambdaQuery.eq(OtherSettleEntity::getTenantId, tenantId);
            lambdaQuery.eq(OtherSettleEntity::getContractId, saveorUpdateVO.getContractId());
            lambdaQuery.ne(OtherSettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
            lambdaQuery.ne(OtherSettleEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
            int num = super.count(lambdaQuery);
            if (num > 0) {
                throw new BusinessException("该合同已存在未生效的结算单!");
            }
        }


        OtherContractEntity otherContractEntity = contractService.selectById(saveorUpdateVO.getContractId());
        if (otherContractEntity.getIsFinish() != null && otherContractEntity.getIsFinish() == 1) {
            throw new BusinessException("该合同已完工结算!");
        }
        if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                saveorUpdateVO.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            entity = BeanMapper.map(saveorUpdateVO, OtherSettleEntity.class);
            operateType = "edit";
        } else {
            //新增
            entity = BeanMapper.map(saveorUpdateVO, OtherSettleEntity.class);
            operateType = "add";
        }

        List<OtherSettleEntity> entities = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) {
            //修改 校验合同编号唯一
            LambdaQueryWrapper<OtherSettleEntity> lambda = Wrappers.<OtherSettleEntity>lambdaQuery();
            lambda.eq(OtherSettleEntity::getBillCode, saveorUpdateVO.getBillCode());
            lambda.eq(OtherSettleEntity::getTenantId, tenantId);
            lambda.ne(OtherSettleEntity::getId, saveorUpdateVO.getId());
            entities = super.list(lambda);
        } else {
            LambdaQueryWrapper<OtherSettleEntity> lambda = Wrappers.<OtherSettleEntity>lambdaQuery();
            lambda.eq(OtherSettleEntity::getBillCode, saveorUpdateVO.getBillCode());
            lambda.eq(OtherSettleEntity::getTenantId, tenantId);
            entities = super.list(lambda);
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setSumSettleAllMny(MathUtil.safeAdd(entity.getSettleTaxMny(), entity.getSumSettleTaxMny()));
        entity.setRelationFlag(getRelationFlag(saveorUpdateVO));
        super.saveOrUpdate(entity, false);

        return CommonResponse.success(queryDetail(entity.getId()));
    }

    @Override
    public OtherSettleVO queryDetail(Long id) {
        OtherSettleEntity entity = super.selectById(id);
        OtherSettleVO vo = BeanMapper.map(entity, OtherSettleVO.class);
        return vo;
    }

    @Override
    public SettleHistoryVo querySettleHistory(Long id) {
        OtherContractEntity contractEntity = contractService.selectById(id);

        SettleHistoryVo vo = new SettleHistoryVo();
        vo.setContractId(id);
        vo.setContractTaxMny(contractEntity.getContractTaxMny());
        vo.setSumSettleTaxMny(contractEntity.getSumSettleTaxMny());
        vo.setIsFinish(contractEntity.getIsFinish());
        BigDecimal safeDiv = MathUtil.safeDiv(contractEntity.getSumSettleTaxMny(), contractEntity.getContractTaxMny());
        vo.setSumSettleRate(MathUtil.safeMultiply(safeDiv, new BigDecimal(100)));
        LambdaQueryWrapper<OtherSettleEntity> lambdaQuery = Wrappers.<OtherSettleEntity>lambdaQuery();
        lambdaQuery.eq(OtherSettleEntity::getContractId, id);
        lambdaQuery.in(OtherSettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<OtherSettleEntity> list = super.list(lambdaQuery);
        vo.setSettleRecord(BeanMapper.mapList(list, OtherSettleVO.class));
        return vo;
    }

    @Override
    public ParamsCheckVO checkParams(Integer purchaseType, BigDecimal sumSettleMentTaxMny, BigDecimal contractTaxMny) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            BillParamVO billParamVO = billParamByCode.getData();
            BigDecimal roleValue = billParamVO.getRoleValue();
            BigDecimal comMny = contractTaxMny.multiply(roleValue.divide(BigDecimal.valueOf(100)
                    , 2, BigDecimal.ROUND_HALF_UP));

            if (2 == purchaseType) {
                // 集采合同直接赋值为不控制
                paramsCheckVO.setWarnType(paramsArray[0]);
                return paramsCheckVO;
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }

            if (sumSettleMentTaxMny.compareTo(comMny) > 0) {
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("合同超结");
                paramsCheckDsVO.setWarnName("结算金额大于合同金额");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("本次结算金额：").append(sumSettleMentTaxMny.toString())
                        .append("元，合同金额*").append(roleValue).append("%:")
                        .append(comMny).append("元。超出金额：")
                        .append(sumSettleMentTaxMny.subtract(comMny)).append("元");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOS.add(paramsCheckDsVO);
            }
            paramsCheckVO.setDataSource(checkDsVOS);
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVO;
    }

    @Override
    public CommonResponse<OtherSettleVO> pushToCost(OtherSettleVO otherSettleVO) {
        String relationFlag = getRelationFlag(otherSettleVO);
        OtherSettleEntity entity = BeanMapper.map(otherSettleVO, OtherSettleEntity.class);
        entity.setRelationFlag(relationFlag);
        super.saveOrUpdate(entity, false);
        Integer billState = entity.getBillState();
        if (relationFlag.equals("1")) {
            if (billState.equals(BillStateEnum.PASSED_STATE.getBillStateCode()) || billState.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
                processCost(entity);
            } else {
                delCost(entity.getId());
            }
        } else {
            delCost(entity.getId());
        }
        return CommonResponse.success(queryDetail(entity.getId()));
    }

    public String getRelationFlag(OtherSettleVO otherSettleVO) {
        List<OtherSettleDetailVO> detailVos = otherSettleVO.getDetailVos();
        List<OtherSettleOtherVO> otherVos = otherSettleVO.getOtherVos();
        String relationFlag = "1";
        for (OtherSettleDetailVO detailVO : detailVos) {
            if (detailVO.getSubjectId() == null || detailVO.getSubjectId() <= 0
                    || detailVO.getAccountingId() == null || detailVO.getAccountingId() <= 0) {
                relationFlag = "0";
            }
        }
        for (OtherSettleOtherVO otherVO : otherVos) {
            if (otherVO.getOtherSubjectId() == null || otherVO.getOtherSubjectId() <= 0
                    || otherVO.getOtherAccountingId() == null || otherVO.getOtherAccountingId() <= 0) {
                relationFlag = "0";
            }
        }
        return relationFlag;
    }

    // 只推送
    @Override
    public void processCost(OtherSettleEntity entity) {
        boolean canPush = true;
        List<CostDetailVO> list = new ArrayList<>();
        if (ListUtil.isNotEmpty(entity.getDetailVos())) {
            for (int i = 0; i < entity.getDetailVos().size(); i++) {
                OtherSettleDetailEntity sub = entity.getDetailVos().get(i);
                if (sub.getSubjectId() != null && sub.getSubjectId() > 0L && sub.getAccountingId() != null && sub.getAccountingId() > 0L) {
                    CostDetailVO c = new CostDetailVO();
                    c.setSubjectId(sub.getSubjectId());
                    c.setOrgSubjectId(sub.getOrgSubjectId());
                    c.setAccountingId(sub.getAccountingId());
                    c.setOrgAccountingId(sub.getOrgAccountingId());
                    c.setSourceId(entity.getId());
                    c.setSourceDetailId(sub.getId());
                    c.setProjectId(entity.getProjectId());
                    c.setHappenTaxMny(sub.getDetailTaxMny() == null ? new BigDecimal("0.00") : sub.getDetailTaxMny());
                    c.setHappenMny(sub.getDetailMny() == null ? new BigDecimal("0.00") : sub.getDetailMny());
                    c.setHappenDate(entity.getSignDate());
                    c.setMemo(sub.getDetailMemo());
                    c.setCreateUserName(sessionManager.getUserContext().getUserName());
                    c.setSourceType(OTHER_SETTLE_BILL_CODE);
                    c.setSourceTabType(OTHER_SETTLE_DETAIL_BILL_CODE);
                    list.add(c);
                } else {
                    canPush = false;
                    break;
                }
            }

        }
        if (ListUtil.isNotEmpty(entity.getOtherVos())) {
            for (int i = 0; i < entity.getOtherVos().size(); i++) {
                OtherSettleOtherEntity sub = entity.getOtherVos().get(i);
                if (sub.getOtherSubjectId() != null && sub.getOtherSubjectId() > 0L && sub.getOtherAccountingId() != null && sub.getOtherAccountingId() > 0L) {
                    CostDetailVO c = new CostDetailVO();
                    c.setSubjectId(sub.getOtherSubjectId());
                    c.setOrgSubjectId(sub.getOtherSubjectId());
                    c.setAccountingId(sub.getOtherAccountingId());
                    c.setOrgAccountingId(sub.getOtherOrgAccountingId());
                    c.setSourceDetailId(sub.getId());
                    c.setSourceId(entity.getId());
                    c.setProjectId(entity.getProjectId());
                    c.setHappenTaxMny(sub.getOtherTaxMny() == null ? new BigDecimal("0.00") : sub.getOtherTaxMny());
                    c.setHappenMny(sub.getOtherMny() == null ? new BigDecimal("0.00") : sub.getOtherMny());
                    c.setHappenDate(entity.getSignDate());
                    c.setMemo(sub.getOtherMemo());
                    c.setCreateUserName(sessionManager.getUserContext().getUserName());
                    c.setSourceType(OTHER_SETTLE_BILL_CODE);
                    c.setSourceTabType(OTHER_SETTLE_OTHER_BILL_CODE);
                    list.add(c);
                } else {
                    canPush = false;
                    break;
                }
            }

        }
        if (canPush) {
            CommonResponse<String> response = iCostDetailApi.saveSubject(list);
            logger.info("推送成本 其它支出合同结算 结果:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
            // entity.setRelationFlag("1");
        } else {
            CommonResponse<String> response = iCostDetailApi.deleteSubject(entity.getId());
            logger.info("删除成本 其它支出合同结算 结果:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
            // entity.setRelationFlag("0");
        }
    }

    // 只删除
    @Override
    public void delCost(Long id) {
        CommonResponse<String> response = iCostDetailApi.deleteSubject(id);
        logger.info("删除成本 其它支出合同结算 结果:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + id);
    }
}
