package com.ejianc.business.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherSettleService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.BillStateEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.List;

@Service("otherSettle")
public class OtherSettleBpmServiceImpl implements ICommonBusinessService {
    @Autowired
    private IOtherSettleService settleService;
    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private IBillTypeApi billTypeApi;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OtherSettleEntity settleEntity = settleService.selectById(billId);
        OtherContractEntity contractEntity = contractService.selectById(settleEntity.getContractId());
        BigDecimal sumSettleMny = MathUtil.safeAdd(contractEntity.getSumSettleMny(), settleEntity.getSettleMny());
        BigDecimal sumSettleTaxMny = MathUtil.safeAdd(contractEntity.getSumSettleTaxMny(), settleEntity.getSettleTaxMny());
        BigDecimal sumOffsetMny = MathUtil.safeAdd(contractEntity.getSumOffsetMny(), settleEntity.getThisOffsetMny());
        LambdaUpdateWrapper<OtherContractEntity> lambda = new LambdaUpdateWrapper<>();
        lambda.set(OtherContractEntity::getSumSettleMny, sumSettleMny);
        lambda.set(OtherContractEntity::getSumSettleTaxMny, sumSettleTaxMny);
        lambda.set(OtherContractEntity::getSumOffsetMny, sumOffsetMny);
        String settleType = settleEntity.getSettleType();
        if ("1".equals(settleType)) {
            lambda.set(OtherContractEntity::getIsFinish, 1);
        }
        lambda.eq(OtherContractEntity::getId, settleEntity.getContractId());
        contractService.update(lambda);
        if (settleEntity.getRelationFlag().equals("1")) {
            settleService.processCost(settleEntity);
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //合同是否被其他单据引用
        CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
        if (res.isSuccess()) {//单据未被下游单据引用
            settleService.delCost(billId);
            return callBackContract(billId);
        } else {
            return CommonResponse.error(res.getMsg());
        }
    }

    private CommonResponse<String> callBackContract(Long billId) {
        OtherSettleEntity settleEntity = settleService.selectById(billId);
        OtherContractEntity contractEntity = contractService.selectById(settleEntity.getContractId());

        LambdaQueryWrapper<OtherSettleEntity> lambdaList = new LambdaQueryWrapper<OtherSettleEntity>();
        lambdaList.eq(OtherSettleEntity::getContractId, settleEntity.getContractId());
        lambdaList.eq(OtherSettleEntity::getDr, 0);
        lambdaList.ne(OtherSettleEntity::getId, billId);
        List<OtherSettleEntity> list = settleService.list(lambdaList);
        for (OtherSettleEntity otherSettleEntity : list) {
            if (otherSettleEntity.getBillState() != BillStateEnum.PASSED_STATE.getBillStateCode()
                    && otherSettleEntity.getBillState() != BillStateEnum.COMMITED_STATE.getBillStateCode()) {
                return CommonResponse.error("该合同已存在未生效的结算单,请处理后再撤回！");
            }
            if (otherSettleEntity.getCreateTime().getTime() > settleEntity.getCreateTime().getTime()) {
                return CommonResponse.error("在此单据之后该合同已存在其它结算单,请依次撤回！");
            }
        }

        BigDecimal sumSettleMny = MathUtil.safeSub(contractEntity.getSumSettleMny(), settleEntity.getSettleMny());
        BigDecimal sumSettleTaxMny = MathUtil.safeSub(contractEntity.getSumSettleTaxMny(), settleEntity.getSettleTaxMny());
        BigDecimal sumOffsetMny = MathUtil.safeSub(contractEntity.getSumOffsetMny(), settleEntity.getThisOffsetMny());
        LambdaUpdateWrapper<OtherContractEntity> lambda = new LambdaUpdateWrapper<>();
        lambda.set(OtherContractEntity::getSumSettleMny, sumSettleMny);
        lambda.set(OtherContractEntity::getSumSettleTaxMny, sumSettleTaxMny);
        lambda.set(OtherContractEntity::getSumOffsetMny, sumOffsetMny);
        String settleType = settleEntity.getSettleType();
        if ("1".equals(settleType)) {
            lambda.set(OtherContractEntity::getIsFinish, 0);
        }
        lambda.eq(OtherContractEntity::getId, settleEntity.getContractId());
        contractService.update(lambda);
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
