package com.ejianc.business.other.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.finance.api.IBudgetControlApi;
import com.ejianc.business.other.bean.*;
import com.ejianc.business.other.history.ChangeHistoryVo;
import com.ejianc.business.other.service.*;
import com.ejianc.business.other.utils.ComputeUtil;
import com.ejianc.business.other.vo.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.other.mapper.OtherContractChangeMapper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 其他支出合同变更
 *
 * @author generator
 */
@Service("otherContractChangeService")
public class OtherContractChangeServiceImpl extends BaseServiceImpl<OtherContractChangeMapper, OtherContractChangeEntity> implements IOtherContractChangeService {
    private static final String BILL_CODE = "OTHER_CONTRACT_CHANGE";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PARAM_TOTAL_MNY = "P-6zD11147"; // 【预算间接费总金额】控 【实际间接费总金额】

    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private IOtherContractDetailChangeService detailChangeService;
    @Autowired
    private IOtherContractPayPlanChangeService payPlanChangeService;
    @Autowired
    private IOtherContractClauseChangeService clauseChangeService;

    @Autowired
    private IOtherContractChangeService changeService;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IBudgetControlApi budgetControlApi;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;

    @Override
    public CommonResponse<OtherContractChangeVO> saveOrUpdate(OtherContractChangeVO changeVo) {

        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherContractChangeEntity entity = null;
        String operateType = null;
        if (changeVo.getId() != null && changeVo.getId() > 0) { //修改
            if (StringUtils.isEmpty(changeVo.getBillCode())) {
                changeVo.setBillCode(null);
            }
            entity = BeanMapper.map(changeVo, OtherContractChangeEntity.class);
            operateType = "edit";
        } else {
            if (null == changeVo.getChangeVersion() || changeVo.getChangeVersion() == 0) {
                changeVo.setChangeVersion(1);//第一次变更
            } else {
                changeVo.setChangeVersion(changeVo.getChangeVersion() + 1);//版本号+1
            }
            if (2 == changeVo.getChangeStatus()) {
                throw new BusinessException("合同存在变更中单据，不允许保存!");
            }
            //新增
            if (StringUtils.isEmpty(changeVo.getBillCode())) {
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
                if(billCode.isSuccess()) {
                    changeVo.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }

            entity = BeanMapper.map(changeVo, OtherContractChangeEntity.class);

            operateType = "add";
        }
        if (changeVo.getId() != null && changeVo.getId() > 0) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<OtherContractChangeEntity> lambda = Wrappers.<OtherContractChangeEntity>lambdaQuery();
            lambda.eq(OtherContractChangeEntity::getBillCode, changeVo.getBillCode());
            lambda.eq(OtherContractChangeEntity::getTenantId, tenantId);
            lambda.ne(OtherContractChangeEntity::getId, changeVo.getId());
            lambda.ne(OtherContractChangeEntity::getContractId, changeVo.getContractId());
            List<OtherContractChangeEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<OtherContractChangeEntity> lambda = Wrappers.<OtherContractChangeEntity>lambdaQuery();
            lambda.eq(OtherContractChangeEntity::getTenantId, tenantId);
            lambda.eq(OtherContractChangeEntity::getBillCode, changeVo.getBillCode());
            lambda.ne(OtherContractChangeEntity::getContractId, changeVo.getContractId());
            List<OtherContractChangeEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
        queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, changeVo.getBillCode()));
        queryParam.getParams().put("id", new Parameter(QueryParam.NE, changeVo.getContractId()));
        List<OtherContractEntity> entitiesc = contractService.queryList(queryParam, false);
        if (entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }

        super.saveOrUpdate(entity);
        saveChildren(changeVo, entity.getId(), operateType);

        //回写主表
        LambdaUpdateWrapper<OtherContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(OtherContractEntity::getChangingTaxMny, changeVo.getContractTaxMny());
        updateWrapper.set(OtherContractEntity::getChangingMny, changeVo.getContractMny());
        updateWrapper.set(OtherContractEntity::getChangeId, entity.getId());
        updateWrapper.set(OtherContractEntity::getChangeStatus, 2);
        updateWrapper.set(OtherContractEntity::getChangeCode, entity.getBillCode());
        updateWrapper.eq(OtherContractEntity::getId, entity.getContractId());
        contractService.update(updateWrapper);

        return CommonResponse.success(queryDetail(entity.getId()));
    }

    @Override
    public void deleteChange(List<OtherContractChangeVO> vos) {
        for (OtherContractChangeVO vo : vos) {
            OtherContractChangeEntity changeEntity = super.selectById(vo.getId());
            LambdaUpdateWrapper<OtherContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(OtherContractEntity::getChangingTaxMny, BigDecimal.ZERO);
            updateWrapper.set(OtherContractEntity::getChangingMny, BigDecimal.ZERO);
            if (changeEntity.getChangeVersion() == 1) {
                updateWrapper.set(OtherContractEntity::getChangeStatus, 1);
            } else {
                updateWrapper.set(OtherContractEntity::getChangeStatus, 3);
            }
            updateWrapper.eq(OtherContractEntity::getId, changeEntity.getContractId());
            contractService.update(updateWrapper);
            super.removeById(vo, false);
        }
    }

    @Override
    public ChangeHistoryVo queryChangeHistory(Long id) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        List<OtherContractChangeEntity> changeEntities = changeService.list(new QueryWrapper<OtherContractChangeEntity>()
                .eq("contract_id", id)
                .in("bill_state", billStatus).orderByDesc("used_time"));
        OtherContractEntity contractEntity = contractService.selectById(id);

        ChangeHistoryVo vo = new ChangeHistoryVo();
        vo.setIsFinish(contractEntity.getIsFinish());
        vo.setChangeStatus(contractEntity.getChangeStatus());
        vo.setSupplementFlag(0);

        vo.setContractId(id);
        vo.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());
        vo.setBaseTaxMoney(contractEntity.getBaseTaxMoney() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMoney());
        BigDecimal changeMny = vo.getContractTaxMny().subtract(vo.getBaseTaxMoney());
        vo.setSumChangeMny(changeMny);
        BigDecimal sumChangeRate = BigDecimal.ZERO;
        if (vo.getBaseTaxMoney().compareTo(BigDecimal.ZERO) != 0) {
            sumChangeRate = changeMny.divide(vo.getBaseTaxMoney(), 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
        }
        vo.setSumScale(sumChangeRate);
        if (null != changeEntities && changeEntities.size() > 0) {
            List<OtherContractChangeVO> changeVos = BeanMapper.mapList(changeEntities, OtherContractChangeVO.class);
            for (OtherContractChangeVO cvo : changeVos) {
                String changeTime = new SimpleDateFormat("yyyyMMdd").format(cvo.getChangeTime());
                String historyBillCode = cvo.getBeforeContractName() + "-" + changeTime + "-" + cvo.getChangeVersion();
                cvo.setHistoryBillCode(historyBillCode);
                BigDecimal subtract = ComputeUtil.safeSub(cvo.getContractTaxMny(), cvo.getBeforeChangeTaxMny());
                BigDecimal changeRate = BigDecimal.ZERO;
                if (cvo.getBeforeChangeTaxMny() != null && cvo.getBeforeChangeTaxMny().compareTo(BigDecimal.ZERO) != 0) {
                    changeRate = ComputeUtil.safeDiv(subtract, cvo.getBeforeChangeTaxMny()).setScale(8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
                }
                cvo.setScale(changeRate);
            }
            vo.setChangeRecord(changeVos);
        }
        return vo;
    }


    private void saveChildren(OtherContractChangeVO changeVo, Long changeId, String operateType) {
        List<OtherContractDetailChangeVO> detailVos = changeVo.getDetailVos();
        List<OtherContractPayPlanChangeVO> payPlanVos = changeVo.getPayPlanVos();
        List<OtherContractClauseChangeVO> clauseVos = changeVo.getClauseVos();
        List<OtherContractDetailChangeEntity> detailSave = new ArrayList<>();
        List<OtherContractPayPlanChangeEntity> payPlanSave = new ArrayList<>();
        List<OtherContractClauseChangeEntity> clauseSave = new ArrayList<>();
        List<Long> detailDel = new ArrayList<>();
        List<Long> payPlanDel = new ArrayList<>();
        List<Long> clauseDel = new ArrayList<>();
        if (operateType.equals("add")) {
            if (detailVos != null && detailVos.size() > 0) {
                for (OtherContractDetailChangeVO vo : detailVos) {
                    vo.setId(null);
                    vo.setChangeId(changeId);
                }
                detailSave = BeanMapper.mapList(detailVos, OtherContractDetailChangeEntity.class);
            }
            if (payPlanVos != null && payPlanVos.size() > 0) {
                for (OtherContractPayPlanChangeVO vo : payPlanVos) {
                    if (!"del".equals(vo.getRowState())) {
                        vo.setId(null);
                        vo.setChangeId(changeId);
                        payPlanSave.add(BeanMapper.map(vo, OtherContractPayPlanChangeEntity.class));
                    }
                }
            }
            if (clauseVos != null && clauseVos.size() > 0) {
                for (OtherContractClauseChangeVO vo : clauseVos) {
                    if (!"del".equals(vo.getRowState())) {
                        vo.setId(null);
                        vo.setChangeId(changeId);
                        clauseSave.add(BeanMapper.map(vo, OtherContractClauseChangeEntity.class));
                    }
                }
            }
        } else {
            if (detailVos != null && detailVos.size() > 0) {
                for (OtherContractDetailChangeVO vo : detailVos) {
                    if ("del".equals(vo.getRowState())) {
                        detailDel.add(vo.getId());
                    } else if ("add".equals(vo.getRowState())) {
                        vo.setId(null);
                        vo.setChangeId(changeId);
                        OtherContractDetailChangeEntity map = BeanMapper.map(vo, OtherContractDetailChangeEntity.class);
                        detailSave.add(map);
                    } else if ("edit".equals(vo.getRowState())) {
                        OtherContractDetailChangeEntity map = BeanMapper.map(vo, OtherContractDetailChangeEntity.class);
                        detailSave.add(map);
                    }
                }
            }
            if (payPlanVos != null && payPlanVos.size() > 0) {
                for (OtherContractPayPlanChangeVO vo : payPlanVos) {
                    if ("del".equals(vo.getRowState())) {
                        payPlanDel.add(vo.getId());
                    } else if ("add".equals(vo.getRowState())) {
                        vo.setId(null);
                        vo.setChangeId(changeId);
                        OtherContractPayPlanChangeEntity map = BeanMapper.map(vo, OtherContractPayPlanChangeEntity.class);
                        payPlanSave.add(map);
                    } else if ("edit".equals(vo.getRowState())) {
                        OtherContractPayPlanChangeEntity map = BeanMapper.map(vo, OtherContractPayPlanChangeEntity.class);
                        payPlanSave.add(map);
                    }
                }
            }
            if (clauseVos != null && clauseVos.size() > 0) {
                for (OtherContractClauseChangeVO vo : clauseVos) {
                    if ("del".equals(vo.getRowState())) {
                        clauseDel.add(vo.getId());
                    } else if ("add".equals(vo.getRowState())) {
                        vo.setId(null);
                        vo.setChangeId(changeId);
                        OtherContractClauseChangeEntity map = BeanMapper.map(vo, OtherContractClauseChangeEntity.class);
                        clauseSave.add(map);
                    } else if ("edit".equals(vo.getRowState())) {
                        OtherContractClauseChangeEntity map = BeanMapper.map(vo, OtherContractClauseChangeEntity.class);
                        clauseSave.add(map);
                    }
                }
            }
        }
        if (detailSave.size() > 0) {
            detailChangeService.saveOrUpdateBatch(detailSave);
        }
        if (payPlanSave.size() > 0) {
            payPlanChangeService.saveOrUpdateBatch(payPlanSave);
        }
        if (clauseSave.size() > 0) {
            clauseChangeService.saveOrUpdateBatch(clauseSave);
        }

        if (detailDel.size() > 0) {
            detailChangeService.removeByIds(detailDel);
        }
        if (payPlanDel.size() > 0) {
            payPlanChangeService.removeByIds(payPlanDel);
        }
        if (clauseDel.size() > 0) {
            clauseChangeService.removeByIds(clauseDel);
        }
    }

    @Override
    public OtherContractChangeVO queryDetail(Long id) {
        OtherContractChangeEntity entity = super.selectById(id);
        OtherContractChangeVO changeVo = BeanMapper.map(entity, OtherContractChangeVO.class);
        return changeVo;
    }

    @Override
    public OtherContractVO queryDetailChange(Long id) {
        OtherContractEntity entity = contractService.selectById(id);
        if (entity != null) {
            OtherContractVO contractVo = BeanMapper.map(entity, OtherContractVO.class);
            contractVo.setBeforeChangeTaxMny(entity.getContractTaxMny());
            contractVo.setBillState(null);
            contractVo.setCreateUserCode(null);
            contractVo.setCreateTime(null);
            contractVo.setUpdateUserCode(null);
            contractVo.setUpdateTime(null);
            contractVo.setChangeReason(null);
            List<OtherContractDetailVO> detailVos = contractVo.getDetailVos();
            if (detailVos != null && detailVos.size() > 0) {
                Iterator<OtherContractDetailVO> iterator = detailVos.iterator();
                while (iterator.hasNext()) {
                    OtherContractDetailVO next = iterator.next();
                    if (next.getChangeType() != null && next.getChangeType() == 5) {
                        iterator.remove();
                    }
                }
            }
            contractVo.setDetailVos(detailVos);
            return contractVo;
        }
        return null;
    }

    public BigDecimal totalContractMny(OtherContractChangeVO vo){
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        QueryWrapper<OtherContractEntity> contractQuery = new QueryWrapper<>();
        contractQuery.eq("project_Id", vo.getProjectId());
        if (vo.getContractId()!=null){
            contractQuery.ne("id",vo.getContractId());
        }
        if (vo.getContractTaxMny()!=null){
            contractTaxMny =contractTaxMny.add(vo.getContractTaxMny());
        }
        contractQuery.ne("change_status",2);
        contractQuery.select("sum(contract_tax_mny) as contractTaxMny");
        OtherContractEntity contractEntity = contractService.getOne(contractQuery);
        if(contractEntity!=null &&null != contractEntity.getContractTaxMny()&&!"0".equals(contractEntity.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(contractEntity.getContractTaxMny());
        }
        //统计变更中的金额
        QueryWrapper<OtherContractChangeEntity> changeQuery = new QueryWrapper<>();
        changeQuery.eq("project_Id", vo.getProjectId());
        changeQuery.in("bill_state", Arrays.asList(
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
        if (vo.getId()!=null){
            changeQuery.ne("id",vo.getId());
        }
        changeQuery.select("sum(contract_tax_mny) as contractTaxMny");
        OtherContractChangeEntity changeEntity = changeService.getOne(changeQuery);
        if(changeEntity!=null &&null != changeEntity.getContractTaxMny()&&!"0".equals(changeEntity.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(changeEntity.getContractTaxMny());
        }
        return  contractTaxMny;
    }
    /**
     * 参数控制
     *
     * @param vo 【预算间接费总金额】控 【实际间接费总金额】
     *
     * @return {@link ParamsCheckVO}
     */
    @Override
    public ParamsCheckVO checkParams(OtherContractChangeVO vo) {
        String[] paramsArray = {"none", "warn", "alert"};
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        //获取 预算间接费总金额
        BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
        requestVo.setProjectId(vo.getProjectId());
        requestVo.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType());
        CommonResponse<BudgetProjectProQuantityAndMnyVO> res = budgetProjectProApi.fetchQuantityAndMny(requestVo);
        logger.info("预算间接费总金额 返回内容:{}", JSONObject.toJSONString(res));
        if (!res.isSuccess()){
            throw new BusinessException("网络错误"+res.getMsg());
        }
        // 没有预算不控制，预算不包含不控制
        if (null != res.getData()) {
            BudgetProjectProQuantityAndMnyVO data = res.getData();
            //      预算间接费总金额
            BigDecimal budgetTaxMny =  data.getIndirectionTaxMny()==null ? BigDecimal.ZERO : data.getIndirectionTaxMny();
            CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, InvocationInfoProxy.getOrgId());

            if (!response.isSuccess()) {
                throw new BusinessException(" 【预算间接费总金额】控 【实际间接费总金额】，获取控制参数失败，失败原因：" + response.getMsg());
            }
            List<BillParamVO> billParamVOS = response.getData();
            //其他合同总金额
            BigDecimal  totalContractMny= totalContractMny(vo);
            CommonResponse<BigDecimal> respPay = budgetControlApi.budgetControlTotal(vo.getProjectId());
            logger.info("统计费用报销、备用金报销、零星付款申请 金额:{}", JSONObject.toJSONString(respPay));
            if (!response.isSuccess()){
                throw new BusinessException("网络错误"+respPay.getMsg());
            }else {
                if (respPay.getData()!=null){
                    totalContractMny = totalContractMny.add(respPay.getData());
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billParamVOS)) {
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                        BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);
                        logger.info("其他费用:{} 间接费用:{}",JSONObject.toJSONString(totalContractMny),JSONObject.toJSONString(budgetTaxMnyResult));
                        // 【预算间接费总金额】控 【实际间接费总金额】
                        if (totalContractMny.compareTo(budgetTaxMnyResult) > 0) {
                            // 超出金额 = 实际间接费总金额 - 预算间接费总金额 * X%
                            BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            //设备合同总金额：{}元，预算机械费总金额
                            paramsCheckDsVO.setWarnItem("实际间接费总金额超预算间接费总金额");
                            paramsCheckDsVO.setWarnName("实际间接费总金额大于预算间接费总金额 * " + roleValue + "%");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("实际间接费总金额：")
                                    .append(totalContractMny.setScale(2, RoundingMode.HALF_UP))
                                    .append("元， 预算间接费总金额 * ")
                                    .append(roleValue).append("%：")
                                    .append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，超出金额：")
                                    .append(over.setScale(2, RoundingMode.HALF_UP))
                                    .append("元。");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
            }
        }
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }
    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }
}
