package com.ejianc.business.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.other.bean.*;
import com.ejianc.business.other.service.*;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.other.mapper.OtherContractDetailChangeMapper;

import java.util.Date;
import java.util.List;

/**
 * 其他支出合同清单变更
 * 
 * @author generator
 * 
 */
@Service("otherContractDetailChangeService")
public class OtherContractDetailChangeServiceImpl extends BaseServiceImpl<OtherContractDetailChangeMapper, OtherContractDetailChangeEntity> implements IOtherContractDetailChangeService{

    @Autowired
    private IOtherContractChangeService changeService;
    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private IOtherContractDetailService contractDetailService;
    @Autowired
    private IOtherContractPayPlanService contractPayPlanService;
    @Autowired
    private IOtherContractClauseService contractClauseService;
    @Autowired
    private IOtherContractHistoryService historyService;
    @Autowired
    private IOtherContractDetailHistoryService historyDetailService;
    @Autowired
    private IOtherContractPayPlanHistoryService historyPayPlanService;
    @Autowired
    private IOtherContractClauseHistoryService historyClauseService;

    @Override
    public void afterApprovalProcessor(Long billId) {
        //变更表
        OtherContractChangeEntity entity = changeService.selectById(billId);
        //合同主表
        OtherContractEntity contractEntity = contractService.selectById(entity.getContractId());

        saveHistory(entity, contractEntity);

        //回写合同主表
        contractEntity.setBeforeChangeTaxMny(contractEntity.getContractTaxMny());//变更后金额变为变更前金额
        contractEntity.setBeforeChangeMny(contractEntity.getContractMny());//变更后金额变为变更前金额
        contractEntity.setContractTaxMny(contractEntity.getChangingTaxMny());//变更中金额变为变更后金额
        contractEntity.setContractMny(contractEntity.getChangingMny());//变更中金额变为变更后金额
        contractEntity.setChangingTaxMny(null);//变更中金额清空
        contractEntity.setChangingMny(null);//变更中金额清空
        contractEntity.setChangeStatus(3);//状态改为已变更
        contractEntity.setChangeCode(contractEntity.getChangeCode());
        contractEntity.setChangeId(contractEntity.getChangeId());
        contractEntity.setBillState(contractEntity.getBillState());
        contractEntity.setSumInvoicingTaxMny(contractEntity.getSumInvoicingTaxMny());
        contractEntity.setSumInvoicingMny(contractEntity.getSumInvoicingMny());

        contractEntity.setProjectId(entity.getProjectId());
        contractEntity.setProjectName(entity.getProjectName());
        contractEntity.setContractName(entity.getContractName());
        contractEntity.setBillCode(entity.getBillCode());
        contractEntity.setOrgId(entity.getOrgId());
        contractEntity.setOrgName(entity.getOrgName());
        contractEntity.setContractStatus(entity.getContractStatus());
        contractEntity.setCustomerId(entity.getCustomerId());
        contractEntity.setCustomerName(entity.getCustomerName());
        contractEntity.setSupplierId(entity.getSupplierId());
        contractEntity.setSupplierName(entity.getSupplierName());
        contractEntity.setContractType(entity.getContractType());
        contractEntity.setTaxRate(entity.getTaxRate());
        contractEntity.setSignDate(entity.getSignDate());
        contractEntity.setEmployeeId(entity.getEmployeeId());
        contractEntity.setEmployeeName(entity.getEmployeeName());
        contractEntity.setMemo(entity.getMemo());
        contractEntity.setTaxMny(entity.getTaxMny());

        contractEntity.setChangeReason(entity.getChangeReason());

        contractEntity.setChangeVersion(entity.getChangeVersion());
        contractService.saveOrUpdate(contractEntity);

        savechangeBack(entity,contractEntity.getId());

        //entity.setBillState();
        entity.setUsedTime(new Date());
        entity.setBeforeContractName(contractEntity.getContractName());
        changeService.saveOrUpdate(entity, false);
        //return CommonResponse.success();
    }


    private void saveHistory(OtherContractChangeEntity entity, OtherContractEntity contractEntity) {
        //同步原合同到记录表
        OtherContractHistoryEntity historyEntity = BeanMapper.map(contractEntity, OtherContractHistoryEntity.class);
        historyEntity.setContractId(entity.getContractId());//原合同主键
        historyEntity.setId(null);
        historyService.saveOrUpdate(historyEntity, false);

        //同步原清单到记录表
        List<OtherContractDetailEntity> checkList = contractEntity.getDetailVos();
        if (null != checkList && checkList.size() > 0) {
            List<OtherContractDetailHistoryEntity> historyDetails = BeanMapper.mapList(checkList, OtherContractDetailHistoryEntity.class);
            for (OtherContractDetailHistoryEntity hde : historyDetails) {
                hde.setHistoryId(historyEntity.getId());//记录表主键
                hde.setContractId(entity.getContractId());//原合同主键
                hde.setId(null);
            }
            historyDetailService.saveOrUpdateBatch(historyDetails, historyDetails.size(), false);
        }

        List<OtherContractPayPlanEntity> payPlanList = contractEntity.getPayPlanVos();
        if (null != payPlanList && payPlanList.size() > 0) {
            List<OtherContractPayPlanHistoryEntity> historypayPlan = BeanMapper.mapList(payPlanList, OtherContractPayPlanHistoryEntity.class);
            for (OtherContractPayPlanHistoryEntity hce : historypayPlan) {
                hce.setHistoryId(historyEntity.getId());//记录表主键
                hce.setContractId(entity.getContractId());//原合同主键
                hce.setId(null);
            }
            historyPayPlanService.saveOrUpdateBatch(historypayPlan, historypayPlan.size(), false);
        }

        //同步原条款到记录表
        List<OtherContractClauseEntity> clauseList = contractEntity.getClauseVos();
        if (null != clauseList && clauseList.size() > 0) {
            List<OtherContractClauseHistoryEntity> historyClauses = BeanMapper.mapList(clauseList, OtherContractClauseHistoryEntity.class);
            for (OtherContractClauseHistoryEntity hce : historyClauses) {
                hce.setHistoryId(historyEntity.getId());//记录表主键
                hce.setContractId(entity.getContractId());//原合同主键
                hce.setId(null);
            }
            historyClauseService.saveOrUpdateBatch(historyClauses, historyClauses.size(), false);
        }
    }

    private void savechangeBack(OtherContractChangeEntity entity,Long contractId) {
        //回写原合同清单表
        contractDetailService.deleteByContractId(entity.getContractId());
        List<OtherContractDetailChangeEntity> changeDetailList = entity.getDetailVos();
        if (null != changeDetailList && changeDetailList.size() > 0) {
            List<OtherContractDetailEntity> detailList = BeanMapper.mapList(changeDetailList, OtherContractDetailEntity.class);
            for (OtherContractDetailEntity cde : detailList) {
                cde.setChangeBid(cde.getId());
                cde.setContractId(contractId);
                cde.setId(null);
                //变更类型如果是中止，不能改类型
                if (null == cde.getChangeType() || cde.getChangeType() != 5) {
                    cde.setChangeType(0);
                }
            }
            contractDetailService.saveOrUpdateBatch(detailList, detailList.size(), false);
        }

        List<OtherContractPayPlanChangeEntity> changePayPlanList = entity.getPayPlanVos();
        contractPayPlanService.remove(new QueryWrapper<OtherContractPayPlanEntity>().eq("contract_id", entity.getContractId()), false);
        if (null != changePayPlanList && changePayPlanList.size() > 0) {
            List<OtherContractPayPlanEntity> contractClauses = BeanMapper.mapList(changePayPlanList, OtherContractPayPlanEntity.class);
            for (OtherContractPayPlanEntity cce : contractClauses) {
                cce.setContractId(contractId);
                cce.setId(null);
            }
            contractPayPlanService.saveOrUpdateBatch(contractClauses, contractClauses.size(), false);
        }
        //回写原合同条款表
        List<OtherContractClauseChangeEntity> changeClauseList = entity.getClauseVos();
        contractClauseService.remove(new QueryWrapper<OtherContractClauseEntity>().eq("contract_id", entity.getContractId()), false);
        if (null != changeClauseList && changeClauseList.size() > 0) {
            List<OtherContractClauseEntity> contractClauses = BeanMapper.mapList(changeClauseList, OtherContractClauseEntity.class);
            for (OtherContractClauseEntity cce : contractClauses) {
                cce.setContractId(contractId);
                cce.setId(null);
            }
            contractClauseService.saveOrUpdateBatch(contractClauses, contractClauses.size(), false);
        }
    }

}
