package com.ejianc.business.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.other.bean.OtherContractClauseHistoryEntity;
import com.ejianc.business.other.bean.OtherContractDetailHistoryEntity;
import com.ejianc.business.other.bean.OtherContractPayPlanHistoryEntity;
import com.ejianc.business.other.service.IOtherContractClauseHistoryService;
import com.ejianc.business.other.service.IOtherContractDetailHistoryService;
import com.ejianc.business.other.service.IOtherContractPayPlanHistoryService;
import com.ejianc.business.other.vo.OtherContractClauseHistoryVO;
import com.ejianc.business.other.vo.OtherContractDetailHistoryVO;
import com.ejianc.business.other.vo.OtherContractHistoryVO;
import com.ejianc.business.other.vo.OtherContractPayPlanHistoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.other.mapper.OtherContractHistoryMapper;
import com.ejianc.business.other.bean.OtherContractHistoryEntity;
import com.ejianc.business.other.service.IOtherContractHistoryService;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/**
 * 其他支出合同记录
 * 
 * @author generator
 * 
 */
@Service("otherContractHistoryService")
public class OtherContractHistoryServiceImpl extends BaseServiceImpl<OtherContractHistoryMapper, OtherContractHistoryEntity> implements IOtherContractHistoryService{

    @Autowired
    private IOtherContractDetailHistoryService detailHistoryService;
    @Autowired
    private IOtherContractPayPlanHistoryService payPlanHistoryService;
    @Autowired
    private IOtherContractClauseHistoryService clauseHistoryService;


    @Override
    public OtherContractHistoryVO queryDetailByChangeId(Long id) {

        OtherContractHistoryEntity historyEntity = super.getOne(new QueryWrapper<OtherContractHistoryEntity>().eq("change_id", id));
        if(historyEntity !=null){
            OtherContractHistoryVO historyVo = BeanMapper.map(historyEntity, OtherContractHistoryVO.class);

            LambdaQueryWrapper<OtherContractDetailHistoryEntity> lambddetail = Wrappers.<OtherContractDetailHistoryEntity>lambdaQuery();
            lambddetail.eq(OtherContractDetailHistoryEntity::getHistoryId,historyEntity.getId());
            List<OtherContractDetailHistoryEntity> details = detailHistoryService.list(lambddetail);
            List<OtherContractDetailHistoryVO> detailVos = BeanMapper.mapList(details, OtherContractDetailHistoryVO.class);
            if (detailVos != null && detailVos.size() > 0) {
                Iterator<OtherContractDetailHistoryVO> iterator = detailVos.iterator();
                while (iterator.hasNext()) {
                    OtherContractDetailHistoryVO next = iterator.next();
                    if (next.getChangeType() != null && next.getChangeType() == 5) {
                        iterator.remove();
                    }
                }
            }
            historyVo.setDetailVos(detailVos);

            LambdaQueryWrapper<OtherContractPayPlanHistoryEntity> lambdpayplan = Wrappers.<OtherContractPayPlanHistoryEntity>lambdaQuery();
            lambdpayplan.eq(OtherContractPayPlanHistoryEntity::getHistoryId,historyEntity.getId());
            List<OtherContractPayPlanHistoryEntity> payplans = payPlanHistoryService.list(lambdpayplan);
            List<OtherContractPayPlanHistoryVO> payplanVos = BeanMapper.mapList(payplans, OtherContractPayPlanHistoryVO.class);
            historyVo.setPayPlanVos(payplanVos);

            LambdaQueryWrapper<OtherContractClauseHistoryEntity> lambdclause = Wrappers.<OtherContractClauseHistoryEntity>lambdaQuery();
            lambdclause.eq(OtherContractClauseHistoryEntity::getHistoryId,historyEntity.getId());
            List<OtherContractClauseHistoryEntity> clauses = clauseHistoryService.list(lambdclause);
            List<OtherContractClauseHistoryVO> clauseVos = BeanMapper.mapList(clauses, OtherContractClauseHistoryVO.class);
            historyVo.setClauseVos(clauseVos);

            return historyVo;
        }
        return null;
    }
}
