/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.finance.api.IBudgetControlApi;
import com.ejianc.business.other.bean.OtherContractChangeEntity;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.mapper.OtherContractMapper;
import com.ejianc.business.other.service.IOtherContractChangeService;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherSettleService;
import com.ejianc.business.other.vo.OtherContractDetailVO;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.business.other.vo.OtherProjectReportVo;
import com.ejianc.business.other.vo.ParamsCheckDsVO;
import com.ejianc.business.other.vo.ParamsCheckVO;
import com.ejianc.business.other.vo.SqlParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherContractService")
public class OtherContractServiceImpl
extends BaseServiceImpl<OtherContractMapper, OtherContractEntity>
implements IOtherContractService {
    private static final String BILL_CODE = "OTHER_CONTRACT";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOtherSettleService settleService;
    private static final String PARAM_TOTAL_MNY = "P-6zD11147";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IBudgetControlApi budgetControlApi;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private IOtherContractChangeService changeService;

    @Override
    public CommonResponse<OtherContractVO> saveOrUpdate(OtherContractVO contractVo) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherContractEntity entity = null;
        if (StringUtils.isBlank((CharSequence)contractVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                contractVo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (contractVo.getId() != null && contractVo.getId() > 0L) {
            entity = (OtherContractEntity)((Object)BeanMapper.map((Object)contractVo, OtherContractEntity.class));
        } else {
            contractVo.setIsFinish(Integer.valueOf(0));
            entity = (OtherContractEntity)((Object)BeanMapper.map((Object)contractVo, OtherContractEntity.class));
            entity.setIsSupplement("0");
        }
        if (contractVo.getId() != null && contractVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(OtherContractEntity::getBillCode, (Object)contractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)contractVo.getId());
            List entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(OtherContractEntity::getBillCode, (Object)contractVo.getBillCode());
            List entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        entity.setSupplementFlag(0);
        entity.setBaseTaxMoney(entity.getContractTaxMny());
        entity.setBaseMoney(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)this.queryDetail(entity.getId()));
    }

    @Override
    public OtherContractVO queryDetail(Long id) {
        OtherContractEntity entity = (OtherContractEntity)((Object)super.selectById((Serializable)id));
        OtherContractVO vo = (OtherContractVO)BeanMapper.map((Object)((Object)entity), OtherContractVO.class);
        List detailVos = vo.getDetailVos();
        ArrayList<OtherContractDetailVO> detail = new ArrayList<OtherContractDetailVO>();
        if (detailVos != null && detailVos.size() > 0) {
            for (OtherContractDetailVO dvo : detailVos) {
                if (dvo.getChangeType() != null && dvo.getChangeType() == 5) continue;
                detail.add(dvo);
            }
        }
        vo.setDetailVos(detail);
        return vo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = OtherContractServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"round(sum(base_tax_money),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public List<OtherProjectReportVo> getMonthOtherMny(Long projectId, Integer lastDay) {
        return ((OtherContractMapper)this.baseMapper).getMonthOtherMny(projectId, lastDay);
    }

    @Override
    public OtherProjectReportVo getOtherContract(Long projectId) {
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OtherContractEntity::getProjectId, (Object)projectId);
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.eq(OtherContractEntity::getSupplementFlag, (Object)0);
        wrapper.in(OtherContractEntity::getBillState, billStatus);
        List otherContractEntityList = super.list((Wrapper)wrapper);
        BigDecimal mny = otherContractEntityList.stream().filter(entity -> entity.getContractTaxMny() != null).map(OtherContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(OtherSettleEntity::getProjectId, (Object)projectId);
        wrapper2.eq(BaseEntity::getDr, (Object)0);
        wrapper2.in(OtherSettleEntity::getBillState, billStatus);
        List settlementEntityList = this.settleService.list((Wrapper)wrapper2);
        BigDecimal settleMny = settlementEntityList.stream().filter(entity -> entity.getSettleTaxMny() != null).map(OtherSettleEntity::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        OtherProjectReportVo vo = new OtherProjectReportVo();
        vo.setMny(mny);
        vo.setNum(Integer.valueOf(otherContractEntityList.size()));
        vo.setSettleMny(settleMny);
        return vo;
    }

    @Override
    public List<Map<String, Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList) {
        return ((OtherContractMapper)this.baseMapper).queryPrePayWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryTaxWarnContract(List<SqlParam> sqlParamList) {
        return ((OtherContractMapper)this.baseMapper).queryTaxWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryPayWarnContract(List<SqlParam> sqlParamList) {
        return ((OtherContractMapper)this.baseMapper).queryPayWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList) {
        return ((OtherContractMapper)this.baseMapper).querySettleWarnContract(sqlParamList);
    }

    @Override
    public ParamsCheckVO checkParams(OtherContractVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
        requestVo.setProjectId(vo.getProjectId());
        requestVo.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType());
        CommonResponse res = this.budgetProjectProApi.fetchQuantityAndMny(requestVo);
        this.logger.info("\u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d \u8fd4\u56de\u5185\u5bb9:{}", (Object)JSONObject.toJSONString((Object)res));
        if (!res.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u9519\u8bef" + res.getMsg());
        }
        if (null != res.getData()) {
            BudgetProjectProQuantityAndMnyVO data = (BudgetProjectProQuantityAndMnyVO)res.getData();
            BigDecimal budgetTaxMny = data.getIndirectionTaxMny() == null ? BigDecimal.ZERO : data.getIndirectionTaxMny();
            CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, InvocationInfoProxy.getOrgId());
            if (!response.isSuccess()) {
                throw new BusinessException(" \u3010\u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d\u3011\u63a7 \u3010\u5b9e\u9645\u95f4\u63a5\u8d39\u603b\u91d1\u989d\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
            }
            List billParamVOS = (List)response.getData();
            BigDecimal totalContractMny = this.totalContractMny(vo);
            CommonResponse respPay = this.budgetControlApi.budgetControlTotal(vo.getProjectId());
            this.logger.info("\u7edf\u8ba1\u8d39\u7528\u62a5\u9500\u3001\u5907\u7528\u91d1\u62a5\u9500\u3001\u96f6\u661f\u4ed8\u6b3e\u7533\u8bf7 \u91d1\u989d:{}", (Object)JSONObject.toJSONString((Object)respPay));
            if (!response.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u9519\u8bef" + respPay.getMsg());
            }
            if (respPay.getData() != null) {
                totalContractMny = totalContractMny.add((BigDecimal)respPay.getData());
            }
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 == billParamVO.getControlType()) continue;
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                    BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);
                    this.logger.info("\u5176\u4ed6\u8d39\u7528:{} \u95f4\u63a5\u8d39\u7528:{}", (Object)JSONObject.toJSONString((Object)totalContractMny), (Object)JSONObject.toJSONString((Object)budgetTaxMnyResult));
                    if (totalContractMny.compareTo(budgetTaxMnyResult) <= 0) continue;
                    BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem("\u5b9e\u9645\u95f4\u63a5\u8d39\u603b\u91d1\u989d\u8d85\u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d");
                    paramsCheckDsVO.setWarnName("\u5b9e\u9645\u95f4\u63a5\u8d39\u603b\u91d1\u989d\u5927\u4e8e\u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d * " + roleValue + "%");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u8be5\u9879\u76ee\u5b9e\u9645\u95f4\u63a5\u8d39\u603b\u91d1\u989d\uff1a").append(totalContractMny.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c \u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d * ").append(roleValue).append("%\uff1a").append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(over.setScale(2, RoundingMode.HALF_UP)).append("\u5143\u3002");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    OtherContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                }
            }
        }
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }

    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public BigDecimal totalContractMny(OtherContractVO vo) {
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        QueryWrapper contractQuery = new QueryWrapper();
        contractQuery.eq((Object)"project_Id", (Object)vo.getProjectId());
        contractQuery.ne((Object)"change_status", (Object)2);
        if (vo.getId() != null) {
            contractQuery.ne((Object)"id", (Object)vo.getId());
        }
        if (vo.getContractTaxMny() != null) {
            contractTaxMny = contractTaxMny.add(vo.getContractTaxMny());
        }
        contractQuery.select(new String[]{"sum(contract_tax_mny) as contractTaxMny"});
        OtherContractEntity contractEntity = (OtherContractEntity)((Object)super.getOne((Wrapper)contractQuery));
        if (contractEntity != null && null != contractEntity.getContractTaxMny() && !"0".equals(contractEntity.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(contractEntity.getContractTaxMny());
        }
        QueryWrapper changeQuery = new QueryWrapper();
        changeQuery.eq((Object)"project_Id", (Object)vo.getProjectId());
        changeQuery.in((Object)"bill_state", Arrays.asList(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
        changeQuery.select(new String[]{"sum(contract_tax_mny) as contractTaxMny"});
        OtherContractChangeEntity changeEntity = (OtherContractChangeEntity)((Object)this.changeService.getOne((Wrapper)changeQuery));
        if (changeEntity != null && null != changeEntity.getContractTaxMny() && !"0".equals(changeEntity.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(changeEntity.getContractTaxMny());
        }
        return contractTaxMny;
    }
}

