/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherSettleService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherSettle")
public class OtherSettleBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IOtherSettleService settleService;
    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ICostDetailApi costDetailApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OtherSettleEntity settleEntity = (OtherSettleEntity)((Object)this.settleService.selectById(billId));
        OtherContractEntity contractEntity = (OtherContractEntity)((Object)this.contractService.selectById(settleEntity.getContractId()));
        BigDecimal sumSettleMny = MathUtil.safeAdd((BigDecimal)contractEntity.getSumSettleMny(), (BigDecimal)settleEntity.getSettleMny());
        BigDecimal sumSettleTaxMny = MathUtil.safeAdd((BigDecimal)contractEntity.getSumSettleTaxMny(), (BigDecimal)settleEntity.getSettleTaxMny());
        BigDecimal sumOffsetMny = MathUtil.safeAdd((BigDecimal)contractEntity.getSumOffsetMny(), (BigDecimal)settleEntity.getThisOffsetMny());
        LambdaUpdateWrapper lambda = new LambdaUpdateWrapper();
        lambda.set(OtherContractEntity::getSumSettleMny, (Object)sumSettleMny);
        lambda.set(OtherContractEntity::getSumSettleTaxMny, (Object)sumSettleTaxMny);
        lambda.set(OtherContractEntity::getSumOffsetMny, (Object)sumOffsetMny);
        String settleType = settleEntity.getSettleType();
        if ("1".equals(settleType)) {
            lambda.set(OtherContractEntity::getIsFinish, (Object)1);
            lambda.set(OtherContractEntity::getContractStatus, (Object)"3");
        }
        lambda.eq(BaseEntity::getId, (Object)settleEntity.getContractId());
        this.contractService.update((Wrapper)lambda);
        this.settleService.processCost(settleEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse commonResponse = this.costDetailApi.checkShareFlag(billId);
        if (!commonResponse.isSuccess()) {
            return CommonResponse.error((String)commonResponse.getMsg());
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (res.isSuccess()) {
            this.settleService.delCost(billId);
            return this.callBackContract(billId);
        }
        return CommonResponse.error((String)res.getMsg());
    }

    private CommonResponse<String> callBackContract(Long billId) {
        OtherSettleEntity settleEntity = (OtherSettleEntity)((Object)this.settleService.selectById(billId));
        OtherContractEntity contractEntity = (OtherContractEntity)((Object)this.contractService.selectById(settleEntity.getContractId()));
        LambdaQueryWrapper lambdaList = new LambdaQueryWrapper();
        lambdaList.eq(OtherSettleEntity::getContractId, (Object)settleEntity.getContractId());
        lambdaList.eq(BaseEntity::getDr, (Object)0);
        lambdaList.ne(BaseEntity::getId, (Object)billId);
        List list = this.settleService.list((Wrapper)lambdaList);
        for (OtherSettleEntity otherSettleEntity : list) {
            if (otherSettleEntity.getBillState() != BillStateEnum.PASSED_STATE.getBillStateCode() && otherSettleEntity.getBillState() != BillStateEnum.COMMITED_STATE.getBillStateCode()) {
                return CommonResponse.error((String)"\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355,\u8bf7\u5904\u7406\u540e\u518d\u64a4\u56de\uff01");
            }
            if (otherSettleEntity.getCreateTime().getTime() <= settleEntity.getCreateTime().getTime()) continue;
            return CommonResponse.error((String)"\u5728\u6b64\u5355\u636e\u4e4b\u540e\u8be5\u5408\u540c\u5df2\u5b58\u5728\u5176\u5b83\u7ed3\u7b97\u5355,\u8bf7\u4f9d\u6b21\u64a4\u56de\uff01");
        }
        BigDecimal sumSettleMny = MathUtil.safeSub((BigDecimal)contractEntity.getSumSettleMny(), (BigDecimal)settleEntity.getSettleMny());
        BigDecimal sumSettleTaxMny = MathUtil.safeSub((BigDecimal)contractEntity.getSumSettleTaxMny(), (BigDecimal)settleEntity.getSettleTaxMny());
        BigDecimal sumOffsetMny = MathUtil.safeSub((BigDecimal)contractEntity.getSumOffsetMny(), (BigDecimal)settleEntity.getThisOffsetMny());
        LambdaUpdateWrapper lambda = new LambdaUpdateWrapper();
        lambda.set(OtherContractEntity::getSumSettleMny, (Object)sumSettleMny);
        lambda.set(OtherContractEntity::getSumSettleTaxMny, (Object)sumSettleTaxMny);
        lambda.set(OtherContractEntity::getSumOffsetMny, (Object)sumOffsetMny);
        String settleType = settleEntity.getSettleType();
        if ("1".equals(settleType)) {
            lambda.set(OtherContractEntity::getIsFinish, (Object)0);
            lambda.set(OtherContractEntity::getContractStatus, (Object)"2");
        }
        lambda.eq(BaseEntity::getId, (Object)settleEntity.getContractId());
        this.contractService.update((Wrapper)lambda);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

