package com.ejianc.business.othprice.api;

import com.ejianc.business.othprice.hystrix.IOtherInquiryHystrix;
import com.ejianc.business.othprice.hystrix.IPicketageHystrix;
import com.ejianc.business.othprice.vo.PicketageVO;
import com.ejianc.business.othprice.vo.SubContractorBidVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * IOtherInquiryApi
 *
 */
@FeignClient(name = "ejc-othprice-web", url = "${common.env.feign-client-url}", path = "ejc-othprice-web", fallback = IOtherInquiryHystrix.class)
public interface IOtherInquiryApi {


    /**
     * @Description 获取供应商投标信息
     * 投标数
     * 中标数
     * 未中标数
     * 历史平均投标系数
     * 历史平均中标系数
     */
    @GetMapping(value = "/api/otherInquiry/getSubContractorBidInfo")
    CommonResponse<SubContractorBidVO> getSubContractorBidInfo(@RequestParam(value = "supplierId") Long supplierId);

}
