package com.ejianc.business.othprice.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 劳务供应商投标入围
 * 
 * @author generator
 * 
 */
public class ShortlistVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 单据编号
    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private String area; // 所在省市
    private BigDecimal builtArea; // 项目面积
    private String planDuration; // 工期
    private BigDecimal costTotal; // 项目金额
    private String memo; // 备注
    private String projectType; // 项目类型
    private Long requirements; // 质量要求
    private Long biddingMajor; // 招标专业
    private String office; // 有无以下科室
    private Long evaluate; // 最低入围评价
    private BigDecimal guidePrice; // 指导价金额
    private String tenderName; // 标段名称

    private String projectTypeName;
    private String officeName;


    private List<ShortlistDetailVO> shortlistDetailList = new ArrayList<>(); // 劳务供应商投标入围子表

    public BigDecimal getGuidePrice() {
        return guidePrice;
    }

    public void setGuidePrice(BigDecimal guidePrice) {
        this.guidePrice = guidePrice;
    }

    public String getTenderName() {
        return tenderName;
    }

    public void setTenderName(String tenderName) {
        this.tenderName = tenderName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public BigDecimal getBuiltArea() {
        return builtArea;
    }

    public void setBuiltArea(BigDecimal builtArea) {
        this.builtArea = builtArea;
    }
    public String getPlanDuration() {
        return planDuration;
    }

    public void setPlanDuration(String planDuration) {
        this.planDuration = planDuration;
    }
    public BigDecimal getCostTotal() {
        return costTotal;
    }

    public void setCostTotal(BigDecimal costTotal) {
        this.costTotal = costTotal;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getProjectType() {
        return projectType;
    }

    @ReferDeserialTransfer
    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getRequirements() {
        return requirements;
    }

    @ReferDeserialTransfer
    public void setRequirements(Long requirements) {
        this.requirements = requirements;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBiddingMajor() {
        return biddingMajor;
    }

    @ReferDeserialTransfer
    public void setBiddingMajor(Long biddingMajor) {
        this.biddingMajor = biddingMajor;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getOffice() {
        return office;
    }

    @ReferDeserialTransfer
    public void setOffice(String office) {
        this.office = office;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getEvaluate() {
        return evaluate;
    }

    @ReferDeserialTransfer
    public void setEvaluate(Long evaluate) {
        this.evaluate = evaluate;
    }

    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }

    public String getOfficeName() {
        return officeName;
    }

    public void setOfficeName(String officeName) {
        this.officeName = officeName;
    }

    public List<ShortlistDetailVO> getShortlistDetailList() {
        return shortlistDetailList;
     }

     public void setShortlistDetailList(List<ShortlistDetailVO> shortlistDetailList) {
        this.shortlistDetailList = shortlistDetailList;
     }
}
