package com.ejianc.business.othprice.consts;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author
 * @Date
 * @Description
 */

public enum InquiryStateEnum {
    DEFAULT_STATE(1,"未开始"),
    QUOTATION_STATE(2,"报价中"),
    EXPIRATION_STATE(3,"已截止"),
    WIN_STATE(4,"已定标"),
    SIGN_STATE(5,"已签订");


    private Integer code;

    private String description;
    //构造方法
    private InquiryStateEnum(Integer code, String description ){
        this.code = code;
        this.description = description;
    }

    private static Map<Integer, InquiryStateEnum> enumMap = new HashMap<>();

    static {
        enumMap = EnumSet.allOf(InquiryStateEnum.class).stream().collect(Collectors.toMap(InquiryStateEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static String getTypeNameByCode(Integer code) {
        InquiryStateEnum type = enumMap.get(code);
        return type == null ? null : type.getDescription();
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
