package com.ejianc.business.othprice.utils;

import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author yqls
 * @date 2021-05-24 18:23:16
 */
@Component
public class DetailListUtil<T> {

    public List<T> setDetailList(List<T> list) {
        Map<String, Map<Long, List<BaseEntity>>> fieldSubMap = this.getFieldSubMap(list);
        if(list != null && list.size() > 0) {
            list.forEach(entity->{
                Class<?> mainClass = entity.getClass();
                Field[] fields = mainClass.getDeclaredFields();
                /** 查找字表字段 可能有多个子表*/
                for (Field field : fields) {
                    if(field.isAnnotationPresent(SubEntity.class)){
                        SubEntity subEntity = field.getAnnotation(SubEntity.class);
                        String serviceName = subEntity.serviceName();
                        String fieldName = field.getName();
                        if(StringUtils.isBlank(serviceName)){
                            throw new BusinessException("子表字段【"+fieldName+"】注解SubEntity未设置子表实现类服务名！");
                        }
                        BaseServiceImpl subService = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
                        if(subService==null){
                            throw new BusinessException("字段【"+fieldName+"】子表没有实现类！");
                        }
                        try {
                            Method m =  mainClass.getMethod("getId",  null);
                            /** 获取子表数据 */
                            Long id = (Long)m.invoke(entity, null);
                            Map<Long, List<BaseEntity>> subMap = fieldSubMap.get(fieldName);
                            if(subMap != null && subMap.containsKey(id)){
                                List<BaseEntity> subList = subMap.get(id);
                                Class[] cArg = new Class[1];
                                cArg[0] = field.getType();
                                Method setSubList = mainClass.getDeclaredMethod("set"+fieldName.substring(0,1).toUpperCase()+fieldName.substring(1),cArg);
                                setSubList.invoke(entity,subList);
                            }
                        } catch (NoSuchMethodException e) {
                            throw new BusinessException("字段【"+fieldName+"】未定义set方法！");
                        } catch (IllegalAccessException e) {
                            throw new BusinessException("字段【"+fieldName+"】set方法需要是public属性！");
                        } catch (InvocationTargetException e) {
                            throw new BusinessException("字段【"+fieldName+"】set方法执行出错！");
                        }

                    }
                }
            });
        }
        return list;
    }

    /**
     * 根据主表主键批量查询子表
     * @param list
     * @return
     */
    private Map<String, Map<Long, List<BaseEntity>>> getFieldSubMap(List<T> list) {
        if(CollectionUtils.isEmpty(list)){
            return new HashMap<>();
        }
        List<Long> ids = list.stream().map(x->Long.valueOf(String.valueOf(getValue(x, "id")))).collect(Collectors.toList());
        Class<?> mainClass = list.get(0).getClass();
        Field[] fields = mainClass.getDeclaredFields();
        /** 查找字表字段 可能有多个子表*/
        Map<String, Map<Long, List<BaseEntity>>> fieldSubMap = new HashMap<>();
        for (Field field : fields) {
            if(field.isAnnotationPresent(SubEntity.class)){
                SubEntity subEntity = field.getAnnotation(SubEntity.class);
                String serviceName = subEntity.serviceName();
                String fieldName = field.getName();
                if(StringUtils.isBlank(serviceName)){
                    throw new BusinessException("子表字段【"+fieldName+"】注解SubEntity未设置子表实现类服务名！");
                }
                BaseServiceImpl subService = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
                if(subService==null){
                    throw new BusinessException("字段【"+fieldName+"】子表没有实现类！");
                }
                /** 获取子表数据 */
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put(subEntity.pidName(), new Parameter(QueryParam.IN, ids));
                queryParam.getOrderMap().put("id",QueryParam.ASC);
                List<BaseEntity> subList = subService.queryList(queryParam,false);
                Map<Long, List<BaseEntity>> subMap = subList.stream().collect(Collectors.groupingBy(x->
                        Long.valueOf(String.valueOf(getValue(x, subEntity.pidName())))));
                fieldSubMap.put(fieldName, subMap);
            }
        }
        return fieldSubMap;
    }

    /**
     * get方法
     * @param t
     * @param fieldName
     * @param <T>
     * @return
     */
    private static <T> Object getValue(T t, String fieldName) {
        Class<?> clazz = t.getClass() ;
        for(; clazz != Object.class ; clazz = clazz.getSuperclass()) {
            try {
                Method m = clazz.getDeclaredMethod("get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), (Class[]) null);
                try {
                    return m.invoke(t, (Object[]) null);
                } catch (IllegalAccessException e) {
                    throw new BusinessException("类【" + clazz + "】的字段【" + fieldName + "】的get方法需要设置成public属性！");
                } catch (InvocationTargetException e) {
                    throw new BusinessException("类【" + clazz + "】的字段【" + fieldName + "】的get方法调用失败！");
                }
            } catch (Exception e) {
                //这里甚么都不要做！并且这里的异常必须这样写，不能抛出去。
                //如果这里的异常打印或者往外抛，则就不会执行clazz = clazz.getSuperclass(),最后就不会进入到父类中了
            }
        }
        return null;
    }
}
