/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.othprice.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.othprice.bean.ResultEntity;
import com.ejianc.business.othprice.service.IResultDetailService;
import com.ejianc.business.othprice.service.IResultService;
import com.ejianc.business.othprice.vo.MaterialResultVO;
import com.ejianc.business.othprice.vo.PicketageVO;
import com.ejianc.business.othprice.vo.ResultDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"result"})
@Api(value="\u6750\u6599\u5b9a\u6807\u7ed3\u679c", tags={"\u6750\u6599\u5b9a\u6807\u7ed3\u679c"})
public class ResultController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialApi materialApi;
    private static final String BILL_CODE = "OTHER_RESULT";
    @Autowired
    private IResultService service;
    @Autowired
    private IResultDetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialResultVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody MaterialResultVO saveOrUpdateVO) {
        ResultEntity entity = (ResultEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ResultEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        MaterialResultVO vo = (MaterialResultVO)BeanMapper.map((Object)((Object)entity), MaterialResultVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u4e2d\u6807\u4f9b\u5e94\u5546\u5217\u8868")
    @RequestMapping(value={"/querySupplierList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialResultVO>> querySupplierList(@RequestParam Long picketageId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ResultEntity::getPicketageId, (Object)picketageId);
        List list = this.service.list((Wrapper)wrapper);
        List materialResultVOS = BeanMapper.mapList((Iterable)list, MaterialResultVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u4e2d\u6807\u4f9b\u5e94\u5546\u5217\u8868\uff01", (Object)materialResultVOS);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialResultVO> queryDetail(@RequestParam Long id) {
        ResultEntity entity = (ResultEntity)((Object)this.service.selectById(id));
        MaterialResultVO vo = (MaterialResultVO)BeanMapper.map((Object)((Object)entity), MaterialResultVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetailByCon"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialResultVO> queryDetailByCon(@RequestBody MaterialResultVO materialResultVO) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(ResultEntity::getPicketageId, (Object)materialResultVO.getPicketageId());
        lambdaQueryWrapper.eq(ResultEntity::getSupplierId, (Object)materialResultVO.getSupplierId());
        List list = this.service.list((Wrapper)lambdaQueryWrapper);
        MaterialResultVO vo = null;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo = (MaterialResultVO)BeanMapper.map(list.get(0), MaterialResultVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u4e2d\u6807\u7ed3\u679c\u5217\u8868\u901a\u8fc7\u5b9a\u6807\u5355")
    @RequestMapping(value={"/queryListByPicketage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialResultVO>> queryListByPicketage(@RequestBody PicketageVO picketageVO) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(ResultEntity::getPicketageId, (Object)picketageVO.getId());
        List list = this.service.list((Wrapper)lambdaQueryWrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.mapList((Iterable)list, MaterialResultVO.class));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialResultVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialResultVO materialResultVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialResultVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialResultVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialResult-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refOtherResultData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialResultVO>> refOtherResultData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("purchaseSubject");
        param.getFuzzyFields().add("purchaseTypeName");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"orgId")) {
                param.getComplexParams().add(this.getPageQueryParam(_con.getLong("orgId")));
            }
            if (_con.containsKey((Object)"supplierId") && _con.getLong("supplierId") != null) {
                param.getParams().put("supplierId", new Parameter("eq", (Object)_con.getLong("supplierId")));
            }
            if (_con.containsKey((Object)"pricingType")) {
                param.getParams().put("pricingType", new Parameter("eq", (Object)_con.getLong("pricingType")));
            }
            if (_con.containsKey((Object)"purchaseType")) {
                param.getParams().put("purchaseType", new Parameter("eq", (Object)_con.getInteger("purchaseType")));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialResultVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse childOrgResp = this.iOrgApi.findChildrenByParentId(orgId);
        CommonResponse parentOrgResp = this.iOrgApi.findParentsByOrgId(orgId);
        if (!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("\u5408\u540c\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList parentOrgIds = new ArrayList();
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentOrgIds.addAll(((List)parentOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentOrgIds.remove(orgId);
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("org_id", new Parameter("in", childIds));
        c1.getComplexParams().add(c2);
        if (CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("purchase_type", new Parameter("eq", (Object)2));
            c3.getParams().put("org_id", new Parameter("in", parentOrgIds));
            c1.getComplexParams().add(c3);
        }
        return c1;
    }

    @RequestMapping(value={"/refResultDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ResultDetailVO>> refResultDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("detailName");
        param.getFuzzyFields().add("detailCode");
        param.getFuzzyFields().add("model");
        param.getFuzzyFields().add("unit");
        ResultEntity entity = new ResultEntity();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (!_con.containsKey((Object)"pid")) {
                return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6\u5b9a\u6807\u7ed3\u679c\u5355Id\u3010pid\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            param.getParams().put("pid", new Parameter("eq", (Object)_con.getLong("pid")));
            entity = (ResultEntity)((Object)this.service.selectById(_con.getLong("pid")));
        }
        IPage page = this.detailService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List list = BeanMapper.mapList((Iterable)page.getRecords(), ResultDetailVO.class);
        pageData.setRecords(list);
        page.setTotal(page.getTotal());
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

