/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.othprice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.othprice.bean.OtherInquiryEntity;
import com.ejianc.business.othprice.bean.PicketageDetailEntity;
import com.ejianc.business.othprice.bean.PicketageEntity;
import com.ejianc.business.othprice.bean.PicketageQuoteDetailEntity;
import com.ejianc.business.othprice.bean.PicketageQuoteEntity;
import com.ejianc.business.othprice.bean.PicketageSupplierEntity;
import com.ejianc.business.othprice.bean.ResultDetailEntity;
import com.ejianc.business.othprice.bean.ResultEntity;
import com.ejianc.business.othprice.common.vo.InquiryCommonVO;
import com.ejianc.business.othprice.mapper.PicketageMapper;
import com.ejianc.business.othprice.service.IOtherInquiryService;
import com.ejianc.business.othprice.service.IPicketageQuoteDetailService;
import com.ejianc.business.othprice.service.IPicketageQuoteService;
import com.ejianc.business.othprice.service.IPicketageService;
import com.ejianc.business.othprice.service.IPicketageSupplierService;
import com.ejianc.business.othprice.service.IResultDetailService;
import com.ejianc.business.othprice.service.IResultService;
import com.ejianc.business.othprice.service.InquiryCommonService;
import com.ejianc.business.othprice.service.impl.OtherQuoteServiceImpl;
import com.ejianc.business.othprice.vo.OtherInquiryDetailVO;
import com.ejianc.business.othprice.vo.OtherInquiryVO;
import com.ejianc.business.othprice.vo.PicketageDetailVO;
import com.ejianc.business.othprice.vo.PicketageVO;
import com.ejianc.business.utils.DateUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="materialPicketageService")
public class PicketageServiceImpl
extends BaseServiceImpl<PicketageMapper, PicketageEntity>
implements IPicketageService {
    private static final Logger logger = LoggerFactory.getLogger(OtherQuoteServiceImpl.class);
    private static final String DEFAULT_TEMPLATE_CODE = "SMS_273725524";
    private static final String TEMPLATE_CODE = "templateCode";
    @Autowired
    private IPicketageSupplierService supplierService;
    @Autowired
    private IPicketageService service;
    @Autowired
    private IResultService materialResultService;
    @Autowired
    private IOtherInquiryService inquiryService;
    @Autowired
    private IPicketageSupplierService materialPicketageSupplierService;
    @Autowired
    private InquiryCommonService inquiryCommonService;
    @Autowired
    private IPicketageQuoteDetailService purchaseDetailService;
    @Autowired
    private IMaterialSettlementApi materialSettlementApi;
    @Autowired
    private IResultDetailService resultPurchaseDetailService;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private IPicketageQuoteService quoteService;

    @Override
    public boolean insertOrUpdate(PicketageEntity entity) {
        ArrayList supplierEntities = new ArrayList();
        ArrayList supplierList = new ArrayList();
        Boolean success = super.saveOrUpdate((Object)entity, false);
        if (success.booleanValue() && !ListUtil.isEmpty(entity.getDetailList())) {
            entity.getDetailList().forEach(sub -> supplierList.addAll(sub.getPicketageSupplierList()));
            List<PicketageDetailEntity> purchaseList = entity.getDetailList();
            List ids = purchaseList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(ids)) {
                QueryParam param = new QueryParam();
                param.getParams().put("picketageDetailId", new Parameter("in", ids));
                List suppliers = this.supplierService.queryList(param, false);
                if (!ListUtil.isEmpty((List)suppliers)) {
                    this.supplierService.removeByIds(suppliers.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
                }
                purchaseList.forEach(sub -> sub.getPicketageSupplierList().forEach(supplier -> {
                    supplier.setPicketageId(entity.getId());
                    supplier.setPicketageDetailId(sub.getId());
                    supplierEntities.add(supplier);
                }));
            }
            if (CollectionUtils.isNotEmpty(supplierEntities)) {
                this.supplierService.saveOrUpdateBatch(supplierEntities, supplierEntities.size());
            }
        }
        return true;
    }

    @Override
    public void checkRefSave(PicketageEntity entity) {
        int count;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"inquiry_id", (Object)entity.getInquiryId());
        if (entity.getId() != null) {
            queryWrapper.ne((Object)"id", (Object)entity.getId());
        }
        if ((count = super.count((Wrapper)queryWrapper)) > 0) {
            throw new BusinessException("\u4e00\u4e2a\u8be2\u4ef7\u7533\u8bf7\u5355\u53ea\u80fd\u6709\u4e00\u4e2a\u81ea\u7531\u6001\u7684\u5b9a\u6807\u5355\uff01");
        }
    }

    @Override
    public boolean insertOrUpdateRef(PicketageEntity entity) {
        Boolean success;
        if (!ListUtil.isEmpty(entity.getQuoteList())) {
            List collect = entity.getQuoteList().stream().filter(e -> e.getBidFlag() == 1).map(PicketageQuoteEntity::getSupplierId).collect(Collectors.toList());
            String bidWinnerIdStr = collect.stream().map(String::valueOf).collect(Collectors.joining(","));
            List nameList = entity.getQuoteList().stream().filter(e -> e.getBidFlag() == 1).map(PicketageQuoteEntity::getSupplierNameView).collect(Collectors.toList());
            String bidWinnerNameStr = nameList.stream().map(String::valueOf).collect(Collectors.joining(","));
            entity.setBidWinnerId(bidWinnerIdStr);
            entity.setBidWinnerName(bidWinnerNameStr);
        }
        if ((success = Boolean.valueOf(super.saveOrUpdate((Object)entity, false))).booleanValue()) {
            QueryWrapper purchaseWrapper = new QueryWrapper();
            purchaseWrapper.eq((Object)"picketage_id", (Object)entity.getId());
            List delPurchaseList = this.purchaseDetailService.list((Wrapper)purchaseWrapper);
            if (CollectionUtils.isNotEmpty((Collection)delPurchaseList)) {
                this.purchaseDetailService.removeByIds(delPurchaseList.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
            }
            if (CollectionUtils.isNotEmpty(entity.getQuoteList())) {
                ArrayList<PicketageQuoteDetailEntity> savePurchaseDetail = new ArrayList<PicketageQuoteDetailEntity>();
                List<PicketageQuoteEntity> quoteList = entity.getQuoteList();
                for (PicketageQuoteEntity quote : quoteList) {
                    if (!CollectionUtils.isNotEmpty(quote.getQuoteDetailList())) continue;
                    for (PicketageQuoteDetailEntity detail : quote.getQuoteDetailList()) {
                        detail.setPicketageQuoteId(quote.getId());
                        detail.setPicketageId(entity.getId());
                        detail.setId(IdWorker.getId());
                    }
                    savePurchaseDetail.addAll(quote.getQuoteDetailList());
                }
                if (CollectionUtils.isNotEmpty(savePurchaseDetail)) {
                    this.purchaseDetailService.saveOrUpdateBatch(savePurchaseDetail);
                }
            }
        }
        return true;
    }

    @Override
    public void pushPicketage(Long billId) {
        PicketageEntity entity = (PicketageEntity)((Object)this.service.selectById(billId));
        if (entity.getSelfFlag() == 1) {
            ResultEntity resultEntity = this.builderResultEntity(entity);
            this.materialResultService.saveOrUpdate((Object)resultEntity, false);
        } else {
            this.builderResultRef(entity);
        }
    }

    @Override
    public void rollBackPicketage(Long billId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"picketage_id", (Object)billId);
        List list = this.materialResultService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.materialResultService.removeByIds(list.stream().map(BaseEntity::getId).collect(Collectors.toList()), true);
        }
    }

    public ResultEntity builderResultEntity(PicketageEntity entity) {
        ResultEntity result = new ResultEntity();
        ArrayList<ResultDetailEntity> purchaseList = new ArrayList<ResultDetailEntity>();
        result.setPicketageId(entity.getId());
        result.setPicketageSelfFlag(entity.getSelfFlag());
        if (StringUtils.isNotEmpty((String)entity.getBidWinnerId())) {
            result.setSupplierId(Long.parseLong(entity.getBidWinnerId()));
            result.setSupplierName(entity.getBidWinnerName());
        }
        result.setProjectId(entity.getProjectId());
        result.setProjectName(entity.getProjectName());
        result.setOrgId(entity.getOrgId());
        result.setOrgName(entity.getOrgName());
        result.setPurchaseSubject(entity.getName());
        result.setPricingType(entity.getPricingType());
        switch (result.getPricingType()) {
            case 1: {
                result.setPricingTypeName("\u52b3\u52a1\u5206\u5305");
                break;
            }
            case 2: {
                result.setPricingTypeName("\u4e13\u4e1a\u5206\u5305");
                break;
            }
            case 3: {
                result.setPricingTypeName("\u8bbe\u5907\u91c7\u8d2d");
                break;
            }
            case 4: {
                result.setPricingTypeName("\u8bbe\u5907\u79df\u8d41");
                break;
            }
            default: {
                result.setPricingTypeName("\u5176\u4ed6");
            }
        }
        result.setPurchaseType(entity.getPurchaseType());
        result.setPurchaseTypeName(entity.getPurchaseType() == 1 ? "\u9879\u76ee\u81ea\u91c7" : "\u516c\u53f8\u96c6\u91c7");
        result.setBillCode(entity.getBillCode());
        result.setInquiryMny(entity.getInquiryMny());
        result.setBidFlag(1);
        result.setHandleDate(entity.getHandleDate());
        result.setBidMny(entity.getBidWinMny());
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            Map<Object, Object> winSupplierMap = new HashMap();
            if (StringUtils.isNotEmpty((String)entity.getBidWinnerId())) {
                QueryParam param = new QueryParam();
                param.getParams().put("supplierId", new Parameter("eq", (Object)Long.parseLong(entity.getBidWinnerId())));
                List supplierEntities = this.supplierService.queryList(param, false);
                winSupplierMap = supplierEntities.stream().collect(Collectors.toMap(k -> k.getPicketageDetailId(), k -> k));
            }
            for (PicketageDetailEntity purchase : entity.getDetailList()) {
                ResultDetailEntity resultPurchase = new ResultDetailEntity();
                resultPurchase.setDetailCode(purchase.getDetailCode());
                resultPurchase.setDetailName(purchase.getDetailName());
                resultPurchase.setSpec(purchase.getSpec());
                resultPurchase.setUnit(purchase.getUnit());
                resultPurchase.setResidueNum(purchase.getNum());
                resultPurchase.setReferPrice(purchase.getReferPrice());
                resultPurchase.setSourceId(purchase.getId());
                if (!winSupplierMap.isEmpty()) {
                    PicketageSupplierEntity picketageSupplierEntity = (PicketageSupplierEntity)((Object)winSupplierMap.get(purchase.getId()));
                    resultPurchase.setBidNum(purchase.getNum());
                    resultPurchase.setBidPrice(picketageSupplierEntity.getPrice());
                    BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)picketageSupplierEntity.getPrice(), (BigDecimal)purchase.getNum());
                    resultPurchase.setBidMny(mny);
                }
                purchaseList.add(resultPurchase);
            }
        }
        if (CollectionUtils.isNotEmpty(purchaseList)) {
            result.setDetailList(purchaseList);
        }
        return result;
    }

    @Override
    public CommonResponse<JSONObject> queryByInquiryToDetailAndQuote(String inquiryId) {
        JSONObject jsonObject = new JSONObject();
        Map<Object, Object> collect = new HashMap();
        OtherInquiryEntity materialInquiryEntity = (OtherInquiryEntity)((Object)this.inquiryService.selectById((Serializable)((Object)inquiryId)));
        OtherInquiryVO inquiryVO = (OtherInquiryVO)BeanMapper.map((Object)((Object)materialInquiryEntity), OtherInquiryVO.class);
        InquiryCommonVO inquiryCommonVO = this.inquiryCommonService.queryDetailByInquiry(materialInquiryEntity.getId(), materialInquiryEntity.getInquiryState(), materialInquiryEntity.getPricingType().toString(), false);
        jsonObject.put("quoteList", (Object)inquiryCommonVO.getOtherQuoteVOList());
        jsonObject.put("inquiry", BeanMapper.map((Object)((Object)materialInquiryEntity), OtherInquiryVO.class));
        collect = inquiryCommonVO.getOtherInquiryDetailList().stream().collect(Collectors.toMap(BaseVO::getId, OtherInquiryDetailVO::getNum));
        jsonObject.put("detailList", (Object)inquiryCommonVO.getOtherInquiryDetailList());
        jsonObject.put("totalMap", collect);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @Override
    public JSONObject queryDetailToRef(Long id) {
        InquiryCommonVO inquiryCommonVO;
        PicketageEntity picketageEntity = (PicketageEntity)((Object)this.service.selectById(id));
        Map<Object, Object> collect = new HashMap();
        OtherInquiryEntity byId = (OtherInquiryEntity)((Object)this.inquiryService.selectById(picketageEntity.getInquiryId()));
        OtherInquiryVO materialInquiry = (OtherInquiryVO)BeanMapper.map((Object)((Object)byId), OtherInquiryVO.class);
        if (materialInquiry.getPricingType().equals(new Integer(1))) {
            collect = materialInquiry.getOtherInquiryDetailList().stream().collect(Collectors.toMap(BaseVO::getId, OtherInquiryDetailVO::getNum));
        }
        for (Object key : collect.keySet()) {
            QueryWrapper ew = new QueryWrapper();
            ew.eq((Object)"inquiry_id", (Object)picketageEntity.getInquiryId());
            ew.eq((Object)"source_id", key);
            ew.select(new String[]{"IFNULL(sum(bid_num),0) AS num"});
            Map map = this.purchaseDetailService.getMap((Wrapper)ew);
            BigDecimal num = ((BigDecimal)collect.get(key)).subtract((BigDecimal)map.get("num"));
            collect.put((Long)key, num);
        }
        Map<Object, Object> purchaseListMap = new HashMap();
        QueryWrapper quotePurchaseWrapper = new QueryWrapper();
        quotePurchaseWrapper.eq((Object)"picketage_id", (Object)id);
        List purchaseDetailEntities = this.purchaseDetailService.list((Wrapper)quotePurchaseWrapper);
        if (CollectionUtils.isNotEmpty((Collection)purchaseDetailEntities)) {
            purchaseListMap = purchaseDetailEntities.stream().collect(Collectors.groupingBy(PicketageQuoteDetailEntity::getPicketageQuoteId));
        }
        for (PicketageQuoteEntity quote : picketageEntity.getQuoteList()) {
            if (quote.getBidFlag() != 1 || !CollectionUtils.isNotEmpty((Collection)purchaseDetailEntities)) continue;
            quote.setQuoteDetailList((List)purchaseListMap.get(quote.getId()));
        }
        PicketageVO picketageVO = (PicketageVO)BeanMapper.map((Object)((Object)picketageEntity), PicketageVO.class);
        JSONObject jsonObject = (JSONObject)JSONObject.toJSON((Object)picketageVO);
        if (picketageVO.getHandleDate() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            jsonObject.put("handleDate", (Object)sdf.format(picketageVO.getHandleDate()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(inquiryCommonVO = this.inquiryCommonService.queryDetailByInquiry(picketageEntity.getInquiryId(), materialInquiry.getInquiryState(), materialInquiry.getPricingType().toString(), false)).getOtherInquiryDetailList())) {
            jsonObject.put("detailList", (Object)inquiryCommonVO.getOtherInquiryDetailList());
        }
        jsonObject.put("totalMap", collect);
        return jsonObject;
    }

    @Override
    public PicketageVO queryMaterialPicketageDetail(Long id) {
        PicketageEntity entity = (PicketageEntity)((Object)this.service.selectById(id));
        PicketageVO vo = new PicketageVO();
        entity = this.querySupplier(entity);
        vo = (PicketageVO)BeanMapper.map((Object)((Object)entity), PicketageVO.class);
        return vo;
    }

    private PicketageEntity querySupplier(PicketageEntity entity) {
        if (!ListUtil.isEmpty(entity.getDetailList())) {
            ArrayList detailIds = new ArrayList();
            List purchaseIds = entity.getDetailList().stream().map(BaseEntity::getId).collect(Collectors.toList());
            detailIds.addAll(purchaseIds);
            Map<Object, Object> supplierMap = new HashMap();
            if (CollectionUtils.isNotEmpty(detailIds)) {
                QueryParam param = new QueryParam();
                param.getParams().put("picketageDetailId", new Parameter("in", detailIds));
                List supplierEntities = this.materialPicketageSupplierService.queryList(param, false);
                if (CollectionUtils.isNotEmpty((Collection)supplierEntities)) {
                    supplierMap = supplierEntities.stream().collect(Collectors.groupingBy(PicketageSupplierEntity::getPicketageDetailId));
                }
                if (!supplierMap.isEmpty()) {
                    for (PicketageDetailEntity purchase : entity.getDetailList()) {
                        purchase.setPicketageSupplierList((List)supplierMap.get(purchase.getId()));
                    }
                }
            }
        }
        return entity;
    }

    @Override
    public PicketageVO queryMaterialPriceArea(PicketageVO vo) {
        MaterialPriceVO priceVO = new MaterialPriceVO(vo.getProjectId());
        ArrayList<MaterialPriceVO> detail = new ArrayList<MaterialPriceVO>();
        List purchaseDetailList = vo.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)purchaseDetailList)) {
            for (PicketageDetailVO picketageDetailVO : purchaseDetailList) {
                MaterialPriceVO materialPriceVO = new MaterialPriceVO();
                materialPriceVO.setMaterialId(Long.valueOf(picketageDetailVO.getMaterialId()));
                detail.add(materialPriceVO);
            }
        }
        if (CollectionUtils.isNotEmpty(detail)) {
            MaterialPriceVO materialPriceVO;
            List materialPriceVOS;
            priceVO.setDetail(detail);
            CommonResponse commonResponse = this.materialSettlementApi.queryPrice(priceVO);
            if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(materialPriceVOS = (materialPriceVO = (MaterialPriceVO)commonResponse.getData()).getDetail()))) {
                Map<Long, MaterialPriceVO> priceVOMap = materialPriceVOS.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                List vos = vo.getDetailList();
                if (CollectionUtils.isNotEmpty((Collection)vos)) {
                    for (PicketageDetailVO picketageDetailVO : vos) {
                        Long materialId = picketageDetailVO.getMaterialId();
                        MaterialPriceVO p = priceVOMap.get(materialId);
                        if (Objects.isNull(p)) continue;
                        picketageDetailVO.setMinPrice(p.getMinPrice());
                        picketageDetailVO.setMaxPrice(p.getMaxPrice());
                        picketageDetailVO.setPriceArea(p.getMinPrice().setScale(2, 4) + "~" + p.getMaxPrice().setScale(2, 4));
                    }
                    vo.setDetailList(vos);
                }
            }
        }
        return vo;
    }

    public List<ResultEntity> builderResultRef(PicketageEntity entity) {
        ArrayList<ResultEntity> resultList = new ArrayList<ResultEntity>();
        if (CollectionUtils.isNotEmpty(entity.getQuoteList())) {
            List<PicketageQuoteEntity> quoteList = entity.getQuoteList();
            Map<Object, Object> purchaseListMap = new HashMap();
            ArrayList savePurchaseList = new ArrayList();
            QueryWrapper quotePurchaseWrapper = new QueryWrapper();
            quotePurchaseWrapper.eq((Object)"picketage_id", (Object)entity.getId());
            List purchaseDetailEntities = this.purchaseDetailService.list((Wrapper)quotePurchaseWrapper);
            if (CollectionUtils.isNotEmpty((Collection)purchaseDetailEntities)) {
                purchaseListMap = purchaseDetailEntities.stream().collect(Collectors.groupingBy(PicketageQuoteDetailEntity::getPicketageQuoteId));
            }
            for (PicketageQuoteEntity quote : quoteList) {
                if (quote.getBidFlag() != 1) continue;
                ResultEntity result = new ResultEntity();
                result.setId(IdWorker.getId());
                result.setPicketageId(entity.getId());
                result.setPicketageSelfFlag(entity.getSelfFlag());
                result.setProjectId(entity.getProjectId());
                result.setProjectName(entity.getProjectName());
                result.setOrgId(entity.getOrgId());
                result.setOrgName(entity.getOrgName());
                result.setPurchaseSubject(entity.getName());
                result.setPricingType(entity.getPricingType());
                switch (result.getPricingType()) {
                    case 1: {
                        result.setPricingTypeName("\u52b3\u52a1\u5206\u5305");
                        break;
                    }
                    case 2: {
                        result.setPricingTypeName("\u4e13\u4e1a\u5206\u5305");
                        break;
                    }
                    case 3: {
                        result.setPricingTypeName("\u8bbe\u5907\u91c7\u8d2d");
                        break;
                    }
                    case 4: {
                        result.setPricingTypeName("\u8bbe\u5907\u79df\u8d41");
                        break;
                    }
                    default: {
                        result.setPricingTypeName("\u5176\u4ed6");
                    }
                }
                result.setPurchaseType(entity.getPurchaseType());
                result.setPurchaseTypeName(entity.getPurchaseType() == 1 ? "\u9879\u76ee\u81ea\u91c7" : "\u516c\u53f8\u96c6\u91c7");
                result.setBillCode(entity.getBillCode());
                result.setInquiryMny(entity.getInquiryMny());
                result.setBidFlag(1);
                result.setHandleDate(entity.getHandleDate());
                result.setBidMny(quote.getBidMny());
                result.setSupplierId(quote.getSupplierId());
                result.setSupplierName(quote.getSupplierName());
                result.setSocialCreditCode(quote.getSocialCreditCode());
                result.setLegal(quote.getLegal());
                result.setInquiryId(entity.getInquiryId());
                result.setQuoteId(quote.getQuoteId());
                result.setTelephone(quote.getTelephone());
                result.setBidMemo(quote.getBidMemo());
                result.setBidFlag(quote.getBidFlag());
                result.setQuoteMemo(quote.getQuoteMemo());
                result.setHandleDate(quote.getQuoteTime());
                result.setTotalMny(quote.getPurchaseMny());
                if (CollectionUtils.isNotEmpty((Collection)((Collection)purchaseListMap.get(quote.getId())))) {
                    List purchaseDetailList = (List)purchaseListMap.get(quote.getId());
                    ArrayList<ResultDetailEntity> materialResultPurchaseDetail = new ArrayList<ResultDetailEntity>();
                    for (PicketageQuoteDetailEntity purchase : purchaseDetailList) {
                        ResultDetailEntity purchaseDetail = new ResultDetailEntity();
                        purchaseDetail.setId(IdWorker.getId());
                        purchaseDetail.setPid(result.getId());
                        purchaseDetail.setSourceId(purchase.getId());
                        purchaseDetail.setDetailName(purchase.getDetailName());
                        purchaseDetail.setDetailCode(purchase.getDetailCode());
                        purchaseDetail.setMaterialId(purchase.getMaterialId());
                        purchaseDetail.setSpec(purchase.getSpec());
                        purchaseDetail.setUnit(purchase.getUnit());
                        purchaseDetail.setResidueNum(purchase.getResidueNum());
                        purchaseDetail.setReferPrice(purchase.getReferPrice());
                        purchaseDetail.setBidNum(purchase.getBidNum());
                        purchaseDetail.setBidPrice(purchase.getBidPrice());
                        purchaseDetail.setBidMny(purchase.getBidMny());
                        materialResultPurchaseDetail.add(purchaseDetail);
                    }
                    savePurchaseList.addAll(materialResultPurchaseDetail);
                }
                resultList.add(result);
            }
            if (CollectionUtils.isNotEmpty(savePurchaseList)) {
                this.resultPurchaseDetailService.saveOrUpdateBatch(savePurchaseList);
                logger.info("savePurchaseList--{}", (Object)JSONObject.toJSONString(savePurchaseList));
            }
            if (CollectionUtils.isNotEmpty(resultList)) {
                this.materialResultService.saveOrUpdateBatch(resultList);
                logger.info("materialResultData--{}", (Object)JSONObject.toJSONString(resultList));
            }
        }
        return resultList;
    }

    @Override
    public void sendMsg(Long id) {
        PicketageEntity entity = (PicketageEntity)((Object)super.selectById((Serializable)id));
        QueryWrapper quoteWrapper = new QueryWrapper();
        quoteWrapper.eq((Object)"picketage_id", (Object)entity.getId());
        quoteWrapper.eq((Object)"bid_flag", (Object)1);
        List quoteList = this.quoteService.list((Wrapper)quoteWrapper);
        for (PicketageQuoteEntity quote : quoteList) {
            if (!StringUtils.isNotEmpty((String)quote.getLegal()) || !StringUtils.isNotEmpty((String)quote.getTelephone())) continue;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            DecimalFormat decimalFormat = new DecimalFormat("0.00");
            try {
                this.sendVerifyCode(quote.getTelephone(), quote.getLegal(), sdf.format(quote.getQuoteTime()), entity.getName(), decimalFormat.format(quote.getBidMny()), null);
            }
            catch (Exception e) {
                logger.error("\u5b9a\u6807\u751f\u6548\u7ed9\u4e2d\u6807\u4f9b\u5e94\u5546\u624b\u673a\u53f7:{}\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff01\u65f6\u95f4\uff1a{}", (Object)quote.getTelephone(), (Object)DateUtil.getCurrentDay((String)"yyyy-MM-dd HH:mm:ss"));
                e.printStackTrace();
            }
        }
    }

    public void sendVerifyCode(String phone, String userName, String publishTime, String title, String amount, String templateCode) throws Exception {
        Assert.hasText((String)phone, (String)"\u7535\u8bdd\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject messageParam = new JSONObject();
        messageParam.put("phone", (Object)phone);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userName", userName);
        params.put("publishTime", publishTime);
        params.put("title", title);
        params.put("amount", amount);
        messageParam.put("params", params);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)templateCode)) {
            messageParam.put(TEMPLATE_CODE, (Object)DEFAULT_TEMPLATE_CODE);
        } else {
            messageParam.put(TEMPLATE_CODE, (Object)templateCode);
        }
        logger.info("\u53d1\u9001\u77ed\u4fe1\u53c2\u6570\uff1a[{}]", (Object)messageParam);
        String messageUrl = this.environmentTools.getBaseHost() + "/ejc-message-web/no_auth/sms/sendMessage";
        String responseStr = HttpTookit.postByJson((String)messageUrl, (String)JSON.toJSONString((Object)messageParam));
        logger.info("\u5411\u624b\u673a\u53f7[{}]\u53d1\u9001\u77ed\u4fe1\u7ed3\u679c\uff1a[{}]", (Object)phone, (Object)responseStr);
        CommonResponse response = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
        if (!response.isSuccess()) {
            throw new BusinessException("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff01");
        }
    }

    @Override
    public CommonResponse<JSONObject> handlePrintDetail(String detailJsonStr) {
        if (StringUtils.isBlank((String)detailJsonStr)) {
            return CommonResponse.success(null);
        }
        JSONObject data = JSONObject.parseObject((String)detailJsonStr);
        if (null == data) {
            return CommonResponse.success(null);
        }
        JSONObject detailJson = data.getJSONObject("detailJson");
        if (null == detailJson) {
            return CommonResponse.success(null);
        }
        JSONObject picketage = detailJson.getJSONObject("MaterialPicketage");
        if (null == picketage) {
            return CommonResponse.success(null);
        }
        Long id = (Long)picketage.get((Object)"id");
        if (null == picketage.get((Object)"MaterialPicketageQuote")) {
            List picketageQuoteList = (List)picketage.get((Object)"MaterialPicketageQuote");
            Map<Object, Object> purchaseListMap = new HashMap();
            QueryWrapper quotePurchaseWrapper = new QueryWrapper();
            quotePurchaseWrapper.eq((Object)"picketage_id", (Object)id);
            List purchaseDetailEntities = this.purchaseDetailService.list((Wrapper)quotePurchaseWrapper);
            if (CollectionUtils.isNotEmpty((Collection)purchaseDetailEntities)) {
                purchaseListMap = purchaseDetailEntities.stream().collect(Collectors.groupingBy(PicketageQuoteDetailEntity::getPicketageQuoteId));
            }
            for (JSONObject quote : picketageQuoteList) {
                Integer bidFlag = (Integer)quote.get((Object)"bidFlag");
                if (bidFlag != 1 || !CollectionUtils.isNotEmpty((Collection)purchaseDetailEntities)) continue;
                quote.put("PicketageQuotePurchaseDetail", purchaseListMap.get(quote.get((Object)"id")));
            }
            picketage.put("MaterialPicketageQuote", (Object)picketageQuoteList);
        }
        picketage.put("AAA", (Object)"picketageQuoteList");
        detailJson.put("MaterialPicketage", (Object)picketage);
        return CommonResponse.success((Object)detailJson);
    }
}

