package com.ejianc.business.othprice.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.othprice.bean.PicketageEntity;
import com.ejianc.business.othprice.vo.PicketageVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

/**
 * 材料定标
 * 
 * @author generator
 * 
 */
public interface IPicketageService extends IBaseService<PicketageEntity> {

    boolean insertOrUpdate(PicketageEntity entity);

    boolean insertOrUpdateRef(PicketageEntity entity);

    void  checkRefSave(PicketageEntity entity);
    void pushPicketage(Long billId);

    void rollBackPicketage(Long billId);

    /**
     *  根据询价单 id 查询 询价清单 和报价记录
     * @param inquiryId
     * @return 询价清单--{purchaseList、rentList} 报价记录--{quoteList} 清单数量统计--{totalMap}
     */
    CommonResponse<JSONObject> queryByInquiryToDetailAndQuote(String inquiryId);

    PicketageVO queryMaterialPicketageDetail(Long id);

    PicketageVO queryMaterialPriceArea(PicketageVO vo);
    void sendMsg(Long id);

    JSONObject queryDetailToRef(Long id);

    /**
     * 定标打印模板配置
     * @param detailJsonStr
     * @return
     */
    CommonResponse<JSONObject> handlePrintDetail(String detailJsonStr);
}
