package com.ejianc.business.othprice.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.material.vo.MaterialContractDetailSubVO;
import com.ejianc.business.othprice.bean.OtherApplySubEntity;
import com.ejianc.business.othprice.vo.ImportOtherInquiryDetailVO;
import com.ejianc.business.othprice.vo.OtherApplySubVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.*;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.othprice.bean.OtherApplyEntity;
import com.ejianc.business.othprice.service.IOtherApplyService;
import com.ejianc.business.othprice.vo.OtherApplyVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 其他询价申请
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("otherApply")
public class OtherApplyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "OTHER_APPLY";//此处需要根据实际修改

    @Autowired
    private IOtherApplyService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherApplyVO> saveOrUpdate(@RequestBody OtherApplyVO saveOrUpdateVO) {
        OtherApplyEntity entity = BeanMapper.map(saveOrUpdateVO, OtherApplyEntity.class);
        String billCode = entity.getBillCode();
        if (StringUtils.isNotBlank(billCode)) {
            Long id = entity.getId();
            LambdaQueryWrapper<OtherApplyEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(OtherApplyEntity::getTenantId, InvocationInfoProxy.getTenantid());
            queryWrapper.eq(OtherApplyEntity::getBillCode, billCode);
            queryWrapper.ne(id != null, OtherApplyEntity::getId, id);
            int count = service.count(queryWrapper);
            if (count > 0) {
                throw new BusinessException("保存失败，单据编码重复");
            }

        } else {
            CommonResponse<String> billCodeRes = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCodeRes.isSuccess()) {
                entity.setBillCode(billCodeRes.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<OtherApplySubEntity> materialDetailList = entity.getOtherApplySubList();
        if (CollectionUtils.isNotEmpty(materialDetailList)) {
            String materialTypeNames = "";
            Set materialTypeNamesSet = new HashSet();
            for (OtherApplySubEntity materialContractDetailSubVO : materialDetailList) {
                if (!"del".equals(materialContractDetailSubVO.getRowState())) {
                    if (StringUtils.isNotBlank(materialTypeNames)) {
                        if (!materialTypeNamesSet.contains(materialContractDetailSubVO.getDetailName())) {
                            materialTypeNames += "、" + materialContractDetailSubVO.getDetailName();
                            materialTypeNamesSet.add(materialContractDetailSubVO.getDetailName());
                        }
                    } else {
                        materialTypeNames += materialContractDetailSubVO.getDetailName();
                        materialTypeNamesSet.add(materialContractDetailSubVO.getDetailName());
                    }
                }
            }
            entity.setDetailNames(materialTypeNames);
        }

        service.saveOrUpdate(entity, false);
            OtherApplyVO vo = BeanMapper.map(entity, OtherApplyVO.class);
            return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherApplyVO> queryDetail(Long id) {
    	OtherApplyEntity entity = service.selectById(id);
    	OtherApplyVO vo = BeanMapper.map(entity, OtherApplyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OtherApplyVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (OtherApplyVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(OtherApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OtherApplyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode","applyTitle","name","projectName","detailNames","applyPerson"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<OtherApplyEntity> page = service.queryPage(param,false);
        IPage<OtherApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OtherApplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode","applyTitle","name","projectName","detailNames","applyPerson"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OtherApplyEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("OtherApply-export.xlsx", beans, response);
    }

    /**
     * 其他询价导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "other-apply-import.xlsx", "其他询价申请导入模板");
    }


    /**
     * 其他询价excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<OtherApplySubVO> successList = new ArrayList<>();
            List<OtherApplySubVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 6) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    OtherApplySubVO otherApplySubVO = new OtherApplySubVO();
                        otherApplySubVO.setCode(datas.get(0).trim());
                        otherApplySubVO.setDetailName(datas.get(1).trim());
                        otherApplySubVO.setModel(datas.get(2).trim());
                        otherApplySubVO.setUnit(datas.get(3).trim());
                    if (StringUtils.isNotBlank(datas.get(4))) {
                        try {
                            otherApplySubVO.setApplyNum(ComputeUtil.scale(new BigDecimal(datas.get(4)), 8));
                        } catch (Exception e) {
                            otherApplySubVO.setErrorMessage("数量必须为数字");
                        }
                    }
                        otherApplySubVO.setRemark(datas.get(5));


                    if (org.apache.commons.lang.StringUtils.isNotEmpty(otherApplySubVO.getErrorMessage())) {
                        errorList.add(otherApplySubVO);
                    } else {
                        successList.add(otherApplySubVO);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }


    @RequestMapping(value = "/referTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> referTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                               @RequestParam String condition
    ) {
        if (org.apache.commons.lang.StringUtils.isEmpty(condition) || !condition.contains("orgId")) {
            throw new BusinessException("查询参数不正确！");
        }
        JSONObject conditionJson = JSONObject.parseObject(condition);
        Long orgId = conditionJson.getLong("orgId");
        Long projectId = conditionJson.getLong("projectId");
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("createTime", "desc");
        if (null != projectId) {
            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }
        queryParam.setOrderMap(orderMap);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode","applyTitle","name","projectName","detailNames","applyPerson"));
        /** 数据隔离 参数组织orgId本下 */
        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 已提交的数据 或者 审批通过的数据 */
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<OtherApplyEntity> dataList = service.queryList(queryParam, false);
        List<Map> resultMapList = new ArrayList<>();
        Map map = null;
        for (OtherApplyEntity entity : dataList) {
            QueryParam queryApplySubParam = new QueryParam();
            queryApplySubParam.getParams().put("pid", new Parameter(QueryParam.EQ, entity.getId()));
            List<OtherApplySubVO> subVOList = service.queryApplySubList(null,queryApplySubParam);
            if (CollectionUtils.isEmpty(subVOList)){
                continue;
            }
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", entity.getId());
            map.put("name", entity.getName());
            map.put("code", entity.getBillCode());
            map.put("parentId", "000001");
            resultMapList.add(map);
        }
        if(CollectionUtils.isNotEmpty(resultMapList)){
            map = new HashMap<>();
            map.put("id", "000001");
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", "000001");
            map.put("name", "全部");
            map.put("code", "000001");
            map.put("parentId", null);
            resultMapList.add(map);
        }

        return ResultAsTree.createTreeData(resultMapList);
    }



    @RequestMapping(value = "/refSubData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OtherApplySubVO>> refdata(@RequestParam Integer pageNumber,
                                                        @RequestParam Integer pageSize,
                                                        String relyCondition,
                                                        @RequestParam(required = false) String condition,
                                                        String relyNode,
                                                        String searchText,
                                                        @RequestParam(required = false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("model");
        fuzzyFields.add("unit");
        Map<String, Parameter> param = queryParam.getParams();
        //是否查询全部申请合计
        boolean queryAllFlag = false;
        if (!org.apache.commons.lang.StringUtils.isEmpty(relyCondition)) {
            String pid = relyCondition.split("=")[1];
            if(!"000001".equals(pid)){
                param.put("pid", new Parameter(QueryParam.EQ, pid));
            } else {
                queryAllFlag = true;
            }

        } else {
            queryAllFlag = true;
        }

        if (org.apache.commons.lang.StringUtils.isNotBlank(searchObject)) {
            JSONObject search = JSONObject.parseObject(searchObject);
            for (String key : search.keySet()) {
                queryParam.getParams().put(key, new Parameter(QueryParam.LIKE, search.get(key).toString()));
            }
        }

        IPage<OtherApplySubVO> pageData = new Page<>(queryParam.getPageIndex(), queryParam.getPageSize());
        List<OtherApplySubVO> list = null;
        if(queryAllFlag){
            JSONObject conditionJson = JSONObject.parseObject(condition);
            Long orgId = conditionJson.getLong("orgId") != null ? conditionJson.getLong("orgId") : InvocationInfoProxy.getOrgId();
            Long projectId = conditionJson.getLong("projectId");
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            queryParam.getParams().put("applyNum", new Parameter(QueryParam.GT, 0));
            list = service.queryAllApplyData(pageData, queryParam, projectId);
        } else {
            list = service.queryApplySubList(pageData, queryParam);
        }

        IPage<OtherApplySubVO> voPage = null;
        if (pageData != null) {
            voPage = new Page<>();
            voPage.setCurrent(pageData.getCurrent());
            voPage.setPages(pageData.getPages());
            voPage.setTotal(pageData.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(list);
        }
        return CommonResponse.success("查询数表参照成功", voPage);
    }
    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refOtherApplyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OtherApplyVO>> refOtherApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OtherApplyEntity> page = service.queryPage(param,false);
        IPage<OtherApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OtherApplyVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
