package com.ejianc.business.othprice.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bidprice.consts.InquiryStateEnum;
import com.ejianc.business.bidprice.material.vo.MaterialPicketageVO;
import com.ejianc.business.othprice.bean.OtherInquiryEntity;
import com.ejianc.business.othprice.bean.PicketageEntity;
import com.ejianc.business.othprice.bean.ResultEntity;
import com.ejianc.business.othprice.service.IOtherInquiryService;
import com.ejianc.business.othprice.service.IPicketageService;
import com.ejianc.business.othprice.service.IResultService;
import com.ejianc.business.othprice.vo.PicketageVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.Map;


@RestController
@RequestMapping("/api/picketage")
public class IPicketageApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPicketageService service;


    @Autowired
    private IResultService materialResultService;

    @Autowired
    private IOtherInquiryService materialInquiryService;

    /**
     * @Description 修改合同签订金额和签订数量
     * @Param vo
     * @Return String
     */
    @RequestMapping(value = "/updateContractSignMny", method = RequestMethod.POST)
    public CommonResponse<String> updateContractSignMny(@RequestBody PicketageVO vo) {
        //定标结果id
        Long resultId = vo.getId();
        if (resultId != null) {
            ResultEntity materialResultEntity = materialResultService.getById(resultId);
            // 通过定标结果更新定标合同签订数量和金额
            if (materialResultEntity != null) {
                materialResultEntity.setContractSign(vo.getContractSign());
                materialResultEntity.setContractSignMny(vo.getContractSignMny());
                boolean b = materialResultService.updateById(materialResultEntity);
                logger.info("------定标结果id:{}, 合同签订数量:{}" + resultId, vo.getContractSign());
                if (b) {
                    Long picketageId = materialResultEntity.getPicketageId();
                    QueryWrapper<ResultEntity> queryWrapper = new QueryWrapper<>();
                    queryWrapper.select("IFNULL(sum(contract_sign),0) as num, IFNULL(sum(contract_sign_mny),0) as money")
                            .eq("picketage_id", picketageId);
                    Map<String, Object> map = materialResultService.getMap(queryWrapper);
                    Integer num = map.get("num") != null ?  Integer.valueOf(map.get("num").toString()) : 0;
                    BigDecimal money = ComputeUtil.toBigDecimal(map.get("money"));
                    LambdaUpdateWrapper<PicketageEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.eq(PicketageEntity::getId, picketageId);
                    updateWrapper.set(PicketageEntity::getContractSign, num);
                    updateWrapper.set(PicketageEntity::getContractSignMny, money);
                    service.update(updateWrapper);
                    logger.info("------定标id:{}, 合同签订数量:{}" + picketageId, num);
                    //合同签订后回写询价单状态,合同签订数量大于0为已签订，否则改为已定标
                    LambdaUpdateWrapper<OtherInquiryEntity> inquiryUpdateWrapper = new LambdaUpdateWrapper<>();
                    inquiryUpdateWrapper.eq(OtherInquiryEntity::getId, materialResultEntity.getInquiryId());
                    logger.info("------询价申请id:{}, 合同签订数量:{}" + materialResultEntity.getInquiryId(), num);
                    if (num > 0) {
                        inquiryUpdateWrapper.set(OtherInquiryEntity::getInquiryState, InquiryStateEnum.SIGN_STATE.getCode());
                    } else {
                        inquiryUpdateWrapper.set(OtherInquiryEntity::getInquiryState, InquiryStateEnum.WIN_STATE.getCode());
                    }
                    materialInquiryService.update(inquiryUpdateWrapper);
                }


            }
        }
        return CommonResponse.success("修改合同签订数成功！");
    }

}
