package com.ejianc.business.othprice.service.impl;


import com.ejianc.business.othprice.bean.OtherQuoteEntity;
import com.ejianc.business.othprice.service.IOtherQuoteService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;

@Service("otherQuote")
public class OtherQuoteBpmServiceImpl implements ICommonBusinessService {
	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	@Resource
	private IBillTypeApi billTypeApi;
	@Resource
	private IOtherQuoteService otherQuoteService;

	/**
	 * 终审审核完回调
	 *
	 * @param billId       报价单id
	 * @param state        单据状态
	 * @param billTypeCode 单据类型编码
	 *
	 * @return {@link CommonResponse}<{@link String}>
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("报价单终审审核完回调，billId:{},state:{},billTypeCode:{}", billId, state, billTypeCode);
		OtherQuoteEntity entity = otherQuoteService.selectById(billId);
		if (entity == null) {
			return CommonResponse.error("该报价单不存在！");
		}
		if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
			// 生成报价时间
			entity.setQuoteTime(new Date());
			otherQuoteService.updateById(entity);
		}
		return CommonResponse.success();
	}

}
