package com.ejianc.foundation.outcontract.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 分供方合同评审
 * 
 * @author generator
 * 
 */
public class OutcontractReviewVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long projectId; // 项目id
    private String billCode; // 合同编号
    private String contractName; // 合同名称
    private Long supplier; // 供方单位
    private Long outcontractId; // 合同id
    private String adoptText; // 采用文本
    private String projectLocation; // 工程地点
    private String contractCategory; // 合同类别
    private String approvalFormCode; // 审批表格编号
    private BigDecimal contractPrice; // 合同价款
    private String businessSponsor; // 业务主办单位
    private String qualityStandard; // 质量标准
    private String periodRequirement; // 工期要求
    private String contentOverview; // 分包工程/采购、租赁范围内容概况
    private String paymentMethod; // 付款方式及支付时间

    
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    
    public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getContractName() {
		return contractName;
	}

	public void setContractName(String contractName) {
		this.contractName = contractName;
	}

	@ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplier() {
        return supplier;
    }

    @ReferDeserialTransfer
    public void setSupplier(Long supplier) {
        this.supplier = supplier;
    }

    public Long getOutcontractId() {
        return outcontractId;
    }

    public void setOutcontractId(Long outcontractId) {
        this.outcontractId = outcontractId;
    }
    public String getAdoptText() {
        return adoptText;
    }

    public void setAdoptText(String adoptText) {
        this.adoptText = adoptText;
    }
    public String getProjectLocation() {
        return projectLocation;
    }

    public void setProjectLocation(String projectLocation) {
        this.projectLocation = projectLocation;
    }
    public String getContractCategory() {
        return contractCategory;
    }

    public void setContractCategory(String contractCategory) {
        this.contractCategory = contractCategory;
    }
    public String getApprovalFormCode() {
        return approvalFormCode;
    }

    public void setApprovalFormCode(String approvalFormCode) {
        this.approvalFormCode = approvalFormCode;
    }
    public BigDecimal getContractPrice() {
        return contractPrice;
    }

    public void setContractPrice(BigDecimal contractPrice) {
        this.contractPrice = contractPrice;
    }
    public String getBusinessSponsor() {
        return businessSponsor;
    }

    public void setBusinessSponsor(String businessSponsor) {
        this.businessSponsor = businessSponsor;
    }
    public String getQualityStandard() {
        return qualityStandard;
    }

    public void setQualityStandard(String qualityStandard) {
        this.qualityStandard = qualityStandard;
    }
    public String getPeriodRequirement() {
        return periodRequirement;
    }

    public void setPeriodRequirement(String periodRequirement) {
        this.periodRequirement = periodRequirement;
    }
    public String getContentOverview() {
        return contentOverview;
    }

    public void setContentOverview(String contentOverview) {
        this.contentOverview = contentOverview;
    }
    public String getPaymentMethod() {
        return paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }
    
}
