package com.ejianc.foundation.outcontract.vo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 记录分供方合同
 * 
 * @author generator
 * 
 */
public class RecordOutcontractVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long userDeptId; // 创建人部门
    private Integer billState; // 单据状态
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectDate; // 生效时间
    private String changeState; // 变更单id
    private String changeReason; // 变更原因
    private String outcontractCode; // 合同变更版本号
    private Long outcontractId; // 合同id
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目id
    private String billCode; // 合同编号
    private String contractName; // 合同名称
    private String type; // 合同类型
    private String integratedCode; // 一体化编码
    private Long signUnit; // 签约单位
    private String signUnitName; // 签约单位名称
    private Long buildUnit; // 实施单位
    private String buildUnitName; // 实施单位名称
    private Long agent; // 经办人
    private String agentName; // 经办人名称

    private Long supplier; // 供方单位
    private String supplierName; // 分供商名称
    private Long supplierTaxPayerType; // 纳税人类型
    private String supplierSocialCreditCode; // 统一社会信用代码
    private String supplierBank; // 开户行
    private String supplierBankAccount; // 开户行账号
    private String supplierContactUser; // 联系人
    private String supplierContactUserAddress; // 联系人地址
    private String supplierContactUserPhone; // 联系人电话
    private String supplierContactUserEmail; // 联系人邮箱
    private String supplierLegal; // 法定代表人
    private String supplierTelephone; // 供方电话
    
    private String subcontractStatus; // 分包状态
    private String pricingForm; // 计价形式
    private BigDecimal buildArea; // 建筑面积
    private BigDecimal contractPrice; // 合同价格
    private BigDecimal contractAreaUnitPrice; // 合同建筑面积单价
    private String performanceStatus; // 履约状态
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date mobilizationDate; // 进场日期
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date exitDate; // 退场日期
    private Long contractTemplateLibrary; // 合同文本
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签订日期
    private String laborSubcontracteMode; // 劳务分包方式
    private String subcontractingContent; // 分包内容
    private String remark; // 备注
    
    private String advanceCharge; // 预付款
    private BigDecimal monthlyPayment; // 月度付款
    private BigDecimal nodePayment; // 节点付款
    private BigDecimal paymentProportion; // 付款比例
    private String balancePayment; // 尾款
    private String warrantyDeposit; // 保修金
    private String afterCompletionPayment; // 竣工后付款
    
    private BigDecimal subcontractTotalAmount; // 分包工程总价汇总表合计金额
    private BigDecimal subcontractUnitTotalAmount; // 分包工程综合单价计价表合计金额
    private BigDecimal contractPriceTotalAmount; // 合同价合计金额
    private BigDecimal leaseItemTotalAmount; // 租赁物进出场费明细表合计金额
    private BigDecimal rentTotalAmount; // 租金明细表合计金额
    private Long fileId; // word合同编辑文件id
    
    //合同评审字段
    private String adoptText; // 采用文本
    private String businessSponsor; // 业务主办单位
    private String qualityStandard; // 质量标准

    private BigDecimal afterChangeAmount; // 变更金额
    private BigDecimal changeAmount; // 变更后金额
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date supplementarySignTime; // 签约时间

    private String booktype; //

    /**导出处理数据start**/
    private String signDateShow; // 签约日期
    private String changeStateName; // 变更状态
    private String billStateName; // 单据状态
    /**导出处理数据end**/

    private List<RecordOutcontractReviewVO> recordOutcontractReviewList = new ArrayList<>(); // 记录分供方合同评审
    private List<RecordOutcontractSubcontractTotalPriceVO> recordOutcontractSubcontractTotalPriceList = new ArrayList<>(); // 记录分包工程总价汇总表
    private List<RecordOutcontractSubcontractUnitPriceVO> recordOutcontractSubcontractUnitPriceList = new ArrayList<>(); // 记录分包工程综合单价计价表
    private List<RecordOutcontractSupplementaryAgreementVO> recordOutcontractSupplementaryAgreementList = new ArrayList<>(); // 记录补充协议
    private List<RecordOutcontractMaterialVO> recordOutcontractMaterialList = new ArrayList<>(); // 记录物资（周转材）合同价
    private List<RecordOutcontractEquipmentLeaseItemVO> recordOutcontractEquipmentLeaseItemList = new ArrayList<>(); // 记录租赁物进出场费明细表
    private List<RecordOutcontractEquipmentRentVO> recordOutcontractEquipmentRentList = new ArrayList<>(); // 记录租金明细表

    private List<RecordOutcontractSupplierVO> recordOutcontractSupplierList = new ArrayList<>(); // 供方信息
    
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public String getOutcontractCode() {
		return outcontractCode;
	}

	public void setOutcontractCode(String outcontractCode) {
		this.outcontractCode = outcontractCode;
	}

	public Long getOutcontractId() {
        return outcontractId;
    }

    public void setOutcontractId(Long outcontractId) {
        this.outcontractId = outcontractId;
    }
    
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
    public String getIntegratedCode() {
        return integratedCode;
    }

    public void setIntegratedCode(String integratedCode) {
        this.integratedCode = integratedCode;
    }
    
    @ReferSerialTransfer(referCode="idm-org")
    public Long getSignUnit() {
        return signUnit;
    }

    @ReferDeserialTransfer
    public void setSignUnit(Long signUnit) {
        this.signUnit = signUnit;
    }
    public String getSignUnitName() {
        return signUnitName;
    }

    public void setSignUnitName(String signUnitName) {
        this.signUnitName = signUnitName;
    }
    
    @ReferSerialTransfer(referCode="idm-org")
    public Long getBuildUnit() {
        return buildUnit;
    }

    @ReferDeserialTransfer
    public void setBuildUnit(Long buildUnit) {
        this.buildUnit = buildUnit;
    }
    public String getBuildUnitName() {
        return buildUnitName;
    }

    public void setBuildUnitName(String buildUnitName) {
        this.buildUnitName = buildUnitName;
    }
    
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getAgent() {
        return agent;
    }

    @ReferDeserialTransfer
    public void setAgent(Long agent) {
        this.agent = agent;
    }
    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplier() {
        return supplier;
    }

    @ReferDeserialTransfer
    public void setSupplier(Long supplier) {
        this.supplier = supplier;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getSupplierTaxPayerType() {
		return supplierTaxPayerType;
	}

	public void setSupplierTaxPayerType(Long supplierTaxPayerType) {
		this.supplierTaxPayerType = supplierTaxPayerType;
	}

	public String getSupplierSocialCreditCode() {
		return supplierSocialCreditCode;
	}

	public void setSupplierSocialCreditCode(String supplierSocialCreditCode) {
		this.supplierSocialCreditCode = supplierSocialCreditCode;
	}

	public String getSupplierLegal() {
		return supplierLegal;
	}

	public void setSupplierLegal(String supplierLegal) {
		this.supplierLegal = supplierLegal;
	}

	public String getSupplierTelephone() {
		return supplierTelephone;
	}

	public void setSupplierTelephone(String supplierTelephone) {
		this.supplierTelephone = supplierTelephone;
	}

	public String getSupplierBank() {
        return supplierBank;
    }

    public void setSupplierBank(String supplierBank) {
        this.supplierBank = supplierBank;
    }
    public String getSupplierBankAccount() {
        return supplierBankAccount;
    }

    public void setSupplierBankAccount(String supplierBankAccount) {
        this.supplierBankAccount = supplierBankAccount;
    }
    public String getSupplierContactUser() {
        return supplierContactUser;
    }

    public void setSupplierContactUser(String supplierContactUser) {
        this.supplierContactUser = supplierContactUser;
    }
    public String getSupplierContactUserAddress() {
        return supplierContactUserAddress;
    }

    public void setSupplierContactUserAddress(String supplierContactUserAddress) {
        this.supplierContactUserAddress = supplierContactUserAddress;
    }
    public String getSupplierContactUserPhone() {
        return supplierContactUserPhone;
    }

    public void setSupplierContactUserPhone(String supplierContactUserPhone) {
        this.supplierContactUserPhone = supplierContactUserPhone;
    }
    public String getSupplierContactUserEmail() {
        return supplierContactUserEmail;
    }

    public void setSupplierContactUserEmail(String supplierContactUserEmail) {
        this.supplierContactUserEmail = supplierContactUserEmail;
    }
    public String getSubcontractStatus() {
        return subcontractStatus;
    }

    public void setSubcontractStatus(String subcontractStatus) {
        this.subcontractStatus = subcontractStatus;
    }
    public String getPricingForm() {
        return pricingForm;
    }

    public void setPricingForm(String pricingForm) {
        this.pricingForm = pricingForm;
    }
    public BigDecimal getBuildArea() {
        return buildArea;
    }

    public void setBuildArea(BigDecimal buildArea) {
        this.buildArea = buildArea;
    }
    public BigDecimal getContractPrice() {
        return contractPrice;
    }

    public void setContractPrice(BigDecimal contractPrice) {
        this.contractPrice = contractPrice;
    }
    public BigDecimal getContractAreaUnitPrice() {
        return contractAreaUnitPrice;
    }

    public void setContractAreaUnitPrice(BigDecimal contractAreaUnitPrice) {
        this.contractAreaUnitPrice = contractAreaUnitPrice;
    }
    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }
    public Date getMobilizationDate() {
        return mobilizationDate;
    }

    public void setMobilizationDate(Date mobilizationDate) {
        this.mobilizationDate = mobilizationDate;
    }
    public Date getExitDate() {
        return exitDate;
    }

    public void setExitDate(Date exitDate) {
        this.exitDate = exitDate;
    }
    
    @ReferSerialTransfer(referCode="contractCategory")
    public Long getContractTemplateLibrary() {
        return contractTemplateLibrary;
    }

    @ReferDeserialTransfer
    public void setContractTemplateLibrary(Long contractTemplateLibrary) {
        this.contractTemplateLibrary = contractTemplateLibrary;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public String getLaborSubcontracteMode() {
        return laborSubcontracteMode;
    }

    public void setLaborSubcontracteMode(String laborSubcontracteMode) {
        this.laborSubcontracteMode = laborSubcontracteMode;
    }
    public String getSubcontractingContent() {
        return subcontractingContent;
    }

    public void setSubcontractingContent(String subcontractingContent) {
        this.subcontractingContent = subcontractingContent;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getAdvanceCharge() {
        return advanceCharge;
    }

    public void setAdvanceCharge(String advanceCharge) {
        this.advanceCharge = advanceCharge;
    }
    public BigDecimal getMonthlyPayment() {
        return monthlyPayment;
    }

    public void setMonthlyPayment(BigDecimal monthlyPayment) {
        this.monthlyPayment = monthlyPayment;
    }
    public BigDecimal getNodePayment() {
        return nodePayment;
    }

    public void setNodePayment(BigDecimal nodePayment) {
        this.nodePayment = nodePayment;
    }
    public String getBalancePayment() {
        return balancePayment;
    }

    public void setBalancePayment(String balancePayment) {
        this.balancePayment = balancePayment;
    }
    public String getWarrantyDeposit() {
        return warrantyDeposit;
    }

    public void setWarrantyDeposit(String warrantyDeposit) {
        this.warrantyDeposit = warrantyDeposit;
    }
    public BigDecimal getSubcontractTotalAmount() {
        return subcontractTotalAmount;
    }

    public void setSubcontractTotalAmount(BigDecimal subcontractTotalAmount) {
        this.subcontractTotalAmount = subcontractTotalAmount;
    }
    public BigDecimal getSubcontractUnitTotalAmount() {
        return subcontractUnitTotalAmount;
    }

    public void setSubcontractUnitTotalAmount(BigDecimal subcontractUnitTotalAmount) {
        this.subcontractUnitTotalAmount = subcontractUnitTotalAmount;
    }
    public BigDecimal getContractPriceTotalAmount() {
        return contractPriceTotalAmount;
    }

    public void setContractPriceTotalAmount(BigDecimal contractPriceTotalAmount) {
        this.contractPriceTotalAmount = contractPriceTotalAmount;
    }
    public BigDecimal getLeaseItemTotalAmount() {
        return leaseItemTotalAmount;
    }

    public void setLeaseItemTotalAmount(BigDecimal leaseItemTotalAmount) {
        this.leaseItemTotalAmount = leaseItemTotalAmount;
    }
    public BigDecimal getRentTotalAmount() {
        return rentTotalAmount;
    }

    public void setRentTotalAmount(BigDecimal rentTotalAmount) {
        this.rentTotalAmount = rentTotalAmount;
    }
    public Long getFileId() {
        return fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }
    
     public List<RecordOutcontractReviewVO> getRecordOutcontractReviewList() {
        return recordOutcontractReviewList;
     }

     public void setRecordOutcontractReviewList(List<RecordOutcontractReviewVO> recordOutcontractReviewList) {
        this.recordOutcontractReviewList = recordOutcontractReviewList;
     }
     public List<RecordOutcontractSubcontractTotalPriceVO> getRecordOutcontractSubcontractTotalPriceList() {
        return recordOutcontractSubcontractTotalPriceList;
     }

     public void setRecordOutcontractSubcontractTotalPriceList(List<RecordOutcontractSubcontractTotalPriceVO> recordOutcontractSubcontractTotalPriceList) {
        this.recordOutcontractSubcontractTotalPriceList = recordOutcontractSubcontractTotalPriceList;
     }
     public List<RecordOutcontractSubcontractUnitPriceVO> getRecordOutcontractSubcontractUnitPriceList() {
        return recordOutcontractSubcontractUnitPriceList;
     }

     public void setRecordOutcontractSubcontractUnitPriceList(List<RecordOutcontractSubcontractUnitPriceVO> recordOutcontractSubcontractUnitPriceList) {
        this.recordOutcontractSubcontractUnitPriceList = recordOutcontractSubcontractUnitPriceList;
     }
     public List<RecordOutcontractSupplementaryAgreementVO> getRecordOutcontractSupplementaryAgreementList() {
        return recordOutcontractSupplementaryAgreementList;
     }

     public void setRecordOutcontractSupplementaryAgreementList(List<RecordOutcontractSupplementaryAgreementVO> recordOutcontractSupplementaryAgreementList) {
        this.recordOutcontractSupplementaryAgreementList = recordOutcontractSupplementaryAgreementList;
     }
     public List<RecordOutcontractMaterialVO> getRecordOutcontractMaterialList() {
        return recordOutcontractMaterialList;
     }

     public void setRecordOutcontractMaterialList(List<RecordOutcontractMaterialVO> recordOutcontractMaterialList) {
        this.recordOutcontractMaterialList = recordOutcontractMaterialList;
     }
     public List<RecordOutcontractEquipmentLeaseItemVO> getRecordOutcontractEquipmentLeaseItemList() {
        return recordOutcontractEquipmentLeaseItemList;
     }

     public void setRecordOutcontractEquipmentLeaseItemList(List<RecordOutcontractEquipmentLeaseItemVO> recordOutcontractEquipmentLeaseItemList) {
        this.recordOutcontractEquipmentLeaseItemList = recordOutcontractEquipmentLeaseItemList;
     }
     public List<RecordOutcontractEquipmentRentVO> getRecordOutcontractEquipmentRentList() {
        return recordOutcontractEquipmentRentList;
     }

     public void setRecordOutcontractEquipmentRentList(List<RecordOutcontractEquipmentRentVO> recordOutcontractEquipmentRentList) {
        this.recordOutcontractEquipmentRentList = recordOutcontractEquipmentRentList;
     }

	public List<RecordOutcontractSupplierVO> getRecordOutcontractSupplierList() {
		return recordOutcontractSupplierList;
	}

	public void setRecordOutcontractSupplierList(List<RecordOutcontractSupplierVO> recordOutcontractSupplierList) {
		this.recordOutcontractSupplierList = recordOutcontractSupplierList;
	}

	public BigDecimal getPaymentProportion() {
		return paymentProportion;
	}

	public void setPaymentProportion(BigDecimal paymentProportion) {
		this.paymentProportion = paymentProportion;
	}

	public String getAfterCompletionPayment() {
		return afterCompletionPayment;
	}

	public void setAfterCompletionPayment(String afterCompletionPayment) {
		this.afterCompletionPayment = afterCompletionPayment;
	}

	public String getAdoptText() {
		return adoptText;
	}

	public void setAdoptText(String adoptText) {
		this.adoptText = adoptText;
	}

	public String getBusinessSponsor() {
		return businessSponsor;
	}

	public void setBusinessSponsor(String businessSponsor) {
		this.businessSponsor = businessSponsor;
	}

	public String getQualityStandard() {
		return qualityStandard;
	}

	public void setQualityStandard(String qualityStandard) {
		this.qualityStandard = qualityStandard;
	}

	public Long getUserDeptId() {
		return userDeptId;
	}

	public void setUserDeptId(Long userDeptId) {
		this.userDeptId = userDeptId;
	}

	public BigDecimal getAfterChangeAmount() {
		return afterChangeAmount;
	}

	public void setAfterChangeAmount(BigDecimal afterChangeAmount) {
		this.afterChangeAmount = afterChangeAmount;
	}

	public BigDecimal getChangeAmount() {
		return changeAmount;
	}

	public void setChangeAmount(BigDecimal changeAmount) {
		this.changeAmount = changeAmount;
	}

	public Date getSupplementarySignTime() {
		return supplementarySignTime;
	}

	public void setSupplementarySignTime(Date supplementarySignTime) {
		this.supplementarySignTime = supplementarySignTime;
	}

    public String getBooktype() {
        return booktype;
    }

    public void setBooktype(String booktype) {
        this.booktype = booktype;
    }

    public String getSignDateShow() {
        return signDateShow;
    }

    public void setSignDateShow(String signDateShow) {
        this.signDateShow = signDateShow;
    }

    public String getChangeStateName() {
        return changeStateName;
    }

    public void setChangeStateName(String changeStateName) {
        this.changeStateName = changeStateName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
