package com.ejianc.foundation.sealApproval.vo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 用印审批
 * 
 * @author generator
 * 
 */
public class SealApprovalVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long changeOutcontractId; // 变更合同id
    private String changeReason; // 变更原因
    private String supplementaryAgreementName; // 合同补充协议名称
    private BigDecimal afterChangeAmount; // 变更后金额
    private BigDecimal changeAmount; // 变更金额
    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private Long applyDept; // 申请部门
    private String applyDeptName; // 申请部门名称
    private Integer sealCount; // 用印数量（次数）
    private Integer sealCountCopy; // 用印数量（份数）
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date applyDate; // 申请日期
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private String employeePhone; // 经办人联系电话
    private String memo; // 备注
    
    private BigDecimal contractPrice; // 合同额
    
    private Long printUnit; // 用印单位
    
    private String printUnitName; // 用印单位

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date printTime;	//用印时间

    private String printState; // 1：已用印，0未用印
    
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outDate; // 借出日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date returnDate; // 归还日期
    private String sealReasons; // 用印事由
    private String bid; // 投标
    private String certification; // 资格审查
    private String contract; // 合同
    private String lawsuit; // 诉讼
    private String prove; // 证明
    private String guarantee; // 担保
    private String excellence; // 创优
    private String engineering; // 工程资料
    private String companySeal; // 公司章
    private String legalSeal; // 法人代表章
    private String contractSeal; // 合同专用章
    private String partySeal; // 党委章
    private String disciplineSeal; // 纪委章
    private String otherSeal; // 其他章
    private String sealMemo; // 其他章备注
    private String signed; // 签约
    private String others; // 其他
    private String billStateName; //单据状态名称
    private List<String> seal;
    private List<String> sealCategory;
    private List<String> text;
    private String sealContent;//用印内容
    private String stampCategory;//印章种类
    private String contractType; // 合同类型
    private String sealLend; // 印章借出
    	//导出内容
    private String printTimeShow; // 用印时间
    private String applyDateShow; // 用印时间

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    @ReferSerialTransfer(referCode="ejc-zjkj-outcontract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getApplyDept() {
        return applyDept;
    }
    @ReferDeserialTransfer
    public void setApplyDept(Long applyDept) {
        this.applyDept = applyDept;
    }
    public String getApplyDeptName() {
        return applyDeptName;
    }

    public void setApplyDeptName(String applyDeptName) {
        this.applyDeptName = applyDeptName;
    }
    public Integer getSealCount() {
		return sealCount;
	}

	public void setSealCount(Integer sealCount) {
		this.sealCount = sealCount;
	}

	public Integer getSealCountCopy() {
		return sealCountCopy;
	}

	public void setSealCountCopy(Integer sealCountCopy) {
		this.sealCountCopy = sealCountCopy;
	}

	public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeePhone() {
        return employeePhone;
    }

    public void setEmployeePhone(String employeePhone) {
        this.employeePhone = employeePhone;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public Date getReturnDate() {
        return returnDate;
    }

    public void setReturnDate(Date returnDate) {
        this.returnDate = returnDate;
    }
    public String getSealReasons() {
        return sealReasons;
    }

    public void setSealReasons(String sealReasons) {
        this.sealReasons = sealReasons;
    }
    public String getBid() {
        return bid;
    }

    public void setBid(String bid) {
        this.bid = bid;
    }
    public String getCertification() {
        return certification;
    }

    public void setCertification(String certification) {
        this.certification = certification;
    }
    public String getContract() {
        return contract;
    }

    public void setContract(String contract) {
        this.contract = contract;
    }
    public String getLawsuit() {
        return lawsuit;
    }

    public void setLawsuit(String lawsuit) {
        this.lawsuit = lawsuit;
    }
    public String getProve() {
        return prove;
    }

    public void setProve(String prove) {
        this.prove = prove;
    }
    public String getGuarantee() {
        return guarantee;
    }

    public void setGuarantee(String guarantee) {
        this.guarantee = guarantee;
    }
    public String getExcellence() {
        return excellence;
    }

    public void setExcellence(String excellence) {
        this.excellence = excellence;
    }
    public String getEngineering() {
        return engineering;
    }

    public void setEngineering(String engineering) {
        this.engineering = engineering;
    }
    public String getCompanySeal() {
        return companySeal;
    }

    public void setCompanySeal(String companySeal) {
        this.companySeal = companySeal;
    }
    public String getLegalSeal() {
        return legalSeal;
    }

    public void setLegalSeal(String legalSeal) {
        this.legalSeal = legalSeal;
    }
    public String getContractSeal() {
        return contractSeal;
    }

    public void setContractSeal(String contractSeal) {
        this.contractSeal = contractSeal;
    }
    public String getPartySeal() {
        return partySeal;
    }

    public void setPartySeal(String partySeal) {
        this.partySeal = partySeal;
    }
    public String getDisciplineSeal() {
        return disciplineSeal;
    }

    public void setDisciplineSeal(String disciplineSeal) {
        this.disciplineSeal = disciplineSeal;
    }
    public String getOtherSeal() {
        return otherSeal;
    }

    public void setOtherSeal(String otherSeal) {
        this.otherSeal = otherSeal;
    }

    public String getSealMemo() {
        return sealMemo;
    }

    public void setSealMemo(String sealMemo) {
        this.sealMemo = sealMemo;
    }

    public String getSigned() {
        return signed;
    }

    public void setSigned(String signed) {
        this.signed = signed;
    }
    public String getOthers() {
        return others;
    }

    public void setOthers(String others) {
        this.others = others;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<String> getSeal() {
        return seal;
    }

    public void setSeal(List<String> seal) {
        this.seal = seal;
    }

    public List<String> getSealCategory() {
        return sealCategory;
    }

    public void setSealCategory(List<String> sealCategory) {
        this.sealCategory = sealCategory;
    }

    public List<String> getText() {
        return text;
    }

    public void setText(List<String> text) {
        this.text = text;
    }

    public String getSealContent() {
        return sealContent;
    }

    public void setSealContent(String sealContent) {
        this.sealContent = sealContent;
    }

    public String getStampCategory() {
        return stampCategory;
    }

    public void setStampCategory(String stampCategory) {
        this.stampCategory = stampCategory;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

	public String getSealLend() {
		return sealLend;
	}

	public void setSealLend(String sealLend) {
		this.sealLend = sealLend;
	}

	public BigDecimal getContractPrice() {
		return contractPrice;
	}

	public void setContractPrice(BigDecimal contractPrice) {
		this.contractPrice = contractPrice;
	}

    @ReferSerialTransfer(referCode="idm-org")
	public Long getPrintUnit() {
		return printUnit;
	}

    @ReferDeserialTransfer
	public void setPrintUnit(Long printUnit) {
		this.printUnit = printUnit;
	}

	public String getPrintUnitName() {
		return printUnitName;
	}

	public void setPrintUnitName(String printUnitName) {
		this.printUnitName = printUnitName;
	}

	public Date getPrintTime() {
		return printTime;
	}

	public void setPrintTime(Date printTime) {
		this.printTime = printTime;
	}

	public String getPrintState() {
		return printState;
	}

	public void setPrintState(String printState) {
		this.printState = printState;
	}

	public String getPrintTimeShow() {
		return printTimeShow;
	}

	public void setPrintTimeShow(String printTimeShow) {
		this.printTimeShow = printTimeShow;
	}

	public String getApplyDateShow() {
		return applyDateShow;
	}

	public void setApplyDateShow(String applyDateShow) {
		this.applyDateShow = applyDateShow;
	}

    @ReferSerialTransfer(referCode="ejc-zjkj-change-outcontract")
    public Long getChangeOutcontractId() {
        return changeOutcontractId;
    }

    @ReferDeserialTransfer
    public void setChangeOutcontractId(Long changeOutcontractId) {
        this.changeOutcontractId = changeOutcontractId;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public String getSupplementaryAgreementName() {
        return supplementaryAgreementName;
    }

    public void setSupplementaryAgreementName(String supplementaryAgreementName) {
        this.supplementaryAgreementName = supplementaryAgreementName;
    }

    public BigDecimal getAfterChangeAmount() {
        return afterChangeAmount;
    }

    public void setAfterChangeAmount(BigDecimal afterChangeAmount) {
        this.afterChangeAmount = afterChangeAmount;
    }

    public BigDecimal getChangeAmount() {
        return changeAmount;
    }

    public void setChangeAmount(BigDecimal changeAmount) {
        this.changeAmount = changeAmount;
    }
}
