package com.ejianc.foundation.outcontract.api;

import java.util.List;

import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejianc.foundation.outcontract.hystrix.OutcontractHystrix;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 中建科技分供方合同rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-outcontract-web", url="${common.env.feign-client-url}", path="ejc-outcontract-web", fallback = OutcontractHystrix.class)
public interface IOutcontractApi {

	/**
	 * 根据合同id及清单编码查询清单详情
	 *
	 * @param id
	 * @return
	 */
	@GetMapping("/api/outcontract/queryListBycontractIdAndCode")
	CommonResponse<List<OutcontractSubcontractUnitPriceVO>> queryListBycontractIdAndCode(@RequestParam(value = "contractId") Long contractId, @RequestParam(value = "listCode") String listCode);

	/**
	 * 根据合同id及清单编码查询清单详情
	 *
	 * @param id
	 * @return
	 */
	@GetMapping("/api/outcontract/queryDetail")
	CommonResponse<OutcontractVO> queryDetail(@RequestParam(value = "id") Long id);

}
