package com.ejianc.foundation.calibration.api;

import com.ejianc.foundation.calibration.hystrix.CalibrationHystrix;
import com.ejianc.foundation.calibration.vo.CalibrationVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 中建科技招标(定标)信息rpc服务
 *
 * @author
 *
 */
@FeignClient(name= "ejc-outcontract-web", url="${common.env.feign-client-url}", path="ejc-outcontract-web", fallback = CalibrationHystrix.class)
public interface ICalibrationApi {

	/**
	 * 根据招标(定标)信息id详情
	 *
	 * @param id
	 * @return
	 */
	@GetMapping("/api/calibration/queryDetail")
	CommonResponse<CalibrationVO> queryDetail(@RequestParam(value = "id") Long id);

}
