package com.ejianc.foundation.outcontract.vo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 分供方合同
 * 
 * @author generator
 * 
 */
public class OutcontractVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String projectStatus; // 项目状态
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date submitDate; // 发起（提交）日期

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date passedDate; // 审批通过

    private String fileState; // 归档状态
    private Long userDeptId; // 创建人部门
    private Integer billState; // 单据状态
    private String changeState; // 变更单id
    private Long changeId; // 项目id
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目id
    private String billCode; // 合同编号
    private String contractName; // 合同名称
    private String type; // 合同类型
    private String integratedCode; // 一体化编码
    private Long signUnit; // 签约单位
    private String signUnitName; // 签约单位名称
    private Long buildUnit; // 实施单位
    private String buildUnitName; // 实施单位名称
    private Long agent; // 经办人
    private String agentName; // 经办人名称

    private Long agentDeptId; // 经办人部门
    private String agentDeptName; // 经办人部门名称
    private Long supplier; // 供方单位
    private String supplierName; // 分供商名称
    private Long supplierTaxPayerType; // 纳税人类型
    private String supplierSocialCreditCode; // 统一社会信用代码
    private String supplierBank; // 开户行
    private String supplierBankAccount; // 开户行账号
    private String supplierContactUser; // 联系人
    private String supplierContactUserAddress; // 联系人地址
    private String supplierContactUserPhone; // 联系人电话
    private String supplierContactUserEmail; // 联系人邮箱
    private String supplierLegal; // 法定代表人
    private String supplierTelephone; // 供方电话
    
    private String subcontractStatus; // 分包状态
    private String pricingForm; // 计价形式
    private BigDecimal buildArea; // 建筑面积
    private BigDecimal contractPrice; // 合同价格
    private BigDecimal contractAreaUnitPrice; // 合同建筑面积单价
    private String performanceStatus; // 履约状态
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date mobilizationDate; // 进场日期
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date exitDate; // 退场日期
    private Long contractTemplateLibrary; // 合同文本
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签订日期
    private String laborSubcontracteMode; // 劳务分包方式
    private String subcontractingContent; // 分包内容
    private String remark; // 备注
    
    private String advanceCharge; // 预付款
    private BigDecimal monthlyPayment; // 月度付款
    private BigDecimal nodePayment; // 节点付款
    private BigDecimal paymentProportion; // 付款比例
    private String balancePayment; // 尾款
    private String warrantyDeposit; // 保修金
    private String afterCompletionPayment; // 竣工后付款
    
    private BigDecimal subcontractTotalAmount; // 分包工程总价汇总表合计金额
    private BigDecimal subcontractUnitTotalAmount; // 分包工程综合单价计价表合计金额
    private BigDecimal contractPriceTotalAmount; // 合同价合计金额
    private BigDecimal leaseItemTotalAmount; // 租赁物进出场费明细表合计金额
    private BigDecimal rentTotalAmount; // 租金明细表合计金额
    private Long fileId; // word合同编辑文件id
    
    //合同评审字段
    private String adoptText; // 采用文本
    private String businessSponsor; // 业务主办单位
    private String qualityStandard; // 质量标准

    private BigDecimal afterChangeAmount; // 变更后金额
    private BigDecimal changeAmount; // 变更金额

    private BigDecimal downwardRate; // 下浮率  计价方式选择按承包合同价款让利费率下浮和定额计价，则下浮率必须填写

    private List<OutcontractSubcontractTotalPriceVO> outcontractSubcontractTotalPriceList = new ArrayList<>(); // 分包工程总价汇总表
    private List<OutcontractSubcontractUnitPriceVO> outcontractSubcontractUnitPriceList = new ArrayList<>(); // 分包工程综合单价计价表
    private List<OutcontractSupplementaryAgreementVO> outcontractSupplementaryAgreementList = new ArrayList<>(); // 补充协议
    private List<OutcontractMaterialVO> outcontractMaterialList = new ArrayList<>(); // 物资（周转材）合同价
    private List<OutcontractEquipmentLeaseItemVO> outcontractEquipmentLeaseItemList = new ArrayList<>(); // 租赁物进出场费明细表
    private List<OutcontractEquipmentRentVO> outcontractEquipmentRentList = new ArrayList<>(); // 租金明细表

    private List<OutcontractSupplierVO> outcontractSupplierList = new ArrayList<>(); // 供方信息
    private List<RecordOutcontractVO> recordOutcontractList = new ArrayList<>(); // 历史信息

    /**导出处理数据start**/
    private String signDateShow; // 签约日期
    private String changeStateName; // 变更状态
    private String billStateName; // 单据状态

    private String mobilizationDateShow; // 进场日期

    private String exitDateShow; // 退场日期
    /**导出处理数据end**/

    /**报表处理数据start**/
    //分包项目内容
    private String labor; //劳务分包内容
    private String major; //劳务分包内容
    private String material; //物资采购
    private String equipment; //机械租赁
    private String turnoverMaterial; //周转材租赁
    private String design; //设计勘察
    private String consultancy; //咨询服务
    private String other;   //其他合同
    //劳务分包方式
    private String packLight; //包轻工
    private String smallMechanical; //轻工辅料小型机械
    private String expandSub; //扩大劳务分包
    private String otherform; //其他形式

    //分包方式
    private String laborAndMaterials; //包工包料
    private String workersAndAuxiliaryMaterials; //包清工辅材
    private String otherForms; //其他形式
    
    //合同价格形式
    private String laborPrice; //劳务分包 按实体工程量对应的固定单价
    private String laborArea;  //劳务分包 按建筑面积平米的每平米固定单价
    private String laborFixedPrice; //固定单价
    private String laborTotalPrice; //固定总价
    private String laborQuotaValuation; //定额计价
    private String majorPrice; // 专业分包 按实体工程量对应的固定单价
    private String rateLower; // 专业分包 按承包合同价款让利费率下浮
    private String majorTotalPrice; // 固定总价
    private String majorQuotaValuation; // 定额计价
    private String materialFixedPrice; // 物资采购 固定单价
    private String adjustablePrice; //可调价格
    private String equipmentFixedPrice; // 机械租赁 固定单价
    private String equipmentOther; //其他
    private String turnoverMaterialFixedPrice; // 周转材租赁 固定单价
    private String turnoverMaterialOther; // 其他
    private String designFixedPrice;// 设计勘察 固定单价
    private String designTotalPrice;//设计勘察 固定总价
    private String designOther;// 其他
    private String consultancyFixedPrice;// 咨询服务 固定单价
    private String consultancyOther;//  其他
    private String otherFixedPrice;// 其他合同 固定单价
    private String other1;// 其他
    /**履约状况累计值start**/
    private BigDecimal projectAmount; //月度结算额 工程款额度
    private BigDecimal laborWagesAmount; //劳务工资额度
    private BigDecimal monthlyProjectAmount; //累计结算额 工程款额度
    private BigDecimal monthlyLaborWagesAmount; //劳务工资额度
    private BigDecimal paidProjectPayment;  //累计已付款 工程款部分
    private BigDecimal payLaborSalaries;  //代付劳务工资部分
    private BigDecimal payProjectPayment;  //累计付款比例 工程款部分
    private BigDecimal laborPayProportion;  //劳务费支付比例
    /**履约状况累计值start**/
    /**报表处理数据end**/
    private String booktype; //
    /**************云筑网字段*****************/
    private String yzwType; // 类型：采购合同（默认）、框架协议、执行合同
    private Long frameworkId; // 框架协议id(当类型为框架协议时，需要选择为框架协议的合同)
    private String signType; // 签章方式
    private String tenderReferId; // 定标信息参照
    private Long calibrationId; // 招标信息
    private String calibrationTenderCode; // 云筑网招标信息编码
    private String yzwOpenContractCode; // 云筑网合同编码
    private String yzwContractCode; // 云筑网合同编码
    private String yzwSignCode; // 云筑网合同签章编码
    /**************云筑网字段*****************/

    /**************天鉴字段*****************/
    private String tjPrintState; // 未用印,已用印,用印中
    private String tjPrintCode; // 用印码
    private String tjPrintId; // 天鉴用印单id
    private Integer pageSeal; // 骑缝章数量（次数）
    private Integer sealCount; // 用印数量（次数）
    /**************天鉴字段*****************/

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
    public String getIntegratedCode() {
        return integratedCode;
    }

    public void setIntegratedCode(String integratedCode) {
        this.integratedCode = integratedCode;
    }
    
    @ReferSerialTransfer(referCode="idm-org")
    public Long getSignUnit() {
        return signUnit;
    }

    @ReferDeserialTransfer
    public void setSignUnit(Long signUnit) {
        this.signUnit = signUnit;
    }
    public String getSignUnitName() {
        return signUnitName;
    }

    public void setSignUnitName(String signUnitName) {
        this.signUnitName = signUnitName;
    }
    
    @ReferSerialTransfer(referCode="idm-org")
    public Long getBuildUnit() {
        return buildUnit;
    }

    @ReferDeserialTransfer
    public void setBuildUnit(Long buildUnit) {
        this.buildUnit = buildUnit;
    }
    public String getBuildUnitName() {
        return buildUnitName;
    }

    public void setBuildUnitName(String buildUnitName) {
        this.buildUnitName = buildUnitName;
    }
    
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getAgent() {
        return agent;
    }

    @ReferDeserialTransfer
    public void setAgent(Long agent) {
        this.agent = agent;
    }
    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplier() {
        return supplier;
    }

    @ReferDeserialTransfer
    public void setSupplier(Long supplier) {
        this.supplier = supplier;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    
    public Long getSupplierTaxPayerType() {
		return supplierTaxPayerType;
	}

	public void setSupplierTaxPayerType(Long supplierTaxPayerType) {
		this.supplierTaxPayerType = supplierTaxPayerType;
	}

	public String getSupplierSocialCreditCode() {
		return supplierSocialCreditCode;
	}

	public void setSupplierSocialCreditCode(String supplierSocialCreditCode) {
		this.supplierSocialCreditCode = supplierSocialCreditCode;
	}

	public String getSupplierLegal() {
		return supplierLegal;
	}

	public void setSupplierLegal(String supplierLegal) {
		this.supplierLegal = supplierLegal;
	}

	public String getSupplierTelephone() {
		return supplierTelephone;
	}

	public void setSupplierTelephone(String supplierTelephone) {
		this.supplierTelephone = supplierTelephone;
	}

	public String getSupplierBank() {
        return supplierBank;
    }

    public void setSupplierBank(String supplierBank) {
        this.supplierBank = supplierBank;
    }
    public String getSupplierBankAccount() {
        return supplierBankAccount;
    }

    public void setSupplierBankAccount(String supplierBankAccount) {
        this.supplierBankAccount = supplierBankAccount;
    }
    public String getSupplierContactUser() {
        return supplierContactUser;
    }

    public void setSupplierContactUser(String supplierContactUser) {
        this.supplierContactUser = supplierContactUser;
    }
    public String getSupplierContactUserAddress() {
        return supplierContactUserAddress;
    }

    public void setSupplierContactUserAddress(String supplierContactUserAddress) {
        this.supplierContactUserAddress = supplierContactUserAddress;
    }
    public String getSupplierContactUserPhone() {
        return supplierContactUserPhone;
    }

    public void setSupplierContactUserPhone(String supplierContactUserPhone) {
        this.supplierContactUserPhone = supplierContactUserPhone;
    }
    public String getSupplierContactUserEmail() {
        return supplierContactUserEmail;
    }

    public void setSupplierContactUserEmail(String supplierContactUserEmail) {
        this.supplierContactUserEmail = supplierContactUserEmail;
    }
    public String getSubcontractStatus() {
        return subcontractStatus;
    }

    public void setSubcontractStatus(String subcontractStatus) {
        this.subcontractStatus = subcontractStatus;
    }
    public String getPricingForm() {
        return pricingForm;
    }

    public void setPricingForm(String pricingForm) {
        this.pricingForm = pricingForm;
    }
    public BigDecimal getBuildArea() {
        return buildArea;
    }

    public void setBuildArea(BigDecimal buildArea) {
        this.buildArea = buildArea;
    }
    public BigDecimal getContractPrice() {
        return contractPrice;
    }

    public void setContractPrice(BigDecimal contractPrice) {
        this.contractPrice = contractPrice;
    }
    public BigDecimal getContractAreaUnitPrice() {
        return contractAreaUnitPrice;
    }

    public void setContractAreaUnitPrice(BigDecimal contractAreaUnitPrice) {
        this.contractAreaUnitPrice = contractAreaUnitPrice;
    }
    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }
    public Date getMobilizationDate() {
        return mobilizationDate;
    }

    public void setMobilizationDate(Date mobilizationDate) {
        this.mobilizationDate = mobilizationDate;
    }
    public Date getExitDate() {
        return exitDate;
    }

    public void setExitDate(Date exitDate) {
        this.exitDate = exitDate;
    }
    
    @ReferSerialTransfer(referCode="contractCategory")
    public Long getContractTemplateLibrary() {
        return contractTemplateLibrary;
    }

    @ReferDeserialTransfer
    public void setContractTemplateLibrary(Long contractTemplateLibrary) {
        this.contractTemplateLibrary = contractTemplateLibrary;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public String getLaborSubcontracteMode() {
        return laborSubcontracteMode;
    }

    public void setLaborSubcontracteMode(String laborSubcontracteMode) {
        this.laborSubcontracteMode = laborSubcontracteMode;
    }
    public String getSubcontractingContent() {
        return subcontractingContent;
    }

    public void setSubcontractingContent(String subcontractingContent) {
        this.subcontractingContent = subcontractingContent;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getAdvanceCharge() {
        return advanceCharge;
    }

    public void setAdvanceCharge(String advanceCharge) {
        this.advanceCharge = advanceCharge;
    }
    public BigDecimal getMonthlyPayment() {
        return monthlyPayment;
    }

    public void setMonthlyPayment(BigDecimal monthlyPayment) {
        this.monthlyPayment = monthlyPayment;
    }
    public BigDecimal getNodePayment() {
        return nodePayment;
    }

    public void setNodePayment(BigDecimal nodePayment) {
        this.nodePayment = nodePayment;
    }
    public String getBalancePayment() {
        return balancePayment;
    }

    public void setBalancePayment(String balancePayment) {
        this.balancePayment = balancePayment;
    }
    public String getWarrantyDeposit() {
        return warrantyDeposit;
    }

    public void setWarrantyDeposit(String warrantyDeposit) {
        this.warrantyDeposit = warrantyDeposit;
    }
    public BigDecimal getSubcontractTotalAmount() {
        return subcontractTotalAmount;
    }

    public void setSubcontractTotalAmount(BigDecimal subcontractTotalAmount) {
        this.subcontractTotalAmount = subcontractTotalAmount;
    }
    public BigDecimal getSubcontractUnitTotalAmount() {
        return subcontractUnitTotalAmount;
    }

    public void setSubcontractUnitTotalAmount(BigDecimal subcontractUnitTotalAmount) {
        this.subcontractUnitTotalAmount = subcontractUnitTotalAmount;
    }
    public BigDecimal getContractPriceTotalAmount() {
        return contractPriceTotalAmount;
    }

    public void setContractPriceTotalAmount(BigDecimal contractPriceTotalAmount) {
        this.contractPriceTotalAmount = contractPriceTotalAmount;
    }
    public BigDecimal getLeaseItemTotalAmount() {
        return leaseItemTotalAmount;
    }

    public void setLeaseItemTotalAmount(BigDecimal leaseItemTotalAmount) {
        this.leaseItemTotalAmount = leaseItemTotalAmount;
    }
    public BigDecimal getRentTotalAmount() {
        return rentTotalAmount;
    }

    public void setRentTotalAmount(BigDecimal rentTotalAmount) {
        this.rentTotalAmount = rentTotalAmount;
    }
    public Long getFileId() {
        return fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }
    
     public List<OutcontractSubcontractTotalPriceVO> getOutcontractSubcontractTotalPriceList() {
        return outcontractSubcontractTotalPriceList;
     }

     public void setOutcontractSubcontractTotalPriceList(List<OutcontractSubcontractTotalPriceVO> outcontractSubcontractTotalPriceList) {
        this.outcontractSubcontractTotalPriceList = outcontractSubcontractTotalPriceList;
     }
     public List<OutcontractSubcontractUnitPriceVO> getOutcontractSubcontractUnitPriceList() {
        return outcontractSubcontractUnitPriceList;
     }

     public void setOutcontractSubcontractUnitPriceList(List<OutcontractSubcontractUnitPriceVO> outcontractSubcontractUnitPriceList) {
        this.outcontractSubcontractUnitPriceList = outcontractSubcontractUnitPriceList;
     }
     public List<OutcontractSupplementaryAgreementVO> getOutcontractSupplementaryAgreementList() {
        return outcontractSupplementaryAgreementList;
     }

     public void setOutcontractSupplementaryAgreementList(List<OutcontractSupplementaryAgreementVO> outcontractSupplementaryAgreementList) {
        this.outcontractSupplementaryAgreementList = outcontractSupplementaryAgreementList;
     }
     public List<OutcontractMaterialVO> getOutcontractMaterialList() {
        return outcontractMaterialList;
     }

     public void setOutcontractMaterialList(List<OutcontractMaterialVO> outcontractMaterialList) {
        this.outcontractMaterialList = outcontractMaterialList;
     }
     public List<OutcontractEquipmentLeaseItemVO> getOutcontractEquipmentLeaseItemList() {
        return outcontractEquipmentLeaseItemList;
     }

     public void setOutcontractEquipmentLeaseItemList(List<OutcontractEquipmentLeaseItemVO> outcontractEquipmentLeaseItemList) {
        this.outcontractEquipmentLeaseItemList = outcontractEquipmentLeaseItemList;
     }
     public List<OutcontractEquipmentRentVO> getOutcontractEquipmentRentList() {
        return outcontractEquipmentRentList;
     }

     public void setOutcontractEquipmentRentList(List<OutcontractEquipmentRentVO> outcontractEquipmentRentList) {
        this.outcontractEquipmentRentList = outcontractEquipmentRentList;
     }

	public List<OutcontractSupplierVO> getOutcontractSupplierList() {
		return outcontractSupplierList;
	}

	public void setOutcontractSupplierList(List<OutcontractSupplierVO> outcontractSupplierList) {
		this.outcontractSupplierList = outcontractSupplierList;
	}

	public List<RecordOutcontractVO> getRecordOutcontractList() {
		return recordOutcontractList;
	}

	public void setRecordOutcontractList(List<RecordOutcontractVO> recordOutcontractList) {
		this.recordOutcontractList = recordOutcontractList;
	}

	public BigDecimal getPaymentProportion() {
		return paymentProportion;
	}

	public void setPaymentProportion(BigDecimal paymentProportion) {
		this.paymentProportion = paymentProportion;
	}

	public String getSignDateShow() {
		return signDateShow;
	}

	public void setSignDateShow(String signDateShow) {
		this.signDateShow = signDateShow;
	}

	public String getChangeStateName() {
		return changeStateName;
	}

	public void setChangeStateName(String changeStateName) {
		this.changeStateName = changeStateName;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

    public String getLabor() {
        return labor;
    }

    public void setLabor(String labor) {
        this.labor = labor;
    }

    public String getMajor() {
        return major;
    }

    public void setMajor(String major) {
        this.major = major;
    }

    public String getMaterial() {
        return material;
    }

    public void setMaterial(String material) {
        this.material = material;
    }

    public String getEquipment() {
        return equipment;
    }

    public void setEquipment(String equipment) {
        this.equipment = equipment;
    }

    public String getTurnoverMaterial() {
        return turnoverMaterial;
    }

    public void setTurnoverMaterial(String turnoverMaterial) {
        this.turnoverMaterial = turnoverMaterial;
    }

    public String getDesign() {
        return design;
    }

    public void setDesign(String design) {
        this.design = design;
    }

    public String getConsultancy() {
        return consultancy;
    }

    public void setConsultancy(String consultancy) {
        this.consultancy = consultancy;
    }

    public String getOther() {
        return other;
    }

    public void setOther(String other) {
        this.other = other;
    }

    public String getPackLight() {
        return packLight;
    }

    public void setPackLight(String packLight) {
        this.packLight = packLight;
    }

    public String getSmallMechanical() {
        return smallMechanical;
    }

    public void setSmallMechanical(String smallMechanical) {
        this.smallMechanical = smallMechanical;
    }

    public String getExpandSub() {
        return expandSub;
    }

    public void setExpandSub(String expandSub) {
        this.expandSub = expandSub;
    }

    public String getOtherform() {
        return otherform;
    }

    public void setOtherform(String otherform) {
        this.otherform = otherform;
    }

    public String getLaborPrice() {
        return laborPrice;
    }

    public void setLaborPrice(String laborPrice) {
        this.laborPrice = laborPrice;
    }

    public String getLaborArea() {
        return laborArea;
    }

    public void setLaborArea(String laborArea) {
        this.laborArea = laborArea;
    }

    public String getLaborFixedPrice() {
        return laborFixedPrice;
    }

    public void setLaborFixedPrice(String laborFixedPrice) {
        this.laborFixedPrice = laborFixedPrice;
    }

    public String getLaborTotalPrice() {
        return laborTotalPrice;
    }

    public void setLaborTotalPrice(String laborTotalPrice) {
        this.laborTotalPrice = laborTotalPrice;
    }

    public String getLaborQuotaValuation() {
        return laborQuotaValuation;
    }

    public void setLaborQuotaValuation(String laborQuotaValuation) {
        this.laborQuotaValuation = laborQuotaValuation;
    }

    public String getMajorPrice() {
        return majorPrice;
    }

    public void setMajorPrice(String majorPrice) {
        this.majorPrice = majorPrice;
    }

    public String getRateLower() {
        return rateLower;
    }

    public void setRateLower(String rateLower) {
        this.rateLower = rateLower;
    }

    public String getMajorTotalPrice() {
        return majorTotalPrice;
    }

    public void setMajorTotalPrice(String majorTotalPrice) {
        this.majorTotalPrice = majorTotalPrice;
    }

    public String getMajorQuotaValuation() {
        return majorQuotaValuation;
    }

    public void setMajorQuotaValuation(String majorQuotaValuation) {
        this.majorQuotaValuation = majorQuotaValuation;
    }

    public String getMaterialFixedPrice() {
        return materialFixedPrice;
    }

    public void setMaterialFixedPrice(String materialFixedPrice) {
        this.materialFixedPrice = materialFixedPrice;
    }

    public String getAdjustablePrice() {
        return adjustablePrice;
    }

    public void setAdjustablePrice(String adjustablePrice) {
        this.adjustablePrice = adjustablePrice;
    }

    public String getEquipmentFixedPrice() {
        return equipmentFixedPrice;
    }

    public void setEquipmentFixedPrice(String equipmentFixedPrice) {
        this.equipmentFixedPrice = equipmentFixedPrice;
    }

    public String getEquipmentOther() {
        return equipmentOther;
    }

    public void setEquipmentOther(String equipmentOther) {
        this.equipmentOther = equipmentOther;
    }

    public String getTurnoverMaterialFixedPrice() {
        return turnoverMaterialFixedPrice;
    }

    public void setTurnoverMaterialFixedPrice(String turnoverMaterialFixedPrice) {
        this.turnoverMaterialFixedPrice = turnoverMaterialFixedPrice;
    }

    public String getTurnoverMaterialOther() {
        return turnoverMaterialOther;
    }

    public void setTurnoverMaterialOther(String turnoverMaterialOther) {
        this.turnoverMaterialOther = turnoverMaterialOther;
    }

    public String getDesignFixedPrice() {
        return designFixedPrice;
    }

    public void setDesignFixedPrice(String designFixedPrice) {
        this.designFixedPrice = designFixedPrice;
    }


    public String getDesignTotalPrice() {
        return designTotalPrice;
    }

    public void setDesignTotalPrice(String designTotalPrice) {
        this.designTotalPrice = designTotalPrice;
    }

    public String getDesignOther() {
        return designOther;
    }

    public void setDesignOther(String designOther) {
        this.designOther = designOther;
    }

    public String getConsultancyFixedPrice() {
        return consultancyFixedPrice;
    }

    public void setConsultancyFixedPrice(String consultancyFixedPrice) {
        this.consultancyFixedPrice = consultancyFixedPrice;
    }

    public String getConsultancyOther() {
        return consultancyOther;
    }

    public void setConsultancyOther(String consultancyOther) {
        this.consultancyOther = consultancyOther;
    }

    public String getOtherFixedPrice() {
        return otherFixedPrice;
    }

    public void setOtherFixedPrice(String otherFixedPrice) {
        this.otherFixedPrice = otherFixedPrice;
    }

    public String getOther1() {
        return other1;
    }

    public void setOther1(String other1) {
        this.other1 = other1;
    }

    public BigDecimal getProjectAmount() {
        return projectAmount;
    }

    public void setProjectAmount(BigDecimal projectAmount) {
        this.projectAmount = projectAmount;
    }

    public BigDecimal getLaborWagesAmount() {
        return laborWagesAmount;
    }

    public void setLaborWagesAmount(BigDecimal laborWagesAmount) {
        this.laborWagesAmount = laborWagesAmount;
    }

    public BigDecimal getMonthlyProjectAmount() {
        return monthlyProjectAmount;
    }

    public void setMonthlyProjectAmount(BigDecimal monthlyProjectAmount) {
        this.monthlyProjectAmount = monthlyProjectAmount;
    }

    public BigDecimal getMonthlyLaborWagesAmount() {
        return monthlyLaborWagesAmount;
    }

    public void setMonthlyLaborWagesAmount(BigDecimal monthlyLaborWagesAmount) {
        this.monthlyLaborWagesAmount = monthlyLaborWagesAmount;
    }

    public BigDecimal getPaidProjectPayment() {
        return paidProjectPayment;
    }

    public void setPaidProjectPayment(BigDecimal paidProjectPayment) {
        this.paidProjectPayment = paidProjectPayment;
    }

    public BigDecimal getPayLaborSalaries() {
        return payLaborSalaries;
    }

    public void setPayLaborSalaries(BigDecimal payLaborSalaries) {
        this.payLaborSalaries = payLaborSalaries;
    }

    public BigDecimal getPayProjectPayment() {
        return payProjectPayment;
    }

    public void setPayProjectPayment(BigDecimal payProjectPayment) {
        this.payProjectPayment = payProjectPayment;
    }

    public BigDecimal getLaborPayProportion() {
        return laborPayProportion;
    }

    public void setLaborPayProportion(BigDecimal laborPayProportion) {
        this.laborPayProportion = laborPayProportion;
    }

	public String getAfterCompletionPayment() {
		return afterCompletionPayment;
	}

	public void setAfterCompletionPayment(String afterCompletionPayment) {
		this.afterCompletionPayment = afterCompletionPayment;
	}

	public String getAdoptText() {
		return adoptText;
	}

	public void setAdoptText(String adoptText) {
		this.adoptText = adoptText;
	}

	public String getBusinessSponsor() {
		return businessSponsor;
	}

	public void setBusinessSponsor(String businessSponsor) {
		this.businessSponsor = businessSponsor;
	}

	public String getQualityStandard() {
		return qualityStandard;
	}

	public void setQualityStandard(String qualityStandard) {
		this.qualityStandard = qualityStandard;
	}

	public String getLaborAndMaterials() {
		return laborAndMaterials;
	}

	public void setLaborAndMaterials(String laborAndMaterials) {
		this.laborAndMaterials = laborAndMaterials;
	}

	public String getWorkersAndAuxiliaryMaterials() {
		return workersAndAuxiliaryMaterials;
	}

	public void setWorkersAndAuxiliaryMaterials(String workersAndAuxiliaryMaterials) {
		this.workersAndAuxiliaryMaterials = workersAndAuxiliaryMaterials;
	}

	public String getOtherForms() {
		return otherForms;
	}

	public void setOtherForms(String otherForms) {
		this.otherForms = otherForms;
	}

	public Long getUserDeptId() {
		return userDeptId;
	}

	public void setUserDeptId(Long userDeptId) {
		this.userDeptId = userDeptId;
	}

	public BigDecimal getAfterChangeAmount() {
		return afterChangeAmount;
	}

	public void setAfterChangeAmount(BigDecimal afterChangeAmount) {
		this.afterChangeAmount = afterChangeAmount;
	}

	public BigDecimal getChangeAmount() {
		return changeAmount;
	}

	public void setChangeAmount(BigDecimal changeAmount) {
		this.changeAmount = changeAmount;
	}

    public String getFileState() {
        return fileState;
    }

    public void setFileState(String fileState) {
        this.fileState = fileState;
    }

    @ReferSerialTransfer(referCode="idm-dept")
    public Long getAgentDeptId() {
        return agentDeptId;
    }

    @ReferDeserialTransfer
    public void setAgentDeptId(Long agentDeptId) {
        this.agentDeptId = agentDeptId;
    }

    public String getAgentDeptName() {
        return agentDeptName;
    }

    public void setAgentDeptName(String agentDeptName) {
        this.agentDeptName = agentDeptName;
    }

    public String getMobilizationDateShow() {
        return mobilizationDateShow;
    }

    public void setMobilizationDateShow(String mobilizationDateShow) {
        this.mobilizationDateShow = mobilizationDateShow;
    }

    public String getExitDateShow() {
        return exitDateShow;
    }

    public void setExitDateShow(String exitDateShow) {
        this.exitDateShow = exitDateShow;
    }

    public String getBooktype() {
        return booktype;
    }

    public void setBooktype(String booktype) {
        this.booktype = booktype;
    }

    public Date getSubmitDate() {
        return submitDate;
    }

    public void setSubmitDate(Date submitDate) {
        this.submitDate = submitDate;
    }

    public Date getPassedDate() {
        return passedDate;
    }

    public void setPassedDate(Date passedDate) {
        this.passedDate = passedDate;
    }

    public BigDecimal getDownwardRate() {
        return downwardRate;
    }

    public void setDownwardRate(BigDecimal downwardRate) {
        this.downwardRate = downwardRate;
    }

    public String getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }

    @ReferSerialTransfer(referCode="zjkj-yzw-calibration")
    public Long getCalibrationId() {
        return calibrationId;
    }

    @ReferDeserialTransfer
    public void setCalibrationId(Long calibrationId) {
        this.calibrationId = calibrationId;
    }

    public String getCalibrationTenderCode() {
        return calibrationTenderCode;
    }

    public void setCalibrationTenderCode(String calibrationTenderCode) {
        this.calibrationTenderCode = calibrationTenderCode;
    }

    public String getYzwContractCode() {
        return yzwContractCode;
    }

    public void setYzwContractCode(String yzwContractCode) {
        this.yzwContractCode = yzwContractCode;
    }

    public String getYzwOpenContractCode() {
        return yzwOpenContractCode;
    }

    public void setYzwOpenContractCode(String yzwOpenContractCode) {
        this.yzwOpenContractCode = yzwOpenContractCode;
    }

    public String getTenderReferId() {
        return tenderReferId;
    }

    public void setTenderReferId(String tenderReferId) {
        this.tenderReferId = tenderReferId;
    }

    public String getYzwSignCode() {
        return yzwSignCode;
    }

    public void setYzwSignCode(String yzwSignCode) {
        this.yzwSignCode = yzwSignCode;
    }

    public String getSignType() {
        return signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getYzwType() {
        return yzwType;
    }

    public void setYzwType(String yzwType) {
        this.yzwType = yzwType;
    }

    @ReferSerialTransfer(referCode="ejc-zjkj-outcontract")
    public Long getFrameworkId() {
        return frameworkId;
    }

    @ReferDeserialTransfer
    public void setFrameworkId(Long frameworkId) {
        this.frameworkId = frameworkId;
    }

    public String getTjPrintState() {
        return tjPrintState;
    }

    public void setTjPrintState(String tjPrintState) {
        this.tjPrintState = tjPrintState;
    }

    public String getTjPrintCode() {
        return tjPrintCode;
    }

    public void setTjPrintCode(String tjPrintCode) {
        this.tjPrintCode = tjPrintCode;
    }

    public String getTjPrintId() {
        return tjPrintId;
    }

    public void setTjPrintId(String tjPrintId) {
        this.tjPrintId = tjPrintId;
    }

    public Integer getPageSeal() {
        return pageSeal;
    }

    public void setPageSeal(Integer pageSeal) {
        this.pageSeal = pageSeal;
    }

    public Integer getSealCount() {
        return sealCount;
    }

    public void setSealCount(Integer sealCount) {
        this.sealCount = sealCount;
    }
}
